/*
 * Decompiled with CFR 0.152.
 */
package apoc.algo;

import apoc.algo.wcc.CCVar;
import apoc.result.CCResult;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Procedure;

public class WeaklyConnectedComponents {
    @Context
    public GraphDatabaseService db;
    @Context
    public Log log;

    @Deprecated
    @Procedure(value="apoc.algo.wcc")
    @Description(value="CALL apoc.algo.wcc() YIELD number of weakly connected components")
    public Stream<CCResult> wcc() {
        LinkedList results = new LinkedList();
        ResourceIterator nodes = this.db.getAllNodes().iterator();
        PrimitiveLongSet allNodes = Primitive.longSet((int)0);
        while (nodes.hasNext()) {
            Node node = (Node)nodes.next();
            if (node.getDegree() == 0) {
                LinkedList<CCVar> result = new LinkedList<CCVar>();
                result.add(new CCVar(node.getId() + "", ((Label)node.getLabels().iterator().next()).name()));
                results.add(result);
                continue;
            }
            allNodes.add(node.getId());
        }
        nodes.close();
        PrimitiveLongIterator it = allNodes.iterator();
        while (it.hasNext()) {
            try {
                long n = it.next();
                LinkedList<CCVar> result = new LinkedList<CCVar>();
                for (long id : this.go(this.db.getNodeById(n), Direction.BOTH, result)) {
                    allNodes.remove(id);
                }
                results.add(result);
            }
            catch (NoSuchElementException e) {
                break;
            }
            it = allNodes.iterator();
        }
        allNodes.close();
        return results.stream().map(x -> new CCResult(x.stream().map(z -> new Long(z.getId())).collect(Collectors.toList()), x.stream().collect(Collectors.groupingBy(CCVar::getType)).entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((List)e.getValue()).size()))));
    }

    private PrimitiveLongSet go(Node node, Direction direction, List<CCVar> result) {
        PrimitiveLongSet visitedIDs = Primitive.longSet((int)0);
        Stack<Node> frontierList = new Stack<Node>();
        frontierList.push(node);
        visitedIDs.add(node.getId());
        result.add(new CCVar(node.getId() + "", ((Label)node.getLabels().iterator().next()).name()));
        while (!frontierList.isEmpty()) {
            node = (Node)frontierList.pop();
            Iterator itR = node.getRelationships(direction).iterator();
            while (itR.hasNext()) {
                Node child = ((Relationship)itR.next()).getOtherNode(node);
                if (visitedIDs.contains(child.getId())) continue;
                visitedIDs.add(child.getId());
                frontierList.push(child);
                result.add(new CCVar(child.getId() + "", ((Label)child.getLabels().iterator().next()).name()));
            }
        }
        return visitedIDs;
    }
}

