/*
 * Decompiled with CFR 0.152.
 */
package apoc.algo.algorithms;

import apoc.algo.algorithms.AlgoIdGenerator;
import apoc.algo.algorithms.Chunks;
import apoc.util.Util;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongIntMap;
import org.neo4j.collection.primitive.PrimitiveLongIntVisitor;
import org.neo4j.graphdb.Result;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;

public class Algorithm
implements AlgoIdGenerator {
    public static final int INITIAL_ARRAY_SIZE = 100000;
    public static final String COMPILED_RUNTIME = "CYPHER runtime=interpreted ";
    private final GraphDatabaseAPI db;
    private final Log log;
    private final ExecutorService pool;
    private int maxAlgoNodeId = 0;
    public int relCount;
    public long readNodeMillis;
    public long readRelationshipMillis;
    private int[] nodeMapping;
    private final PrimitiveLongIntMap nodeMap = Primitive.longIntMap((int)100000);
    public int[] sourceDegreeData;
    public int[] sourceChunkStartingIndex;
    public int[] relationshipTarget;
    public int[] relationshipWeight;
    private Number batchSize;

    public Algorithm(GraphDatabaseAPI db, ExecutorService pool, Log log) {
        this.pool = pool;
        this.db = db;
        this.log = log;
    }

    public boolean readNodeAndRelCypher(String relCypher, String nodeCypher, Number weight, Number batchSize, int concurrency) {
        this.batchSize = batchSize;
        long before = System.currentTimeMillis();
        this.maxAlgoNodeId = this.loadNodes(nodeCypher);
        this.readNodeMillis = System.currentTimeMillis() - before;
        this.log.info("Time to load nodes = " + this.readNodeMillis + " millis. Nodes from nodeCypher: " + this.getNodeCount());
        before = System.currentTimeMillis();
        this.relCount = batchSize == null ? this.loadRelationships(relCypher, weight != null, weight != null ? weight.intValue() : 1) : this.loadRelationshipsBatch(relCypher, weight != null, weight != null ? weight.intValue() : 1, batchSize.intValue(), concurrency);
        this.readRelationshipMillis = System.currentTimeMillis() - before;
        this.log.info("Time for iteration over " + this.relCount + " relations = " + this.readRelationshipMillis + " millis");
        this.nodeMapping = new int[this.getNodeCount()];
        this.nodeMap.visitEntries((PrimitiveLongIntVisitor)new PrimitiveLongIntVisitor<RuntimeException>(){

            public boolean visited(long nodeId, int algoId) throws RuntimeException {
                ((Algorithm)Algorithm.this).nodeMapping[algoId] = (int)nodeId;
                return false;
            }
        });
        return true;
    }

    public int loadNodes(String nodeCypher) {
        if (nodeCypher == null) {
            return 0;
        }
        NodeLoaderVisitor loader = new NodeLoaderVisitor();
        this.db.execute(COMPILED_RUNTIME + nodeCypher).accept((Result.ResultVisitor)loader);
        return loader.nodes;
    }

    @Override
    public int getAlgoNodeId(long node) {
        return this.nodeMap.get(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOrCreateAlgoNodeId(long node) {
        int id = this.nodeMap.get(node);
        if (id != -1) {
            return id;
        }
        PrimitiveLongIntMap primitiveLongIntMap = this.nodeMap;
        synchronized (primitiveLongIntMap) {
            id = this.nodeMap.get(node);
            if (id != -1) {
                return id;
            }
            id = this.maxAlgoNodeId++;
            this.nodeMap.put(node, id);
            return id;
        }
    }

    @Override
    public int getNodeCount() {
        return this.maxAlgoNodeId;
    }

    private static int[] growArray(int[] array, float growFactor) {
        int currentSize = array.length;
        int[] newArray = new int[(int)((float)currentSize * growFactor)];
        System.arraycopy(array, 0, newArray, 0, currentSize);
        return newArray;
    }

    private int loadRelationships(String relCypher, boolean weighted, int defaultWeight) {
        RelationshipLoader loader = new RelationshipLoader(0, weighted, defaultWeight, this);
        this.db.execute(COMPILED_RUNTIME + relCypher).accept((Result.ResultVisitor)loader);
        loader.calculateChunkIndices();
        int totalRelationships = loader.totalRelationships;
        Chunks relationshipTargetChunks = new Chunks(totalRelationships);
        Chunks relationshipWeightChunks = weighted ? new Chunks(totalRelationships).withDefault(defaultWeight) : null;
        int[] offsetTracker = loader.sourceChunkStartingIndex.mergeChunks();
        loader.transformRelData(relationshipTargetChunks, relationshipWeightChunks, offsetTracker);
        this.sourceDegreeData = loader.sourceDegreeData.mergeAllChunks();
        this.sourceChunkStartingIndex = loader.sourceChunkStartingIndex.mergeChunks();
        this.relationshipTarget = relationshipTargetChunks.mergeChunks();
        this.relationshipWeight = relationshipWeightChunks == null ? null : relationshipWeightChunks.mergeAllChunks();
        return totalRelationships;
    }

    private int loadRelationshipsBatch(String relCypher, boolean weighted, int defaultWeight, int batchSize, int threads) {
        this.log.info("Loading relationships in parallel with %d threads, batch-size %d%n%s%n", new Object[]{threads, batchSize, relCypher});
        int batch = 0;
        int totalRelationships = 0;
        int nonLoaded = 0;
        ArrayList<RelationshipLoader> loaders = new ArrayList<RelationshipLoader>();
        do {
            ArrayList<Future<RelationshipLoader>> futures = new ArrayList<Future<RelationshipLoader>>();
            for (int i = 0; i < threads; ++i) {
                int n = batch * batchSize;
                Map<String, Object> params = Util.map("skip", n, "limit", batchSize);
                int task = batch++;
                this.log.info("Starting task %d skip %d limit %d", new Object[]{task, n, batchSize});
                Future<RelationshipLoader> future = Util.inFuture(() -> {
                    RelationshipLoader loader = new RelationshipLoader(task, weighted, defaultWeight, this);
                    this.db.execute(COMPILED_RUNTIME + relCypher, params).accept((Result.ResultVisitor)loader);
                    return loader;
                });
                futures.add(future);
            }
            for (Future future : futures) {
                RelationshipLoader loader = this.get(future);
                this.log.info("Finished task %d relationships %d total %d", new Object[]{loader.getTask(), loader.totalRelationships, totalRelationships += loader.totalRelationships});
                if (loader.totalRelationships == 0) {
                    ++nonLoaded;
                    continue;
                }
                loaders.add(loader);
            }
        } while (nonLoaded == 0);
        int nodeCount = this.getNodeCount();
        Chunks relationshipTargetChunks = new Chunks(totalRelationships);
        Chunks chunks = weighted ? new Chunks(totalRelationships).withDefault(defaultWeight) : null;
        this.log.info("Statistics: %d nodes %d relationships %d loaders", new Object[]{nodeCount, totalRelationships, loaders.size()});
        Chunks sourceDegrees = new Chunks(nodeCount);
        this.log.info("Start: Computing total degrees: %d entries", new Object[]{sourceDegrees.size()});
        for (RelationshipLoader loader : loaders) {
            sourceDegrees.add(loader.sourceDegreeData);
        }
        this.log.info("Done: Computing total degrees");
        this.log.info("Start: Computing total offsets");
        Chunks offsets = sourceDegrees.clone();
        offsets.sumUp();
        this.log.info("Done: Computing total offsets");
        int[] offsetTracker = offsets.mergeChunks();
        int loaderRelationshipEntries = 0;
        for (RelationshipLoader loader : loaders) {
            loaderRelationshipEntries += loader.relData.size();
        }
        this.log.info("Start: Merging loaded relationship information total %d", new Object[]{loaderRelationshipEntries});
        for (RelationshipLoader loader : loaders) {
            loader.transformRelData(relationshipTargetChunks, chunks, offsetTracker);
        }
        this.sourceDegreeData = sourceDegrees.mergeChunks();
        this.sourceChunkStartingIndex = offsets.mergeChunks();
        this.relationshipTarget = relationshipTargetChunks.mergeChunks();
        this.relationshipWeight = chunks == null ? null : chunks.mergeAllChunks();
        this.log.info("Done: Merging loaded relationship information %d relationship targets", new Object[]{this.relationshipTarget.length});
        return totalRelationships;
    }

    private RelationshipLoader get(Future<RelationshipLoader> future) {
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Error loading relationships", e);
        }
    }

    @Override
    public long getMappedNode(int algoId) {
        return this.nodeMapping[algoId];
    }

    private static class RelationshipLoader
    implements Result.ResultVisitor<RuntimeException> {
        private final AlgoIdGenerator algoIdGenerator;
        private final int task;
        private final boolean weighted;
        private final int defaultWeight;
        int totalRelationships = 0;
        int sourceIndex = 0;
        int targetIndex = 0;
        long lastSource = -1L;
        long lastTarget = -1L;
        int relDataIdx = 0;
        private Chunks relData;
        private Chunks relationshipWeight;
        private Chunks sourceDegreeData;
        private Chunks sourceChunkStartingIndex;
        private PrimitiveLongIntMap weights;

        public RelationshipLoader(int task, boolean weighted, int defaultWeight, AlgoIdGenerator algoIdGenerator) {
            this.task = task;
            this.weighted = weighted;
            this.defaultWeight = defaultWeight;
            int nodeCount = algoIdGenerator.getNodeCount();
            this.relData = new Chunks(nodeCount);
            this.algoIdGenerator = algoIdGenerator;
            this.sourceDegreeData = new Chunks(nodeCount).withDefault(0);
            if (weighted) {
                this.weights = Primitive.longIntMap((int)100000);
            }
        }

        public int getTask() {
            return this.task;
        }

        public boolean visit(Result.ResultRow res) throws RuntimeException {
            int weight;
            Number weightValue;
            long target;
            ++this.totalRelationships;
            long source = ((Number)res.get("source")).longValue();
            if (this.lastSource != source) {
                this.sourceIndex = this.algoIdGenerator.getOrCreateAlgoNodeId(source);
                this.relData.set(this.relDataIdx++, -this.sourceIndex - 1);
                this.lastSource = source;
            }
            if (this.lastTarget != (target = ((Number)res.get("target")).longValue())) {
                this.targetIndex = this.algoIdGenerator.getOrCreateAlgoNodeId(target);
                this.lastTarget = target;
            }
            if (this.weighted && (weightValue = res.getNumber("weight")) != null && (weight = weightValue.intValue()) != this.defaultWeight) {
                long key = (long)this.sourceIndex << 32 | (long)this.targetIndex;
                this.weights.put(key, weight);
            }
            this.relData.set(this.relDataIdx++, this.targetIndex);
            this.sourceDegreeData.increment(this.sourceIndex);
            return true;
        }

        private void transformRelData(Chunks relationshipTargetChunks, Chunks relationshipWeightChunks, int[] offsetTracker) {
            if (this.weighted) {
                this.transformRelationshipDataToOffsetStorage(this.relData, this.relDataIdx, this.weights, relationshipTargetChunks, relationshipWeightChunks, offsetTracker);
                this.weights.clear();
            } else {
                this.transformRelationshipDataToOffsetStorage(this.relData, this.relDataIdx, relationshipTargetChunks, offsetTracker);
            }
            this.relData.clear();
        }

        private void transformRelationshipDataToOffsetStorage(Chunks relData, int relDataIdx, PrimitiveLongIntMap weights, Chunks relationshipTarget, Chunks relationshipWeight, int[] offsetTracker) {
            int sourceIndex = 0;
            for (int i = 0; i < relDataIdx; ++i) {
                int id = relData.get(i);
                if (id < 0) {
                    sourceIndex = -id - 1;
                    continue;
                }
                long key = (long)sourceIndex << 32 | (long)id;
                int weight = weights.get(key);
                if (weight != -1) {
                    relationshipWeight.set(offsetTracker[sourceIndex], weight);
                }
                relationshipTarget.set(offsetTracker[sourceIndex], id);
                int n = sourceIndex;
                offsetTracker[n] = offsetTracker[n] + 1;
            }
        }

        private void calculateChunkIndices() {
            int nodes = this.algoIdGenerator.getNodeCount();
            this.sourceChunkStartingIndex = new Chunks(nodes);
            int currentOffset = 0;
            for (int i = 0; i < nodes; ++i) {
                this.sourceChunkStartingIndex.set(i, currentOffset);
                currentOffset += this.sourceDegreeData.get(i);
            }
        }

        private void transformRelationshipDataToOffsetStorage(Chunks relData, int relDataIdx, Chunks relationshipTarget, int[] offsetTracker) {
            int sourceIndex = 0;
            for (int i = 0; i < relDataIdx; ++i) {
                int id = relData.get(i);
                if (id < 0) {
                    sourceIndex = -id - 1;
                    continue;
                }
                int n = sourceIndex;
                int n2 = offsetTracker[n];
                offsetTracker[n] = n2 + 1;
                relationshipTarget.set(n2, id);
            }
        }
    }

    private class NodeLoaderVisitor
    implements Result.ResultVisitor<RuntimeException> {
        int nodes = 0;

        private NodeLoaderVisitor() {
        }

        public boolean visit(Result.ResultRow row) throws RuntimeException {
            Algorithm.this.nodeMap.put(row.getNumber("id").longValue(), this.nodes);
            ++this.nodes;
            return true;
        }
    }
}

