/*
 * Decompiled with CFR 0.152.
 */
package apoc.algo.algorithms;

import apoc.Pools;
import apoc.algo.algorithms.AlgoUtils;
import apoc.algo.algorithms.Algorithm;
import apoc.algo.algorithms.AlgorithmInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Stack;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.procedure.TerminationGuard;

public class BetweennessCentrality
implements AlgorithmInterface {
    public static final int WRITE_BATCH = 100000;
    public final int MINIMUM_BATCH_SIZE = 10000;
    private Algorithm algorithm;
    private Log log;
    GraphDatabaseAPI db;
    ExecutorService pool;
    private int nodeCount;
    private int relCount;
    private AlgorithmInterface.Statistics stats = new AlgorithmInterface.Statistics();
    private PrimitiveIntObjectMap intermediateBcPerThread;
    float[] betweennessCentrality;
    private String property;
    private final TerminationGuard guard;

    public BetweennessCentrality(GraphDatabaseAPI db, ExecutorService pool, Log log, TerminationGuard guard) {
        this.pool = pool;
        this.db = db;
        this.log = log;
        this.guard = guard;
        this.algorithm = new Algorithm(db, pool, log);
    }

    @Override
    public double getResult(long node) {
        float val = -1.0f;
        int logicalIndex = this.algorithm.getAlgoNodeId((int)node);
        if (logicalIndex >= 0 && this.betweennessCentrality.length >= logicalIndex) {
            val = this.betweennessCentrality[logicalIndex];
        }
        return val;
    }

    @Override
    public long numberOfNodes() {
        return this.nodeCount;
    }

    @Override
    public String getPropertyName() {
        return "betweenness_centrality";
    }

    @Override
    public long getMappedNode(int algoId) {
        return this.algorithm.getMappedNode(algoId);
    }

    public boolean readNodeAndRelCypherData(String relCypher, String nodeCypher, Number weight, Number batchSize, int concurrency) {
        boolean success = this.algorithm.readNodeAndRelCypher(relCypher, nodeCypher, weight, batchSize, concurrency);
        this.nodeCount = this.algorithm.getNodeCount();
        this.relCount = this.algorithm.relCount;
        this.stats.readNodeMillis = this.algorithm.readNodeMillis;
        this.stats.readRelationshipMillis = this.algorithm.readRelationshipMillis;
        this.stats.nodes = this.nodeCount;
        this.stats.relationships = this.relCount;
        return success;
    }

    public long numberOfRels() {
        return this.relCount;
    }

    public AlgorithmInterface.Statistics getStatistics() {
        return this.stats;
    }

    public void computeUnweightedSeq() {
        this.computeUnweightedSeq(this.algorithm.sourceDegreeData, this.algorithm.sourceChunkStartingIndex, this.algorithm.relationshipTarget);
    }

    private void computeUnweightedSeq(int[] sourceDegreeData, int[] sourceChunkStartingIndex, int[] relationshipTarget) {
        this.betweennessCentrality = new float[this.nodeCount];
        Arrays.fill(this.betweennessCentrality, 0.0f);
        long before = System.currentTimeMillis();
        int start = 0;
        int end = this.nodeCount;
        this.processNodesInBatch(-1, start, end, sourceDegreeData, sourceChunkStartingIndex, relationshipTarget);
        long after = System.currentTimeMillis();
        long difference = after - before;
        this.log.info("Computations took " + difference + " milliseconds");
        this.stats.computeMillis = difference;
    }

    public void computeUnweightedParallel() {
        this.computeUnweightedParallel(this.algorithm.sourceDegreeData, this.algorithm.sourceChunkStartingIndex, this.algorithm.relationshipTarget);
    }

    public void computeUnweightedParallel(final int[] sourceDegreeData, final int[] sourceChunkStartingIndex, final int[] relationshipTarget) {
        this.betweennessCentrality = new float[this.nodeCount];
        Arrays.fill(this.betweennessCentrality, 0.0f);
        long before = System.currentTimeMillis();
        int numOfThreads = Pools.getNoThreadsInDefaultPool();
        assert (numOfThreads != 0);
        int batchSize = this.nodeCount / numOfThreads;
        int batches = 0;
        if (batchSize > 0) {
            batches = this.nodeCount / batchSize;
        }
        if (batchSize < 10000) {
            batches = 1;
            batchSize = this.nodeCount;
        }
        ArrayList<Future> futures = new ArrayList<Future>(batches);
        this.intermediateBcPerThread = Primitive.intObjectMap();
        int nodeIter = 0;
        int batchNumber = 0;
        while (nodeIter < this.nodeCount) {
            final int start = nodeIter;
            final int end = Integer.min(start + batchSize, this.nodeCount);
            final int threadBatchNo = batchNumber++;
            Future<?> future = this.pool.submit(new Runnable(){

                @Override
                public void run() {
                    BetweennessCentrality.this.processNodesInBatch(threadBatchNo, start, end, sourceDegreeData, sourceChunkStartingIndex, relationshipTarget);
                }
            });
            nodeIter = end;
            futures.add(future);
        }
        this.log.info("Total batches: " + batchNumber);
        AlgoUtils.waitForTasks(futures);
        this.compileResults(batchNumber);
        long after = System.currentTimeMillis();
        long difference = after - before;
        this.log.info("Computations took " + difference + " milliseconds");
        this.stats.computeMillis = difference;
    }

    private void compileResults(int batchNumber) {
        for (int i = 0; i < this.nodeCount; ++i) {
            float value = 0.0f;
            Object batchValue = 0;
            for (int batch = 0; batch < batchNumber; ++batch) {
                batchValue = ((PrimitiveIntObjectMap)this.intermediateBcPerThread.get(batch)).get(i);
                if (batchValue == null) continue;
                value += ((Float)batchValue).floatValue();
            }
            this.betweennessCentrality[i] = value;
        }
    }

    private void processNodesInBatch(int threadBatchNo, int start, int end, int[] sourceDegreeData, int[] sourceChunkStartingIndex, int[] relationshipTarget) {
        Stack<Integer> stack = new Stack<Integer>();
        LinkedList<Integer> queue = new LinkedList<Integer>();
        this.log.info("Thread: " + Thread.currentThread().getName() + " processing " + start + " " + end);
        PrimitiveIntObjectMap predecessors = Primitive.intObjectMap();
        int[] numShortestPaths = new int[this.nodeCount];
        int[] distance = new int[this.nodeCount];
        PrimitiveIntObjectMap map = Primitive.intObjectMap();
        float[] delta = new float[this.nodeCount];
        int processedNode = 0;
        for (int source = start; source < end; ++source) {
            ++processedNode;
            if (sourceDegreeData[source] == 0) continue;
            stack.clear();
            predecessors.clear();
            Arrays.fill(numShortestPaths, 0);
            numShortestPaths[source] = 1;
            Arrays.fill(distance, -1);
            distance[source] = 0;
            queue.clear();
            queue.add(source);
            Arrays.fill(delta, 0.0f);
            while (!queue.isEmpty()) {
                int nodeDequeued = (Integer)queue.remove();
                stack.push(nodeDequeued);
                int chunkIndex = sourceChunkStartingIndex[nodeDequeued];
                int degree = sourceDegreeData[nodeDequeued];
                for (int j = 0; j < degree; ++j) {
                    int target = relationshipTarget[chunkIndex + j];
                    if (distance[target] < 0) {
                        queue.add(target);
                        distance[target] = distance[nodeDequeued] + 1;
                    }
                    if (distance[target] != distance[nodeDequeued] + 1) continue;
                    numShortestPaths[target] = numShortestPaths[target] + numShortestPaths[nodeDequeued];
                    if (!predecessors.containsKey(target)) {
                        ArrayList list = new ArrayList();
                        predecessors.put(target, list);
                    }
                    ((ArrayList)predecessors.get(target)).add(nodeDequeued);
                }
            }
            while (!stack.isEmpty()) {
                int poppedNode = (Integer)stack.pop();
                ArrayList list = (ArrayList)predecessors.get(poppedNode);
                for (int i = 0; list != null && i < list.size(); ++i) {
                    int node = (Integer)list.get(i);
                    assert (numShortestPaths[poppedNode] != 0);
                    double partialDependency = (double)numShortestPaths[node] / (double)numShortestPaths[poppedNode];
                    int n = node;
                    delta[n] = (float)((double)delta[n] + (partialDependency *= 1.0 + (double)delta[poppedNode]));
                }
                if (poppedNode == source || (double)delta[poppedNode] == 0.0) continue;
                if (threadBatchNo == -1) {
                    this.betweennessCentrality[poppedNode] = this.betweennessCentrality[poppedNode] + delta[poppedNode];
                    continue;
                }
                Object storedValue = map.get(poppedNode);
                if (storedValue != null) {
                    map.put(poppedNode, (Object)Float.valueOf(((Float)storedValue).floatValue() + delta[poppedNode]));
                    continue;
                }
                map.put(poppedNode, (Object)Float.valueOf(delta[poppedNode]));
            }
            if (processedNode % 10000 != 0) continue;
            this.log.debug("Thread: " + Thread.currentThread().getName() + " processed " + processedNode);
        }
        this.intermediateBcPerThread.put(threadBatchNo, (Object)map);
        delta = null;
        numShortestPaths = null;
        stack = null;
        queue = null;
        distance = null;
        this.log.debug("Thread: " + Thread.currentThread().getName() + " Finishing " + processedNode);
    }

    public void writeResultsToDB(String property) {
        this.property = property;
        this.stats.write = true;
        long before = System.currentTimeMillis();
        AlgoUtils.writeBackResults(this.pool, this.db, this, 100000, this.guard);
        this.stats.writeMillis = System.currentTimeMillis() - before;
        this.stats.property = this.getPropertyName();
    }
}

