/*
 * Decompiled with CFR 0.152.
 */
package apoc.algo.pagerank;

import apoc.algo.algorithms.AlgoUtils;
import apoc.algo.algorithms.Algorithm;
import apoc.algo.algorithms.AlgorithmInterface;
import apoc.algo.pagerank.PageRank;
import apoc.algo.pagerank.PageRankUtils;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicIntegerArray;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.procedure.TerminationGuard;

public class PageRankArrayStorageParallelCypher
implements PageRank,
AlgorithmInterface {
    public static final int ONE_MINUS_ALPHA_INT = PageRankUtils.toInt(0.15000000000000002);
    public static final int WRITE_BATCH = 100100;
    public static final int INITIAL_ARRAY_SIZE = 100000;
    public final int BATCH_SIZE = 100000;
    private final GraphDatabaseAPI db;
    private final TerminationGuard guard;
    private final Log log;
    private final ExecutorService pool;
    private int nodeCount;
    private int relCount;
    private PageRank.PageRankStatistics stats = new PageRank.PageRankStatistics();
    int[] previousPageRanks;
    private AtomicIntegerArray pageRanksAtomic;
    private Algorithm algorithm;
    private String property;

    public PageRankArrayStorageParallelCypher(GraphDatabaseAPI db, TerminationGuard guard, ExecutorService pool, Log log) {
        this.guard = guard;
        this.pool = pool;
        this.db = db;
        this.log = log;
        this.algorithm = new Algorithm(db, pool, log);
    }

    @Override
    public long getMappedNode(int algoId) {
        return this.algorithm.getMappedNode(algoId);
    }

    private int getNodeIndex(int node) {
        return this.algorithm.getAlgoNodeId(node);
    }

    public boolean readNodeAndRelCypherData(String relCypher, String nodeCypher, Number weight, Number batchSize, int concurrency) {
        boolean success = this.algorithm.readNodeAndRelCypher(relCypher, nodeCypher, weight, batchSize, concurrency);
        this.nodeCount = this.algorithm.getNodeCount();
        this.relCount = this.algorithm.relCount;
        this.stats.readNodeMillis = this.algorithm.readNodeMillis;
        this.stats.readRelationshipMillis = this.algorithm.readRelationshipMillis;
        this.stats.nodes = this.nodeCount;
        this.stats.relationships = this.relCount;
        return success;
    }

    public void compute(int iterations, int[] sourceDegreeData, int[] sourceChunkStartingIndex, int[] relationshipTarget, int[] relationshipWeight) {
        this.previousPageRanks = new int[this.nodeCount];
        this.pageRanksAtomic = new AtomicIntegerArray(this.nodeCount);
        this.stats.iterations = iterations;
        long before = System.currentTimeMillis();
        for (int iteration = 0; iteration < iterations; ++iteration) {
            long beforeIteration = System.currentTimeMillis();
            this.startIteration(sourceChunkStartingIndex, sourceDegreeData, relationshipWeight);
            this.iterateParallel(iteration, sourceDegreeData, sourceChunkStartingIndex, relationshipTarget, relationshipWeight);
            long afterIteration = System.currentTimeMillis();
            this.log.info("Time for iteration " + iteration + "  " + (afterIteration - beforeIteration) + " millis");
        }
        long after = System.currentTimeMillis();
        this.stats.computeMillis = after - before;
    }

    @Override
    public void compute(int iterations, RelationshipType ... relationshipTypes) {
        this.compute(iterations, this.algorithm.sourceDegreeData, this.algorithm.sourceChunkStartingIndex, this.algorithm.relationshipTarget, this.algorithm.relationshipWeight);
    }

    private int getEndNode(int node, int[] sourceChunkStartingIndex) {
        int endNode;
        for (endNode = node; endNode < this.nodeCount && sourceChunkStartingIndex[endNode] - sourceChunkStartingIndex[node] <= 100000; ++endNode) {
        }
        return endNode;
    }

    private void iterateParallel(int iter, final int[] sourceDegreeData, final int[] sourceChunkStartingIndex, final int[] relationshipTarget, final int[] relationshipWeight) {
        int batches = this.nodeCount / 100000;
        ArrayList<Future> futures = new ArrayList<Future>(batches);
        int nodeIter = 0;
        while (nodeIter < this.nodeCount) {
            final int start = nodeIter;
            final int end = this.getEndNode(nodeIter, sourceChunkStartingIndex);
            Future<?> future = this.pool.submit(new Runnable(){

                @Override
                public void run() {
                    for (int i = start; i < end; ++i) {
                        int chunkIndex = sourceChunkStartingIndex[i];
                        int degree = sourceDegreeData[i];
                        for (int j = 0; j < degree; ++j) {
                            int source = i;
                            int target = relationshipTarget[chunkIndex + j];
                            int weight = relationshipWeight == null ? 1 : relationshipWeight[chunkIndex + j];
                            PageRankArrayStorageParallelCypher.this.pageRanksAtomic.addAndGet(target, weight * PageRankArrayStorageParallelCypher.this.previousPageRanks[source]);
                        }
                    }
                }
            });
            nodeIter = end;
            futures.add(future);
        }
        AlgoUtils.waitForTasks(futures);
    }

    private int getTotalWeightForNode(int node, int[] sourceChunkStartingIndex, int[] sourceDegreeData, int[] relationshipWeight) {
        int degree = sourceDegreeData[node];
        if (relationshipWeight == null) {
            return degree;
        }
        int chunkIndex = sourceChunkStartingIndex[node];
        int totalWeight = 0;
        for (int i = 0; i < degree; ++i) {
            totalWeight += relationshipWeight[chunkIndex + i];
        }
        return totalWeight;
    }

    private void startIteration(int[] sourceChunkStartingIndex, int[] sourceDegreeData, int[] relationshipWeight) {
        for (int node = 0; node < this.nodeCount; ++node) {
            int weightedDegree = this.getTotalWeightForNode(node, sourceChunkStartingIndex, sourceDegreeData, relationshipWeight);
            if (weightedDegree == -1) continue;
            int prevRank = this.pageRanksAtomic.get(node);
            this.previousPageRanks[node] = PageRankUtils.toInt(0.85 * PageRankUtils.toFloat(prevRank) / (double)weightedDegree);
            this.pageRanksAtomic.set(node, ONE_MINUS_ALPHA_INT);
        }
    }

    public void writeResultsToDB(String property) {
        this.property = property;
        this.stats.write = true;
        long before = System.currentTimeMillis();
        AlgoUtils.writeBackResults(this.pool, this.db, this, 100100, this.guard);
        this.stats.writeMillis = System.currentTimeMillis() - before;
        this.stats.property = this.getPropertyName();
    }

    @Override
    public double getResult(long node) {
        double val = 0.0;
        int logicalIndex = this.getNodeIndex((int)node);
        if (logicalIndex >= 0 && this.pageRanksAtomic.length() >= logicalIndex) {
            val = PageRankUtils.toFloat(this.pageRanksAtomic.get(logicalIndex));
        }
        return val;
    }

    @Override
    public String getPropertyName() {
        return this.property;
    }

    @Override
    public long numberOfNodes() {
        return this.nodeCount;
    }

    public long numberOfRels() {
        return this.relCount;
    }

    @Override
    public PageRank.PageRankStatistics getStatistics() {
        return this.stats;
    }
}

