/*
 * Decompiled with CFR 0.152.
 */
package apoc.atomic;

import apoc.atomic.util.AtomicUtils;
import apoc.util.ArrayBackedList;
import apoc.util.MapUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.helpers.TransactionTemplate;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class Atomic {
    @Context
    public GraphDatabaseService db;

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.atomic.add(node/relatonship,propertyName,number) Sums the property's value with the 'number' value ")
    public Stream<AtomicResults> add(@Name(value="container") Object container, @Name(value="propertyName") String property, @Name(value="number") Number number, @Name(value="times", defaultValue="5") Long times) {
        this.checkIsPropertyContainer(container);
        Number[] newValue = new Number[1];
        Number[] oldValue = new Number[1];
        PropertyContainer propertyContainer = (PropertyContainer)container;
        ExecutionContext executionContext = new ExecutionContext(this.db, propertyContainer, property);
        this.retry(executionContext, context -> {
            oldValue[0] = (Number)propertyContainer.getProperty(property);
            newValue[0] = AtomicUtils.sum((Number)propertyContainer.getProperty(property), number);
            propertyContainer.setProperty(property, (Object)newValue[0]);
            return ((ExecutionContext)context).propertyContainer.getProperty(property);
        }, times);
        return Stream.of(new AtomicResults(propertyContainer, property, oldValue[0], newValue[0]));
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.atomic.subtract(node/relatonship,propertyName,number) Subtracts the 'number' value to the property's value")
    public Stream<AtomicResults> subtract(@Name(value="container") Object container, @Name(value="propertyName") String property, @Name(value="number") Number number, @Name(value="times", defaultValue="5") Long times) {
        this.checkIsPropertyContainer(container);
        Number[] newValue = new Number[1];
        Number[] oldValue = new Number[1];
        PropertyContainer propertyContainer = (PropertyContainer)container;
        ExecutionContext executionContext = new ExecutionContext(this.db, propertyContainer, property);
        this.retry(executionContext, context -> {
            oldValue[0] = (Number)propertyContainer.getProperty(property);
            newValue[0] = AtomicUtils.sub((Number)propertyContainer.getProperty(property), number);
            propertyContainer.setProperty(property, (Object)newValue[0]);
            return ((ExecutionContext)context).propertyContainer.getProperty(property);
        }, times);
        return Stream.of(new AtomicResults(propertyContainer, property, oldValue[0], newValue[0]));
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.atomic.concat(node/relatonship,propertyName,string) Concats the property's value with the 'string' value")
    public Stream<AtomicResults> concat(@Name(value="container") Object container, @Name(value="propertyName") String property, @Name(value="string") String string, @Name(value="times", defaultValue="5") Long times) {
        this.checkIsPropertyContainer(container);
        String[] newValue = new String[1];
        String[] oldValue = new String[1];
        PropertyContainer propertyContainer = (PropertyContainer)container;
        ExecutionContext executionContext = new ExecutionContext(this.db, propertyContainer, property);
        this.retry(executionContext, context -> {
            oldValue[0] = propertyContainer.getProperty(property).toString();
            newValue[0] = oldValue[0].toString().concat(string);
            propertyContainer.setProperty(property, (Object)newValue[0]);
            return ((ExecutionContext)context).propertyContainer.getProperty(property);
        }, times);
        return Stream.of(new AtomicResults(propertyContainer, property, oldValue[0], newValue[0]));
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.atomic.insert(node/relatonship,propertyName,position,value) insert a value into the property's array value at 'position'")
    public Stream<AtomicResults> insert(@Name(value="container") Object container, @Name(value="propertyName") String property, @Name(value="position") Long position, @Name(value="value") Object value, @Name(value="times", defaultValue="5") Long times) throws ClassNotFoundException {
        this.checkIsPropertyContainer(container);
        Object[] oldValue = new Object[1];
        Object[] newValue = new Object[1];
        PropertyContainer propertyContainer = (PropertyContainer)container;
        ExecutionContext executionContext = new ExecutionContext(this.db, propertyContainer, property);
        this.retry(executionContext, context -> {
            Class<?> clazz;
            oldValue[0] = propertyContainer.getProperty(property);
            List<Object> values = this.insertValueIntoArray(propertyContainer.getProperty(property), position, value);
            try {
                clazz = Class.forName(values.toArray()[0].getClass().getName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            newValue[0] = Array.newInstance(clazz, values.size());
            try {
                System.arraycopy(values.toArray(), 0, newValue[0], 0, values.size());
            }
            catch (Exception e) {
                String message = "Property's array value has type: " + values.toArray()[0].getClass().getName() + ", and your value to insert has type: " + value.getClass().getName();
                throw new ArrayStoreException(message);
            }
            propertyContainer.setProperty(property, newValue[0]);
            return ((ExecutionContext)context).propertyContainer.getProperty(property);
        }, times);
        return Stream.of(new AtomicResults(propertyContainer, property, oldValue[0], newValue[0]));
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.atomic.remove(node/relatonship,propertyName,position) remove the element at position 'position'")
    public Stream<AtomicResults> remove(@Name(value="container") Object container, @Name(value="propertyName") String property, @Name(value="position") Long position, @Name(value="times", defaultValue="5") Long times) throws ClassNotFoundException {
        this.checkIsPropertyContainer(container);
        Object[] oldValue = new Object[1];
        Object[] newValue = new Object[1];
        PropertyContainer propertyContainer = (PropertyContainer)container;
        ExecutionContext executionContext = new ExecutionContext(this.db, propertyContainer, property);
        this.retry(executionContext, context -> {
            Class<?> clazz;
            Object[] arrayBackedList;
            oldValue[0] = arrayBackedList = new ArrayBackedList(propertyContainer.getProperty(property)).toArray();
            if (position > (long)arrayBackedList.length || position < 0L) {
                throw new RuntimeException("Attention your position out of range or higher than array length, that is " + arrayBackedList.length);
            }
            Object[] newArray = ArrayUtils.addAll((Object[])Arrays.copyOfRange(arrayBackedList, 0, position.intValue()), (Object[])Arrays.copyOfRange(arrayBackedList, position.intValue() + 1, arrayBackedList.length));
            try {
                clazz = Class.forName(arrayBackedList[0].getClass().getName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            newValue[0] = Array.newInstance(clazz, newArray.length);
            System.arraycopy(newArray, 0, newValue[0], 0, newArray.length);
            propertyContainer.setProperty(property, newValue[0]);
            return ((ExecutionContext)context).propertyContainer.getProperty(property);
        }, times);
        return Stream.of(new AtomicResults(propertyContainer, property, oldValue[0], newValue[0]));
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.atomic.update(node/relatonship,propertyName,updateOperation) update a property's value with a cypher operation (ex. \"n.prop1+n.prop2\")")
    public Stream<AtomicResults> update(@Name(value="container") Object container, @Name(value="propertyName") String property, @Name(value="operation") String operation, @Name(value="times", defaultValue="5") Long times) throws InterruptedException {
        this.checkIsPropertyContainer(container);
        PropertyContainer propertyContainer = (PropertyContainer)container;
        Object[] oldValue = new Object[1];
        ExecutionContext executionContext = new ExecutionContext(this.db, propertyContainer, property);
        this.retry(executionContext, context -> {
            oldValue[0] = propertyContainer.getProperty(property);
            String statement = "WITH {container} as n with n set n." + property + "=" + operation + ";";
            Map<String, Object> properties = MapUtil.map("container", propertyContainer);
            return ((ExecutionContext)context).db.execute(statement, properties);
        }, times);
        return Stream.of(new AtomicResults(propertyContainer, property, oldValue[0], propertyContainer.getProperty(property)));
    }

    private List<Object> insertValueIntoArray(Object oldValue, Long position, Object value) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (oldValue.getClass().isArray()) {
            values.addAll(new ArrayBackedList(oldValue));
        } else {
            values.add(oldValue);
        }
        if (position > (long)values.size()) {
            values.add(value);
        } else {
            values.add(position.intValue(), value);
        }
        return values;
    }

    private void retry(ExecutionContext executionContext, Function<ExecutionContext, Object> work, Long times) {
        TransactionTemplate template = new TransactionTemplate().retries(times.intValue()).backoff(10L, TimeUnit.MILLISECONDS);
        template.with(this.db).execute(tx -> {
            Lock lock = tx.acquireWriteLock(executionContext.propertyContainer);
            work.apply(executionContext);
            lock.release();
        });
    }

    private void checkIsPropertyContainer(Object container) {
        if (!(container instanceof PropertyContainer)) {
            throw new RuntimeException("You Must pass Node or Relationship");
        }
    }

    public class AtomicResults {
        public Object container;
        public String property;
        public Object oldValue;
        public Object newValue;

        public AtomicResults(Object container, String property, Object oldValue, Object newValue) {
            this.container = container;
            this.property = property;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }
    }

    private static class ExecutionContext {
        private final GraphDatabaseService db;
        private final PropertyContainer propertyContainer;
        private final String propertyName;

        public ExecutionContext(GraphDatabaseService db, PropertyContainer propertyContainer, String propertyName) {
            this.db = db;
            this.propertyContainer = propertyContainer;
            this.propertyName = propertyName;
        }
    }
}

