/*
 * Decompiled with CFR 0.152.
 */
package apoc.bolt;

import apoc.Description;
import apoc.result.RowResult;
import apoc.result.VirtualNode;
import apoc.result.VirtualRelationship;
import apoc.util.MapUtil;
import apoc.util.Util;
import java.io.File;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Spliterators;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.driver.internal.InternalEntity;
import org.neo4j.driver.internal.InternalPath;
import org.neo4j.driver.internal.logging.JULogging;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.summary.SummaryCounters;
import org.neo4j.driver.v1.types.Node;
import org.neo4j.driver.v1.types.Path;
import org.neo4j.driver.v1.types.Relationship;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class Bolt {
    @Context
    public GraphDatabaseService db;

    /*
     * Exception decompiling
     */
    @Procedure
    @Description(value="apoc.bolt.load(url-or-key, kernelTransaction, params, config) - access to other databases via bolt for read")
    public Stream<RowResult> load(@Name(value="url") String url, @Name(value="kernelTransaction") String statement, @Name(value="params", defaultValue="{}") Map<String, Object> params, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws URISyntaxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Procedure
    @Description(value="apoc.bolt.execute(url-or-key, kernelTransaction, params, config) - access to other databases via bolt for read")
    public Stream<RowResult> execute(@Name(value="url") String url, @Name(value="kernelTransaction") String statement, @Name(value="params", defaultValue="{}") Map<String, Object> params, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws URISyntaxException {
        HashMap<String, Object> configuration = new HashMap<String, Object>(config);
        configuration.put("readOnly", false);
        return this.load(url, statement, params, configuration);
    }

    private StatementResult runStatement(@Name(value="kernelTransaction") String statement, Session session, Map<String, Object> finalParams, boolean read) {
        if (read) {
            return (StatementResult)session.readTransaction(tx -> tx.run(statement, finalParams));
        }
        return (StatementResult)session.writeTransaction(tx -> tx.run(statement, finalParams));
    }

    private Stream<RowResult> getRowResultStream(boolean virtual, Session session, Map<String, Object> params, String statement, boolean read) {
        HashMap nodesCache = new HashMap();
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.runStatement(statement, session, params, read), 0), true).map(record -> new RowResult(record.asMap(value -> {
            Object entity = value.asObject();
            if (entity instanceof Node) {
                return this.toNode(entity, virtual, nodesCache);
            }
            if (entity instanceof Relationship) {
                return this.toRelationship(entity, virtual, nodesCache);
            }
            if (entity instanceof Path) {
                return this.toPath(entity, virtual, nodesCache);
            }
            return entity;
        })));
    }

    private Object toNode(Object value, boolean virtual, Map<Long, Object> nodesCache) {
        Value internalValue = ((InternalEntity)value).asValue();
        Node node = internalValue.asNode();
        if (virtual) {
            ArrayList labels = new ArrayList();
            node.labels().forEach(l -> labels.add(Label.label((String)l)));
            VirtualNode virtualNode = new VirtualNode(node.id(), labels.toArray(new Label[0]), node.asMap(), this.db);
            nodesCache.put(node.id(), virtualNode);
            return virtualNode;
        }
        return Util.map("entityType", internalValue.type().name(), "labels", node.labels(), "id", node.id(), "properties", node.asMap());
    }

    private Object toRelationship(Object value, boolean virtual, Map<Long, Object> nodesCache) {
        Value internalValue = ((InternalEntity)value).asValue();
        Relationship relationship = internalValue.asRelationship();
        if (virtual) {
            VirtualNode start = (VirtualNode)nodesCache.getOrDefault(relationship.startNodeId(), new VirtualNode(relationship.startNodeId(), this.db));
            VirtualNode end = (VirtualNode)nodesCache.getOrDefault(relationship.endNodeId(), new VirtualNode(relationship.endNodeId(), this.db));
            VirtualRelationship virtualRelationship = new VirtualRelationship(relationship.id(), start, end, RelationshipType.withName((String)relationship.type()), relationship.asMap());
            return virtualRelationship;
        }
        return Util.map("entityType", internalValue.type().name(), "type", relationship.type(), "id", relationship.id(), "start", relationship.startNodeId(), "end", relationship.endNodeId(), "properties", relationship.asMap());
    }

    private Object toPath(Object value, boolean virtual, Map<Long, Object> nodesCache) {
        LinkedList entityList = new LinkedList();
        Value internalValue = ((InternalPath)value).asValue();
        internalValue.asPath().forEach(p -> {
            entityList.add(this.toNode(p.start(), virtual, nodesCache));
            entityList.add(this.toRelationship(p.relationship(), virtual, nodesCache));
            entityList.add(this.toNode(p.end(), virtual, nodesCache));
        });
        return entityList;
    }

    private Map<String, Object> toMap(SummaryCounters resultSummary) {
        return MapUtil.map("nodesCreated", resultSummary.nodesCreated(), "nodesDeleted", resultSummary.nodesDeleted(), "labelsAdded", resultSummary.labelsAdded(), "labelsRemoved", resultSummary.labelsRemoved(), "relationshipsCreated", resultSummary.relationshipsCreated(), "relationshipsDeleted", resultSummary.relationshipsDeleted(), "propertiesSet", resultSummary.propertiesSet(), "constraintsAdded", resultSummary.constraintsAdded(), "constraintsRemoved", resultSummary.constraintsRemoved(), "indexesAdded", resultSummary.indexesAdded(), "indexesRemoved", resultSummary.indexesRemoved());
    }

    private Config toDriverConfig(Object driverConfig) {
        Map driverConfMap = (Map)driverConfig;
        String logging = driverConfMap.getOrDefault("logging", "INFO");
        boolean encryption = driverConfMap.getOrDefault("encryption", true);
        boolean logLeakedSessions = driverConfMap.getOrDefault("logLeakedSessions", true);
        Long maxIdleConnectionPoolSize = driverConfMap.getOrDefault("maxIdleConnectionPoolSize", 10L);
        Long idleTimeBeforeConnectionTest = driverConfMap.getOrDefault("idleTimeBeforeConnectionTest", -1L);
        String trustStrategy = driverConfMap.getOrDefault("trustStrategy", "TRUST_ALL_CERTIFICATES");
        Long routingFailureLimit = driverConfMap.getOrDefault("routingFailureLimit", 1L);
        Long routingRetryDelayMillis = driverConfMap.getOrDefault("routingRetryDelayMillis", 5000L);
        Long connectionTimeoutMillis = driverConfMap.getOrDefault("connectionTimeoutMillis", 5000L);
        Long maxRetryTimeMs = driverConfMap.getOrDefault("maxRetryTimeMs", 30000L);
        Config.ConfigBuilder config = Config.build();
        config.withLogging((Logging)new JULogging(Level.parse(logging)));
        if (!encryption) {
            config.withoutEncryption();
        }
        config.withTrustStrategy(Config.TrustStrategy.trustAllCertificates());
        if (!logLeakedSessions) {
            config.withoutEncryption();
        }
        config.withMaxIdleSessions(maxIdleConnectionPoolSize.intValue());
        config.withConnectionLivenessCheckTimeout(idleTimeBeforeConnectionTest.longValue(), TimeUnit.MILLISECONDS);
        config.withRoutingFailureLimit(routingFailureLimit.intValue());
        config.withConnectionTimeout(connectionTimeoutMillis.longValue(), TimeUnit.MILLISECONDS);
        config.withRoutingRetryDelay(routingRetryDelayMillis.longValue(), TimeUnit.MILLISECONDS);
        config.withMaxTransactionRetryTime(maxRetryTimeMs.longValue(), TimeUnit.MILLISECONDS);
        if (trustStrategy.equals("TRUST_ALL_CERTIFICATES")) {
            config.withTrustStrategy(Config.TrustStrategy.trustAllCertificates());
        } else if (trustStrategy.equals("TRUST_SYSTEM_CA_SIGNED_CERTIFICATES")) {
            config.withTrustStrategy(Config.TrustStrategy.trustSystemCertificates());
        } else {
            File file = new File(trustStrategy);
            config.withTrustStrategy(Config.TrustStrategy.trustCustomCertificateSignedBy((File)file));
        }
        return config.toConfig();
    }
}

