/*
 * Decompiled with CFR 0.152.
 */
package apoc.cluster;

import apoc.Description;
import apoc.result.GraphResult;
import apoc.result.VirtualNode;
import apoc.result.VirtualRelationship;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Procedure;

public class Cluster {
    @Context
    public GraphDatabaseService db;
    @Context
    public GraphDatabaseAPI api;
    public static final String boltAddressKey = "bolt_address";
    public static final Map<String, String> shortName = new HashMap<String, String>(){
        {
            this.put("LEADER", "L");
            this.put("FOLLOWER", "F");
            this.put("READ_REPLICA", "RR");
        }
    };

    @Procedure
    @Deprecated
    @Description(value="apoc.cluster.graph - visually displays the servers participating in the Causal Cluster, their roles, and which server in the cluster you are connected to.")
    public Stream<GraphResult> graph() {
        VirtualNode client;
        Optional<Relationship> clientConnection;
        Result execute = this.db.execute("CALL dbms.cluster.overview()");
        LinkedList<Node> servers = new LinkedList<Node>();
        LinkedList<Relationship> relationships = new LinkedList<Relationship>();
        while (execute.hasNext()) {
            Map next = execute.next();
            String role = (String)next.get("role");
            String id = (String)next.get("id");
            Label roleLabel = Label.label((String)role);
            String[] addresses = ((List)next.get("addresses")).toArray(new String[0]);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("name", shortName.get(role));
            properties.put("title", role);
            properties.put(boltAddressKey, addresses[0]);
            properties.put("http_address", addresses[1]);
            properties.put("cluster_id", id);
            VirtualNode server = new VirtualNode(new Label[]{roleLabel}, properties, this.db);
            servers.add(server);
        }
        Optional<Node> leaderNode = this.getLeaderNode(servers);
        if (leaderNode.isPresent()) {
            for (Node server : servers) {
                if (!server.hasLabel(Label.label((String)"FOLLOWER"))) continue;
                VirtualRelationship follows = new VirtualRelationship(server, leaderNode.get(), RelationshipType.withName((String)"FOLLOWS"));
                relationships.add(follows);
            }
        }
        if ((clientConnection = this.determineClientConnection(servers, client = new VirtualNode(new Label[]{Label.label((String)"CLIENT")}, Collections.singletonMap("name", "Client"), this.db))).isPresent()) {
            servers.add(client);
            relationships.add(clientConnection.get());
        }
        GraphResult graphResult = new GraphResult(servers, relationships);
        return Stream.of(graphResult);
    }

    private Optional<Relationship> determineClientConnection(List<Node> servers, Node client) {
        Optional<String> boltAddress = this.getBoltConnector();
        if (boltAddress.isPresent()) {
            for (Node server : servers) {
                if (!this.serverHasBoltAddress(boltAddress.get(), server)) continue;
                return Optional.of(new VirtualRelationship(client, server, RelationshipType.withName((String)"CONNECTED_TO")));
            }
        }
        return Optional.empty();
    }

    private Optional<String> getBoltConnector() {
        Config config = (Config)this.api.getDependencyResolver().resolveDependency(Config.class);
        Optional boltConnector = config.enabledBoltConnectors().stream().findFirst();
        if (boltConnector.isPresent()) {
            AdvertisedSocketAddress from = (AdvertisedSocketAddress)((BoltConnector)boltConnector.get()).advertised_address.from((Configuration)config);
            return Optional.of("bolt://" + from);
        }
        return Optional.empty();
    }

    private boolean serverHasBoltAddress(String boltAddress, Node server) {
        String address = (String)server.getProperty(boltAddressKey);
        return address.equals(boltAddress);
    }

    private Optional<Node> getLeaderNode(List<Node> servers) {
        for (Node server : servers) {
            if (!server.hasLabel(Label.label((String)"LEADER"))) continue;
            return Optional.of(server);
        }
        return Optional.empty();
    }
}

