/*
 * Decompiled with CFR 0.152.
 */
package apoc.custom;

import apoc.ApocConfiguration;
import apoc.Pools;
import apoc.custom.Signatures;
import apoc.util.JsonUtil;
import apoc.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.collection.PrefetchingRawIterator;
import org.neo4j.collection.RawIterator;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.proc.CallableUserFunction;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.api.proc.Key;
import org.neo4j.kernel.availability.AvailabilityListener;
import org.neo4j.kernel.impl.core.EmbeddedProxySPI;
import org.neo4j.kernel.impl.core.GraphProperties;
import org.neo4j.kernel.impl.core.GraphPropertiesProxy;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.util.DefaultValueMapper;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.virtual.MapValue;

public class CypherProcedures {
    private static final String PREFIX = "custom";
    public static final String FUNCTIONS = "functions";
    public static final String FUNCTION = "function";
    public static final String PROCEDURES = "procedures";
    public static final String PROCEDURE = "procedure";
    public static final List<FieldSignature> DEFAULT_MAP_OUTPUT = Collections.singletonList(FieldSignature.inputField((String)"row", (Neo4jTypes.AnyType)Neo4jTypes.NTMap));
    public static final List<FieldSignature> DEFAULT_INPUTS = Collections.singletonList(FieldSignature.inputField((String)"params", (Neo4jTypes.AnyType)Neo4jTypes.NTMap, (DefaultParameterValue)DefaultParameterValue.ntMap(Collections.emptyMap())));
    public static final String REMOVED = "removed";
    @org.neo4j.procedure.Context
    public GraphDatabaseAPI api;
    @org.neo4j.procedure.Context
    public KernelTransaction ktx;
    @org.neo4j.procedure.Context
    public Log log;

    @Procedure(value="apoc.custom.asProcedure", mode=Mode.WRITE)
    @Description(value="apoc.custom.asProcedure(name, statement, mode, outputs, inputs, description) - register a custom cypher procedure")
    public void asProcedure(@Name(value="name") String name, @Name(value="statement") String statement, @Name(value="mode", defaultValue="read") String mode, @Name(value="outputs", defaultValue="null") List<List<String>> outputs, @Name(value="inputs", defaultValue="null") List<List<String>> inputs, @Name(value="description", defaultValue="null") String description) {
        CustomStatementRegistry registry = new CustomStatementRegistry(this.api, this.log);
        if (!registry.registerProcedure(name, statement, mode, outputs, inputs, description)) {
            throw new IllegalStateException("Error registering procedure " + name + ", see log.");
        }
        CustomProcedureStorage.storeProcedure(this.api, name, statement, mode, outputs, inputs, description);
    }

    @Procedure(value="apoc.custom.declareProcedure", mode=Mode.WRITE)
    @Description(value="apoc.custom.declareProcedure(signature, statement, mode, description) - register a custom cypher procedure")
    public void declareProcedure(@Name(value="signature") String signature, @Name(value="statement") String statement, @Name(value="mode", defaultValue="read") String mode, @Name(value="description", defaultValue="null") String description) {
        CustomStatementRegistry registry = new CustomStatementRegistry(this.api, this.log);
        ProcedureSignature procedureSignature = new Signatures(PREFIX).asProcedureSignature(signature, description, CypherProcedures.mode(mode));
        if (!registry.registerProcedure(procedureSignature, statement)) {
            throw new IllegalStateException("Error registering procedure " + procedureSignature.name() + ", see log.");
        }
        CustomProcedureStorage.storeProcedure(this.api, procedureSignature, statement);
    }

    @Procedure(value="apoc.custom.asFunction", mode=Mode.WRITE)
    @Description(value="apoc.custom.asFunction(name, statement, outputs, inputs, forceSingle, description) - register a custom cypher function")
    public void asFunction(@Name(value="name") String name, @Name(value="statement") String statement, @Name(value="outputs", defaultValue="") String output, @Name(value="inputs", defaultValue="null") List<List<String>> inputs, @Name(value="forceSingle", defaultValue="false") boolean forceSingle, @Name(value="description", defaultValue="null") String description) throws ProcedureException {
        CustomStatementRegistry registry = new CustomStatementRegistry(this.api, this.log);
        if (!registry.registerFunction(name, statement, output, inputs, forceSingle, description)) {
            throw new IllegalStateException("Error registering function " + name + ", see log.");
        }
        CustomProcedureStorage.storeFunction(this.api, name, statement, output, inputs, forceSingle, description);
    }

    @Procedure(value="apoc.custom.declareFunction", mode=Mode.WRITE)
    @Description(value="apoc.custom.declareFunction(signature, statement, forceSingle, description) - register a custom cypher function")
    public void asFunction(@Name(value="signature") String signature, @Name(value="statement") String statement, @Name(value="forceSingle", defaultValue="false") boolean forceSingle, @Name(value="description", defaultValue="null") String description) throws ProcedureException {
        CustomStatementRegistry registry = new CustomStatementRegistry(this.api, this.log);
        UserFunctionSignature userFunctionSignature = new Signatures(PREFIX).asFunctionSignature(signature, description);
        if (!registry.registerFunction(userFunctionSignature, statement, forceSingle)) {
            throw new IllegalStateException("Error registering function " + signature + ", see log.");
        }
        CustomProcedureStorage.storeFunction(this.api, userFunctionSignature, statement, forceSingle);
    }

    @Procedure(value="apoc.custom.list", mode=Mode.READ)
    @Description(value="apoc.custom.list() - provide a list of custom procedures/functions registered")
    public Stream<CustomProcedureInfo> list() {
        CustomProcedureStorage registry = new CustomProcedureStorage(Pools.NEO4J_SCHEDULER, this.api, this.log);
        return registry.list().stream();
    }

    @Procedure(value="apoc.custom.removeProcedure", mode=Mode.WRITE)
    @Description(value="apoc.custom.removeProcedure(name) - remove the targeted custom procedure")
    public void removeProcedure(@Name(value="name") String name) {
        CustomStatementRegistry registry;
        Objects.requireNonNull(name, "name");
        Map<String, Object> old = CustomProcedureStorage.remove(this.api, name, PROCEDURES);
        if (old != null && !old.isEmpty() && !(registry = new CustomStatementRegistry(this.api, this.log)).removeProcedure(name, old)) {
            throw new IllegalStateException("Error removing custom procedure:" + name + ", see log.");
        }
    }

    @Procedure(value="apoc.custom.removeFunction", mode=Mode.WRITE)
    @Description(value="apoc.custom.removeFunction(name, type) - remove the targeted custom function")
    public void removeFunction(@Name(value="name") String name) {
        CustomStatementRegistry registry;
        Objects.requireNonNull(name, "name");
        Map<String, Object> old = CustomProcedureStorage.remove(this.api, name, FUNCTIONS);
        if (old != null && !old.isEmpty() && !(registry = new CustomStatementRegistry(this.api, this.log)).removeFunction(name, old)) {
            throw new IllegalStateException("Error removing custom function:" + name + ", see log.");
        }
    }

    public static Mode mode(String s) {
        return s == null ? Mode.READ : Mode.valueOf((String)s.toUpperCase());
    }

    public static class CustomProcedureStorage
    implements AvailabilityListener {
        public static final String APOC_CUSTOM = "apoc.custom";
        public static final String APOC_CUSTOM_UPDATE = "apoc.custom.update";
        private GraphProperties properties;
        private final JobScheduler scheduler;
        private final GraphDatabaseAPI api;
        private final Log log;
        private long lastUpdate;
        public static Group REFRESH_GROUP = Group.STORAGE_MAINTENANCE;
        private JobHandle restoreProceduresHandle;

        public CustomProcedureStorage(JobScheduler neo4jScheduler, GraphDatabaseAPI api, Log log) {
            this.scheduler = neo4jScheduler;
            this.api = api;
            this.log = log;
        }

        public void available() {
            this.properties = CustomProcedureStorage.getProperties(this.api);
            this.restoreProcedures();
            long refreshInterval = Long.valueOf(ApocConfiguration.get("custom.procedures.refresh", "60000"));
            this.restoreProceduresHandle = this.scheduler.scheduleRecurring(REFRESH_GROUP, () -> this.restoreProcedures(), refreshInterval, refreshInterval, TimeUnit.MILLISECONDS);
        }

        public static GraphPropertiesProxy getProperties(GraphDatabaseAPI api) {
            return ((EmbeddedProxySPI)api.getDependencyResolver().resolveDependency(EmbeddedProxySPI.class)).newGraphPropertiesProxy();
        }

        private void restoreProcedures() {
            if (CustomProcedureStorage.getLastUpdate(this.properties) <= this.lastUpdate) {
                return;
            }
            this.lastUpdate = System.currentTimeMillis();
            CustomStatementRegistry registry = new CustomStatementRegistry(this.api, this.log);
            Map<String, Map<String, Map<String, Object>>> stored = CustomProcedureStorage.readData(this.properties);
            Signatures sigs = new Signatures(CypherProcedures.PREFIX);
            stored.get(CypherProcedures.FUNCTIONS).forEach((name, data) -> {
                if (data.containsKey("signature")) {
                    UserFunctionSignature userFunctionSignature = sigs.asFunctionSignature((String)data.get("signature"), (String)data.get("description"));
                    registry.registerFunction(userFunctionSignature, (String)data.get("statement"), (Boolean)data.get("forceSingle"));
                } else {
                    registry.registerFunction((String)name, (String)data.get("statement"), (String)data.get("output"), (List)data.get("inputs"), (Boolean)data.get("forceSingle"), (String)data.get("description"));
                }
            });
            stored.get(CypherProcedures.PROCEDURES).forEach((name, data) -> {
                if (data.containsKey("signature")) {
                    ProcedureSignature procedureSignature = sigs.asProcedureSignature((String)data.get("signature"), (String)data.get("description"), Mode.valueOf((String)((String)data.get("mode"))));
                    registry.registerProcedure(procedureSignature, (String)data.get("statement"));
                } else {
                    registry.registerProcedure((String)name, (String)data.get("statement"), (String)data.get("mode"), (List)data.get("outputs"), (List)data.get("inputs"), (String)data.get("description"));
                }
            });
            stored.getOrDefault(CypherProcedures.REMOVED, Collections.emptyMap()).forEach((type, data) -> data.forEach((name, metadata) -> {
                switch (type) {
                    case "procedures": {
                        registry.removeProcedure(name, (Map)metadata);
                        break;
                    }
                    case "functions": {
                        registry.removeFunction(name, (Map)metadata);
                    }
                }
            }));
            CustomProcedureStorage.clearQueryCaches((GraphDatabaseService)this.api);
        }

        public void unavailable() {
            if (this.restoreProceduresHandle != null) {
                this.restoreProceduresHandle.cancel(false);
            }
            this.properties = null;
        }

        public static Map<String, Object> storeProcedure(GraphDatabaseAPI api, String name, String statement, String mode, List<List<String>> outputs, List<List<String>> inputs, String description) {
            Map<String, Object> data = Util.map("statement", statement, "mode", mode, "inputs", inputs, "outputs", outputs, "description", description);
            return CustomProcedureStorage.updateCustomData((GraphProperties)CustomProcedureStorage.getProperties(api), name, CypherProcedures.PROCEDURES, data);
        }

        public static Map<String, Object> storeProcedure(GraphDatabaseAPI api, ProcedureSignature signature, String statement) {
            Map<String, Object> data = Util.map("statement", statement, "mode", signature.mode().toString(), "signature", signature.toString(), "description", signature.description());
            return CustomProcedureStorage.updateCustomData((GraphProperties)CustomProcedureStorage.getProperties(api), signature.name().toString(), CypherProcedures.PROCEDURES, data);
        }

        public static Map<String, Object> storeFunction(GraphDatabaseAPI api, String name, String statement, String output, List<List<String>> inputs, boolean forceSingle, String description) {
            Map<String, Object> data = Util.map("statement", statement, "forceSingle", forceSingle, "inputs", inputs, "output", output, "description", description);
            return CustomProcedureStorage.updateCustomData((GraphProperties)CustomProcedureStorage.getProperties(api), name, CypherProcedures.FUNCTIONS, data);
        }

        public static Map<String, Object> storeFunction(GraphDatabaseAPI api, UserFunctionSignature signature, String statement, boolean forceSingle) {
            Map<String, Object> data = Util.map("statement", statement, "forceSingle", forceSingle, "signature", signature.toString(), "description", signature.description());
            return CustomProcedureStorage.updateCustomData((GraphProperties)CustomProcedureStorage.getProperties(api), signature.name().toString(), CypherProcedures.FUNCTIONS, data);
        }

        public static synchronized Map<String, Object> remove(GraphDatabaseAPI api, String name, String type) {
            return CustomProcedureStorage.updateCustomData((GraphProperties)CustomProcedureStorage.getProperties(api), name, type, null);
        }

        private static synchronized Map<String, Object> updateCustomData(GraphProperties properties, String name, String type, Map<String, Object> value) {
            if (name == null || type == null) {
                return null;
            }
            try (Transaction tx = properties.getGraphDatabase().beginTx();){
                Map<String, Object> previous;
                Map<String, Map<String, Map<String, Object>>> data = CustomProcedureStorage.readData(properties);
                Map<String, Map<String, Object>> procData = data.get(type);
                if (value != null) {
                    previous = procData.put(name, value);
                } else {
                    previous = procData.remove(name);
                    data.computeIfAbsent(CypherProcedures.REMOVED, key -> new HashMap()).computeIfAbsent(type, key -> new HashMap()).put(name, previous);
                }
                if (value != null || previous != null) {
                    properties.setProperty(APOC_CUSTOM, (Object)Util.toJson(data));
                    properties.setProperty(APOC_CUSTOM_UPDATE, (Object)System.currentTimeMillis());
                }
                tx.success();
                Map<String, Object> map = previous;
                return map;
            }
        }

        private static long getLastUpdate(GraphProperties properties) {
            try (Transaction tx = properties.getGraphDatabase().beginTx();){
                long lastUpdate = (Long)properties.getProperty(APOC_CUSTOM_UPDATE, (Object)0L);
                tx.success();
                long l = lastUpdate;
                return l;
            }
        }

        private static Map<String, Map<String, Map<String, Object>>> readData(GraphProperties properties) {
            try (Transaction tx = properties.getGraphDatabase().beginTx();){
                String procedurePropertyData = (String)properties.getProperty(APOC_CUSTOM, (Object)"{\"functions\":{},\"procedures\":{}}");
                Map result = Util.fromJson(procedurePropertyData, Map.class);
                tx.success();
                Map map = result;
                return map;
            }
        }

        private static void clearQueryCaches(GraphDatabaseService db) {
            try (Transaction tx = db.beginTx();){
                db.execute("call dbms.clearQueryCaches()").close();
                tx.success();
            }
        }

        public List<CustomProcedureInfo> list() {
            return CustomProcedureStorage.readData((GraphProperties)CustomProcedureStorage.getProperties(this.api)).entrySet().stream().filter(entry -> !CypherProcedures.REMOVED.equals(entry.getKey())).flatMap(entryProcedureType -> {
                Map procedures = (Map)entryProcedureType.getValue();
                String type = (String)entryProcedureType.getKey();
                boolean isProcedure = CypherProcedures.PROCEDURES.equals(type);
                return procedures.entrySet().stream().map(entryProcedure -> {
                    String typeLabel = isProcedure ? CypherProcedures.PROCEDURE : CypherProcedures.FUNCTION;
                    String outputs = isProcedure ? "outputs" : "output";
                    String procedureName = (String)entryProcedure.getKey();
                    Map procedureParams = (Map)entryProcedure.getValue();
                    return new CustomProcedureInfo(typeLabel, procedureName, "null".equals(procedureParams.get("description")) ? null : String.valueOf(procedureParams.get("description")), procedureParams.containsKey("mode") ? String.valueOf(procedureParams.get("mode")) : null, String.valueOf(procedureParams.get("statement")), (List)procedureParams.get("inputs"), procedureParams.get(outputs), (Boolean)procedureParams.get("forceSingle"));
                });
            }).collect(Collectors.toList());
        }
    }

    public static class CustomProcedureInfo {
        public String type;
        public String name;
        public String description;
        public String mode;
        public String statement;
        public List<List<String>> inputs;
        public Object outputs;
        public Boolean forceSingle;

        public CustomProcedureInfo(String type, String name, String description, String mode, String statement, List<List<String>> inputs, Object outputs, Boolean forceSingle) {
            this.type = type;
            this.name = name;
            this.description = description;
            this.statement = statement;
            this.outputs = outputs;
            this.inputs = inputs;
            this.forceSingle = forceSingle;
            this.mode = mode;
        }
    }

    static class CustomStatementRegistry {
        GraphDatabaseAPI api;
        Procedures procedures;
        private final Log log;

        public CustomStatementRegistry(GraphDatabaseAPI api, Log log) {
            this.api = api;
            this.procedures = (Procedures)api.getDependencyResolver().resolveDependency(Procedures.class);
            this.log = log;
        }

        public boolean registerProcedure(String name, String statement, String mode, List<List<String>> outputs, List<List<String>> inputs, String description) {
            boolean admin = false;
            ProcedureSignature signature = new ProcedureSignature(CustomStatementRegistry.qualifiedName(name), this.inputSignatures(inputs), this.outputSignatures(outputs), CypherProcedures.mode(mode), admin, null, new String[0], description, null, false, true);
            return this.registerProcedure(signature, statement);
        }

        public boolean registerProcedure(final ProcedureSignature signature, final String statement) {
            try {
                Procedures procedures = (Procedures)this.api.getDependencyResolver().resolveDependency(Procedures.class);
                procedures.register((CallableProcedure)new CallableProcedure.BasicProcedure(signature){

                    public RawIterator<Object[], ProcedureException> apply(Context ctx, Object[] input, ResourceTracker resourceTracker) throws ProcedureException {
                        KernelTransaction ktx = (KernelTransaction)ctx.get(Key.key((String)"KernelTransaction", KernelTransaction.class));
                        Map<String, Object> params = this.params(input, signature);
                        final Result result = api.execute(statement, params);
                        resourceTracker.registerCloseableResource((AutoCloseable)result);
                        List outputs = signature.outputSignature();
                        final String[] names = outputs == null ? null : (String[])outputs.stream().map(FieldSignature::name).toArray(String[]::new);
                        final boolean defaultOutputs = outputs == null || outputs.equals(DEFAULT_MAP_OUTPUT);
                        return new PrefetchingRawIterator<Object[], ProcedureException>(){

                            protected Object[] fetchNextOrNull() {
                                if (!result.hasNext()) {
                                    return null;
                                }
                                Map row = result.next();
                                return this.toResult(row, names, defaultOutputs);
                            }
                        };
                    }
                }, true);
                return true;
            }
            catch (Exception e) {
                this.log.error("Could not register procedure: " + signature.name() + " with " + statement + "\n accepting" + signature.inputSignature() + " resulting in " + signature.outputSignature() + " mode " + signature.mode(), (Throwable)e);
                return false;
            }
        }

        public boolean removeProcedure(String name, List<List<String>> inputs, List<List<String>> outputs, String description, String mode) {
            boolean admin = false;
            ProcedureSignature signature = new ProcedureSignature(CustomStatementRegistry.qualifiedName(name), this.inputSignatures(inputs), this.outputSignatures(outputs), CypherProcedures.mode(mode), admin, null, new String[0], description, null, false, true);
            return this.removeProcedure(signature);
        }

        private boolean removeProcedure(final ProcedureSignature signature) {
            try {
                Procedures procedures = (Procedures)this.api.getDependencyResolver().resolveDependency(Procedures.class);
                procedures.register((CallableProcedure)new CallableProcedure.BasicProcedure(signature){

                    public RawIterator<Object[], ProcedureException> apply(Context ctx, Object[] input, ResourceTracker resourceTracker) throws ProcedureException {
                        String error = String.format("There is no procedure with the name `%s` registered for this database instance. Please ensure you've spelled the procedure name correctly and that the procedure is properly deployed.", signature.name());
                        throw new QueryExecutionException(error, null, "Neo.ClientError.Procedure.ProcedureNotFound");
                    }
                }, true);
                return true;
            }
            catch (Exception e) {
                this.log.error("Could not remove procedure: " + signature, (Throwable)e);
                return false;
            }
        }

        private boolean removeProcedure(String procedureName, Map<String, Object> procedureMetadata) {
            boolean deleted;
            if (procedureMetadata.containsKey("signature")) {
                Signatures sigs = new Signatures(CypherProcedures.PREFIX);
                ProcedureSignature procedureSignature = sigs.asProcedureSignature((String)procedureMetadata.get("signature"), (String)procedureMetadata.get("description"), Mode.valueOf((String)((String)procedureMetadata.get("mode"))));
                deleted = this.removeProcedure(procedureSignature);
            } else {
                deleted = this.removeProcedure(procedureName, (List)procedureMetadata.get("inputs"), (List)procedureMetadata.get("outputs"), (String)procedureMetadata.get("description"), (String)procedureMetadata.get("mode"));
            }
            return deleted;
        }

        public boolean registerFunction(String name, String statement, String output, List<List<String>> inputs, boolean forceSingle, String description) {
            Neo4jTypes.AnyType outType = this.typeof(output.isEmpty() ? "LIST OF MAP" : output);
            UserFunctionSignature signature = new UserFunctionSignature(CustomStatementRegistry.qualifiedName(name), this.inputSignatures(inputs), outType, null, new String[0], description, false);
            return this.registerFunction(signature, statement, forceSingle);
        }

        public boolean registerFunction(final UserFunctionSignature signature, final String statement, final boolean forceSingle) {
            try {
                final DefaultValueMapper defaultValueMapper = new DefaultValueMapper((EmbeddedProxySPI)this.api.getDependencyResolver().resolveDependency(GraphDatabaseFacade.class));
                final Neo4jTypes.AnyType outType = signature.outputType();
                this.procedures.register((CallableUserFunction)new CallableUserFunction.BasicUserFunction(signature){

                    public AnyValue apply(Context ctx, AnyValue[] input) {
                        Map<String, Object> params = this.functionParams(input, signature, defaultValueMapper);
                        Throwable throwable = null;
                        try (Result result = api.execute(statement, params);){
                            if (!result.hasNext()) {
                                AnyValue anyValue = null;
                                return anyValue;
                            }
                            if (outType.equals(Neo4jTypes.NTAny)) {
                                AnyValue anyValue = ValueUtils.of(result.stream().collect(Collectors.toList()));
                                return anyValue;
                            }
                            List cols = result.columns();
                            if (cols.isEmpty()) {
                                AnyValue anyValue = null;
                                return anyValue;
                            }
                            if (!forceSingle && outType instanceof Neo4jTypes.ListType) {
                                Neo4jTypes.ListType listType = (Neo4jTypes.ListType)outType;
                                Neo4jTypes.AnyType innerType = listType.innerType();
                                if (innerType instanceof Neo4jTypes.MapType) {
                                    AnyValue anyValue = ValueUtils.of(result.stream().collect(Collectors.toList()));
                                    return anyValue;
                                }
                                if (cols.size() == 1) {
                                    AnyValue anyValue = ValueUtils.of(result.stream().map(row -> row.get(cols.get(0))).collect(Collectors.toList()));
                                    return anyValue;
                                }
                            } else {
                                Map row2 = result.next();
                                if (outType instanceof Neo4jTypes.MapType) {
                                    AnyValue anyValue = ValueUtils.of((Object)row2);
                                    return anyValue;
                                }
                                if (cols.size() == 1) {
                                    AnyValue anyValue = ValueUtils.of(row2.get(cols.get(0)));
                                    return anyValue;
                                }
                            }
                            try {
                                throw new IllegalStateException("Result mismatch " + cols + " output type is " + outType);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                        }
                    }
                }, true);
                return true;
            }
            catch (Exception e) {
                this.log.error("Could not register function: " + signature + "\nwith: " + statement + "\n single result " + forceSingle, (Throwable)e);
                return false;
            }
        }

        public boolean removeFunction(String name, String output, List<List<String>> inputs, String description) {
            Neo4jTypes.AnyType outType = this.typeof(output.isEmpty() ? "LIST OF MAP" : output);
            UserFunctionSignature signature = new UserFunctionSignature(CustomStatementRegistry.qualifiedName(name), this.inputSignatures(inputs), outType, null, new String[0], description, false);
            return this.removeFunction(signature);
        }

        private boolean removeFunction(final UserFunctionSignature signature) {
            try {
                this.procedures.register((CallableUserFunction)new CallableUserFunction.BasicUserFunction(signature){

                    public AnyValue apply(Context ctx, AnyValue[] input) {
                        String error = String.format("Unknown function '%s'", signature.name());
                        throw new QueryExecutionException(error, null, "Neo.ClientError.Statement.SyntaxError");
                    }
                }, true);
                return true;
            }
            catch (Exception e) {
                this.log.error("Could not remove function: " + signature, (Throwable)e);
                return false;
            }
        }

        private boolean removeFunction(String functionName, Map<String, Object> functionMetadata) {
            boolean deleted;
            if (functionMetadata.containsKey("signature")) {
                Signatures sigs = new Signatures(CypherProcedures.PREFIX);
                UserFunctionSignature userFunctionSignature = sigs.asFunctionSignature((String)functionMetadata.get("signature"), (String)functionMetadata.get("description"));
                deleted = this.removeFunction(userFunctionSignature);
            } else {
                deleted = this.removeFunction(functionName, (String)functionMetadata.get("output"), (List)functionMetadata.get("inputs"), (String)functionMetadata.get("description"));
            }
            return deleted;
        }

        public static QualifiedName qualifiedName(@Name(value="name") String name) {
            String[] names = name.split("\\.");
            ArrayList<String> namespace = new ArrayList<String>(names.length);
            namespace.add(CypherProcedures.PREFIX);
            namespace.addAll(Arrays.asList(names));
            return new QualifiedName(namespace.subList(0, namespace.size() - 1), names[names.length - 1]);
        }

        public List<FieldSignature> inputSignatures(@Name(value="inputs", defaultValue="null") List<List<String>> inputs) {
            List<FieldSignature> inputSignature = inputs == null ? DEFAULT_INPUTS : inputs.stream().map(pair -> {
                DefaultParameterValue defaultValue = this.defaultValue((String)pair.get(1), pair.size() > 2 ? (String)pair.get(2) : null);
                return defaultValue == null ? FieldSignature.inputField((String)((String)pair.get(0)), (Neo4jTypes.AnyType)this.typeof((String)pair.get(1))) : FieldSignature.inputField((String)((String)pair.get(0)), (Neo4jTypes.AnyType)this.typeof((String)pair.get(1)), (DefaultParameterValue)defaultValue);
            }).collect(Collectors.toList());
            return inputSignature;
        }

        public List<FieldSignature> outputSignatures(@Name(value="outputs", defaultValue="null") List<List<String>> outputs) {
            return outputs == null ? DEFAULT_MAP_OUTPUT : outputs.stream().map(pair -> FieldSignature.outputField((String)((String)pair.get(0)), (Neo4jTypes.AnyType)this.typeof((String)pair.get(1)))).collect(Collectors.toList());
        }

        private Neo4jTypes.AnyType typeof(String typeName) {
            if ((typeName = typeName.toUpperCase()).startsWith("LIST OF ")) {
                return Neo4jTypes.NTList((Neo4jTypes.AnyType)this.typeof(typeName.substring(8)));
            }
            if (typeName.startsWith("LIST ")) {
                return Neo4jTypes.NTList((Neo4jTypes.AnyType)this.typeof(typeName.substring(5)));
            }
            switch (typeName) {
                case "ANY": {
                    return Neo4jTypes.NTAny;
                }
                case "MAP": {
                    return Neo4jTypes.NTMap;
                }
                case "NODE": {
                    return Neo4jTypes.NTNode;
                }
                case "REL": {
                    return Neo4jTypes.NTRelationship;
                }
                case "RELATIONSHIP": {
                    return Neo4jTypes.NTRelationship;
                }
                case "EDGE": {
                    return Neo4jTypes.NTRelationship;
                }
                case "PATH": {
                    return Neo4jTypes.NTPath;
                }
                case "NUMBER": {
                    return Neo4jTypes.NTNumber;
                }
                case "LONG": {
                    return Neo4jTypes.NTInteger;
                }
                case "INT": {
                    return Neo4jTypes.NTInteger;
                }
                case "INTEGER": {
                    return Neo4jTypes.NTInteger;
                }
                case "FLOAT": {
                    return Neo4jTypes.NTFloat;
                }
                case "DOUBLE": {
                    return Neo4jTypes.NTFloat;
                }
                case "BOOL": {
                    return Neo4jTypes.NTBoolean;
                }
                case "BOOLEAN": {
                    return Neo4jTypes.NTBoolean;
                }
                case "DATE": {
                    return Neo4jTypes.NTDate;
                }
                case "TIME": {
                    return Neo4jTypes.NTTime;
                }
                case "LOCALTIME": {
                    return Neo4jTypes.NTLocalTime;
                }
                case "DATETIME": {
                    return Neo4jTypes.NTDateTime;
                }
                case "LOCALDATETIME": {
                    return Neo4jTypes.NTLocalDateTime;
                }
                case "DURATION": {
                    return Neo4jTypes.NTDuration;
                }
                case "POINT": {
                    return Neo4jTypes.NTPoint;
                }
                case "GEO": {
                    return Neo4jTypes.NTGeometry;
                }
                case "GEOMETRY": {
                    return Neo4jTypes.NTGeometry;
                }
                case "STRING": {
                    return Neo4jTypes.NTString;
                }
                case "TEXT": {
                    return Neo4jTypes.NTString;
                }
            }
            return Neo4jTypes.NTString;
        }

        private DefaultParameterValue defaultValue(String typeName, String stringValue) {
            if (stringValue == null) {
                return null;
            }
            Object value = JsonUtil.parse(stringValue, null, Object.class);
            if (value == null) {
                return null;
            }
            if ((typeName = typeName.toUpperCase()).startsWith("LIST ")) {
                return DefaultParameterValue.ntList((List)((List)value), (Neo4jTypes.AnyType)this.typeof(typeName.substring(5)));
            }
            switch (typeName) {
                case "MAP": {
                    return DefaultParameterValue.ntMap((Map)((Map)value));
                }
                case "NODE": 
                case "REL": 
                case "RELATIONSHIP": 
                case "EDGE": 
                case "PATH": {
                    return null;
                }
                case "NUMBER": {
                    return value instanceof Float || value instanceof Double ? DefaultParameterValue.ntFloat((double)((Number)value).doubleValue()) : DefaultParameterValue.ntInteger((long)((Number)value).longValue());
                }
                case "LONG": 
                case "INT": 
                case "INTEGER": {
                    return DefaultParameterValue.ntInteger((long)((Number)value).longValue());
                }
                case "FLOAT": 
                case "DOUBLE": {
                    return DefaultParameterValue.ntFloat((double)((Number)value).doubleValue());
                }
                case "BOOL": 
                case "BOOLEAN": {
                    return DefaultParameterValue.ntBoolean((boolean)((Boolean)value));
                }
                case "DATE": 
                case "TIME": 
                case "LOCALTIME": 
                case "DATETIME": 
                case "LOCALDATETIME": 
                case "DURATION": 
                case "POINT": 
                case "GEO": 
                case "GEOMETRY": {
                    return null;
                }
                case "STRING": 
                case "TEXT": {
                    return DefaultParameterValue.ntString((String)value.toString());
                }
            }
            return null;
        }

        private Object[] toResult(Map<String, Object> row, String[] names, boolean defaultOutputs) {
            if (defaultOutputs) {
                return new Object[]{row};
            }
            Object[] result = new Object[names.length];
            for (int i = 0; i < names.length; ++i) {
                result[i] = row.get(names[i]);
            }
            return result;
        }

        public Map<String, Object> params(Object[] input, ProcedureSignature signature) {
            if (input == null || input.length == 0) {
                return Collections.emptyMap();
            }
            List inputs = signature.inputSignature();
            if (inputs == null || inputs.isEmpty() || inputs.equals(DEFAULT_INPUTS)) {
                return (Map)input[0];
            }
            HashMap<String, Object> params = new HashMap<String, Object>(input.length);
            for (int i = 0; i < input.length; ++i) {
                params.put(((FieldSignature)inputs.get(i)).name(), input[i]);
            }
            return params;
        }

        public Map<String, Object> functionParams(Object[] input, UserFunctionSignature signature, DefaultValueMapper mapper) {
            if (input == null || input.length == 0) {
                return Collections.emptyMap();
            }
            List inputs = signature.inputSignature();
            if (inputs == null || inputs.isEmpty() || inputs.equals(DEFAULT_INPUTS)) {
                return (Map)((MapValue)input[0]).map((ValueMapper)mapper);
            }
            HashMap<String, Object> params = new HashMap<String, Object>(input.length);
            for (int i = 0; i < input.length; ++i) {
                params.put(((FieldSignature)inputs.get(i)).name(), ((AnyValue)input[i]).map((ValueMapper)mapper));
            }
            return params;
        }
    }
}

