/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.json;

import apoc.export.util.ExportConfig;
import apoc.export.util.FormatUtils;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;

public enum JsonFormatSerializer {
    DEFAULT{

        @Override
        public void writeNode(JsonGenerator jsonGenerator, Node node, ExportConfig config) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("type", "node");
            this.writeNodeDetails(jsonGenerator, node, true);
            jsonGenerator.writeEndObject();
        }

        @Override
        public void writeRelationship(JsonGenerator jsonGenerator, Relationship rel, ExportConfig config) throws IOException {
            Node startNode = rel.getStartNode();
            Node endNode = rel.getEndNode();
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("id", String.valueOf(rel.getId()));
            jsonGenerator.writeStringField("type", "relationship");
            jsonGenerator.writeStringField("label", rel.getType().toString());
            this.serializeProperties(jsonGenerator, rel.getAllProperties());
            this.writeRelationshipNode(jsonGenerator, "start", startNode, config);
            this.writeRelationshipNode(jsonGenerator, "end", endNode, config);
            jsonGenerator.writeEndObject();
        }

        @Override
        public void serializeProperties(JsonGenerator jsonGenerator, Map<String, Object> properties) throws IOException {
            if (properties != null && !properties.isEmpty()) {
                jsonGenerator.writeObjectFieldStart("properties");
                for (Map.Entry<String, Object> entry : properties.entrySet()) {
                    String key = entry.getKey();
                    Object value = entry.getValue();
                    this.serializeProperty(jsonGenerator, key, value, true);
                }
                jsonGenerator.writeEndObject();
            }
        }

        @Override
        public void serializeProperty(JsonGenerator jsonGenerator, String key, Object value, boolean writeKey) throws IOException {
            if (value == null) {
                if (writeKey) {
                    jsonGenerator.writeNullField(key);
                } else {
                    jsonGenerator.writeNull();
                }
            } else if (writeKey) {
                jsonGenerator.writeObjectField(key, value);
            } else {
                jsonGenerator.writeObject(value);
            }
        }

        private void writeNodeDetails(JsonGenerator jsonGenerator, Node node, boolean withNodeProperties) throws IOException {
            jsonGenerator.writeStringField("id", String.valueOf(node.getId()));
            if (node.getLabels().iterator().hasNext()) {
                jsonGenerator.writeArrayFieldStart("labels");
                List<String> labels = FormatUtils.getLabelsSorted(node);
                for (String label : labels) {
                    jsonGenerator.writeString(label);
                }
                jsonGenerator.writeEndArray();
            }
            if (withNodeProperties) {
                this.serializeProperties(jsonGenerator, node.getAllProperties());
            }
        }

        private void writeRelationshipNode(JsonGenerator jsonGenerator, String type, Node node, ExportConfig config) throws IOException {
            jsonGenerator.writeObjectFieldStart(type);
            this.writeNodeDetails(jsonGenerator, node, config.writeNodeProperties());
            jsonGenerator.writeEndObject();
        }
    };


    public abstract void writeNode(JsonGenerator var1, Node var2, ExportConfig var3) throws IOException;

    public abstract void writeRelationship(JsonGenerator var1, Relationship var2, ExportConfig var3) throws IOException;

    public abstract void serializeProperties(JsonGenerator var1, Map<String, Object> var2) throws IOException;

    public abstract void serializeProperty(JsonGenerator var1, String var2, Object var3, boolean var4) throws IOException;
}

