/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.util;

import apoc.export.util.CountingReader;
import apoc.export.util.SizeCounter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class CountingInputStream
extends FilterInputStream
implements SizeCounter {
    public static final int BUFFER_SIZE = 0x100000;
    private final long total;
    private long count = 0L;
    private long newLines;

    public CountingInputStream(File file) throws FileNotFoundException {
        super(new BufferedInputStream(new FileInputStream(file), 0x100000));
        this.total = file.length();
    }

    public CountingInputStream(InputStream stream, long total) throws FileNotFoundException {
        super(new BufferedInputStream(stream, 0x100000));
        this.total = total;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        int read = super.read(buf, off, len);
        this.count += (long)read;
        for (int i = off; i < off + len; ++i) {
            if (buf[i] != 10) continue;
            ++this.newLines;
        }
        return read;
    }

    @Override
    public int read() throws IOException {
        ++this.count;
        int read = super.read();
        if (read == 10) {
            ++this.newLines;
        }
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        this.count += n;
        return super.skip(n);
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public long getNewLines() {
        return this.newLines;
    }

    @Override
    public long getTotal() {
        return this.total;
    }

    @Override
    public long getPercent() {
        if (this.total <= 0L) {
            return 0L;
        }
        return this.count * 100L / this.total;
    }

    public InputStream getStream() {
        return this.in;
    }

    public CountingReader asReader() throws IOException {
        InputStreamReader reader = new InputStreamReader(this.in, "UTF-8");
        return new CountingReader(reader, this.total);
    }
}

