/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.util;

import apoc.export.util.Reporter;
import apoc.export.util.SizeCounter;
import apoc.result.ProgressInfo;
import java.io.PrintWriter;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.neo4j.graphdb.QueryStatistics;

public class ProgressReporter
implements Reporter {
    private final SizeCounter sizeCounter;
    private final PrintWriter out;
    private final long batchSize;
    long time;
    int counter;
    long totalEntities = 0L;
    long lastBatch = 0L;
    long start = System.currentTimeMillis();
    private final ProgressInfo progressInfo;
    private Consumer<ProgressInfo> consumer;

    public ProgressReporter(SizeCounter sizeCounter, PrintWriter out, ProgressInfo progressInfo) {
        this.sizeCounter = sizeCounter;
        this.out = out;
        this.time = this.start;
        this.progressInfo = progressInfo;
        this.batchSize = progressInfo.batchSize;
    }

    public ProgressReporter withConsumer(Consumer<ProgressInfo> consumer) {
        this.consumer = consumer;
        return this;
    }

    @Override
    public void progress(String msg) {
        long now = System.currentTimeMillis();
        this.println(String.format(msg + " %d. %d%%: %s time %d ms total %d ms", this.counter++, this.percent(), this.progressInfo, now - this.time, now - this.start));
        this.time = now;
    }

    private void println(String message) {
        if (this.out != null) {
            this.out.println(message);
        }
    }

    private long percent() {
        return this.sizeCounter == null ? 100L : this.sizeCounter.getPercent();
    }

    @Override
    public void update(long nodes, long relationships, long properties) {
        this.time = System.currentTimeMillis();
        this.progressInfo.update(nodes, relationships, properties);
        this.totalEntities += nodes + relationships;
        this.acceptBatch();
    }

    public void acceptBatch() {
        if (this.batchSize != -1L && this.totalEntities / this.batchSize > this.lastBatch) {
            this.updateRunningBatch(this.progressInfo);
            if (this.consumer != null) {
                this.consumer.accept(this.progressInfo);
            }
        }
    }

    public void updateRunningBatch(ProgressInfo progressInfo) {
        progressInfo.batches = this.lastBatch = Math.max(this.totalEntities / this.batchSize, this.lastBatch);
        this.progressInfo.rows = this.totalEntities;
        this.progressInfo.updateTime(this.start);
    }

    @Override
    public void done() {
        if (this.totalEntities / this.batchSize == this.lastBatch) {
            ++this.lastBatch;
        }
        this.updateRunningBatch(this.progressInfo);
        this.progressInfo.done(this.start);
        if (this.consumer != null) {
            this.consumer.accept(this.progressInfo);
        }
        if (this.consumer != null) {
            this.consumer.accept(ProgressInfo.EMPTY);
        }
    }

    public static void update(QueryStatistics queryStatistics, Reporter reporter) {
        if (queryStatistics.containsUpdates()) {
            reporter.update(queryStatistics.getNodesCreated() - queryStatistics.getNodesDeleted(), queryStatistics.getRelationshipsCreated() - queryStatistics.getRelationshipsDeleted(), queryStatistics.getPropertiesSet());
        }
    }

    @Override
    public ProgressInfo getTotal() {
        this.progressInfo.done(this.start);
        return this.progressInfo;
    }

    public Stream<ProgressInfo> stream() {
        return Stream.of(this.getTotal());
    }

    @Override
    public void nextRow() {
        this.progressInfo.nextRow();
        ++this.totalEntities;
        this.acceptBatch();
    }
}

