/*
 * Decompiled with CFR 0.152.
 */
package apoc.index;

import apoc.index.QueuePoisoningCollector;
import apoc.path.RelationshipTypeAndDirections;
import apoc.result.ListResult;
import apoc.result.NodeResult;
import apoc.util.MapUtil;
import apoc.util.QueueBasedSpliterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.TerminationGuard;
import org.neo4j.values.storable.NoValue;
import org.neo4j.values.storable.Value;

public class SchemaIndex {
    private static final PropertyValueCount POISON = new PropertyValueCount("poison", "poison", "poison", -1L);
    @Context
    public GraphDatabaseAPI db;
    @Context
    public KernelTransaction tx;
    @Context
    public TerminationGuard terminationGuard;

    @Procedure
    @Deprecated
    @Description(value="apoc.index.relatedNodes([nodes],label,key,'<TYPE'/'TYPE>'/'TYPE',limit) yield node - schema range scan which keeps index order and adds limit and checks opposite node of relationship against the given set of nodes")
    public Stream<NodeResult> related(@Name(value="nodes") List<Node> nodes, @Name(value="label") String label, @Name(value="key") String key, @Name(value="relationship") String relationship, @Name(value="limit") long limit) {
        HashSet<Node> nodeSet = new HashSet<Node>(nodes);
        Pair<RelationshipType, Direction> relTypeDirection = RelationshipTypeAndDirections.parse(relationship).get(0);
        RelationshipType type = (RelationshipType)relTypeDirection.first();
        Direction dir = (Direction)relTypeDirection.other();
        return this.queryForRange(label, key, Long.MIN_VALUE, Long.MAX_VALUE, 0L).filter(node -> {
            for (Relationship rel : node.getRelationships(dir, new RelationshipType[]{type})) {
                Node other = rel.getOtherNode(node);
                if (!nodeSet.contains(other)) continue;
                return true;
            }
            return false;
        }).map(NodeResult::new).limit(limit);
    }

    @Procedure
    @Deprecated
    @Description(value="deprecated, just there for compatibility. Use plain cypher instead")
    public Stream<NodeResult> orderedRange(@Name(value="label") String label, @Name(value="key") String key, @Name(value="min") Object min, @Name(value="max") Object max, @Name(value="relevance") boolean relevance, @Name(value="limit") long limit) {
        Map<String, Object> params = MapUtil.map("min", min, "max", max, "limit", limit);
        ArrayList<String> formatValues = new ArrayList<String>();
        formatValues.add(label);
        String query = "MATCH (n:`%s`) WHERE ";
        if (min != null) {
            query = query + "n.`%s` >= $min ";
            formatValues.add(key);
        }
        if (max != null) {
            if (min != null) {
                query = query + "AND ";
            }
            query = query + "n.`%s` <= $max ";
            formatValues.add(key);
        }
        query = query + "RETURN n ORDER by id(n) LIMIT $limit";
        Result result = this.db.execute(String.format(query, formatValues.toArray()), params);
        return result.columnAs("n").stream().map(o -> new NodeResult((Node)o));
    }

    public Stream<Node> queryForRange(@Name(value="label") String label, @Name(value="key") String key, @Name(value="min") Object min, @Name(value="max") Object max, @Name(value="limit") long limit) {
        Map<String, Object> params = MapUtil.map("min", min, "max", max, "limit", limit);
        String query = "MATCH (n:`" + label + "`)";
        if (min != null || max != null) {
            query = query + " WHERE ";
            if (min != null) {
                query = query + "{min} <=";
            }
            query = query + " n.`" + key + "` ";
            if (max != null) {
                query = query + "<= {max}";
            }
        }
        query = query + " RETURN n ";
        if (limit > 0L) {
            query = query + "LIMIT {limit}";
        }
        ResourceIterator it = this.db.execute(query, params).columnAs("n");
        return (Stream)it.stream().onClose(() -> ((ResourceIterator)it).close());
    }

    @Procedure
    @Deprecated
    @Description(value="just use a cypher query with a range predicate on an indexed field and wait for index backed order by in 3.5")
    public Stream<NodeResult> orderedByText(@Name(value="label") String label, @Name(value="key") String key, @Name(value="operator") String operator, @Name(value="value") String value, @Name(value="relevance") boolean relevance, @Name(value="limit") long limit) {
        Map<String, Object> params = MapUtil.map("value", value, "limit", limit);
        Result result = this.db.execute(String.format("MATCH (n:`%s`) WHERE n.`%s` %s $value RETURN n ORDER by id(n) LIMIT $limit", label, key, operator), params);
        return result.columnAs("n").stream().map(o -> new NodeResult((Node)o));
    }

    @Procedure(value="apoc.schema.properties.distinct")
    @Description(value="apoc.schema.properties.distinct(label, key) - quickly returns all distinct values for a given key")
    public Stream<ListResult> distinct(@Name(value="label") String label, @Name(value="key") String key) {
        List<Object> values = this.distinctCount(label, key).map(propertyValueCount -> propertyValueCount.value).collect(Collectors.toList());
        return Stream.of(new ListResult(values));
    }

    @Procedure(value="apoc.schema.properties.distinctCount")
    @Description(value="apoc.schema.properties.distinctCount([label], [key]) YIELD label, key, value, count - quickly returns all distinct values and counts for a given key")
    public Stream<PropertyValueCount> distinctCount(@Name(value="label", defaultValue="") String labelName, @Name(value="key", defaultValue="") String keyName) {
        ThreadToStatementContextBridge ctx = (ThreadToStatementContextBridge)this.db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class, DependencyResolver.SelectionStrategy.FIRST);
        LinkedBlockingDeque queue = new LinkedBlockingDeque(100);
        Iterable indexDefinitions = labelName.isEmpty() ? this.db.schema().getIndexes() : this.db.schema().getIndexes(Label.label((String)labelName));
        new Thread(() -> StreamSupport.stream(indexDefinitions.spliterator(), true).filter(indexDefinition -> this.isIndexCoveringProperty((IndexDefinition)indexDefinition, keyName)).map(indexDefinition -> this.scanIndexDefinitionForKeys((IndexDefinition)indexDefinition, keyName, ctx, queue)).collect(new QueuePoisoningCollector<PropertyValueCount>(queue, POISON))).start();
        return StreamSupport.stream(new QueueBasedSpliterator<PropertyValueCount>(queue, POISON, this.terminationGuard, Long.MAX_VALUE), false);
    }

    private Object scanIndexDefinitionForKeys(IndexDefinition indexDefinition, @Name(value="key", defaultValue="") String keyName, ThreadToStatementContextBridge ctx, BlockingQueue<PropertyValueCount> queue) {
        try (Transaction threadTx = this.db.beginTx();){
            KernelTransaction ktx = ctx.getKernelTransactionBoundToThisThread(true);
            List<String> keys = keyName.isEmpty() ? indexDefinition.getPropertyKeys() : Collections.singletonList(keyName);
            for (String key : keys) {
                KernelStatement ignored = (KernelStatement)ktx.acquireStatement();
                Throwable throwable = null;
                try {
                    SchemaRead schemaRead = ktx.schemaRead();
                    TokenRead tokenRead = ktx.tokenRead();
                    Read read = ktx.dataRead();
                    CursorFactory cursors = ktx.cursors();
                    int[] propertyKeyIds = StreamSupport.stream(indexDefinition.getPropertyKeys().spliterator(), false).mapToInt(name -> tokenRead.propertyKey(name)).toArray();
                    LabelSchemaDescriptor schema = SchemaDescriptorFactory.forLabel((int)tokenRead.nodeLabel(indexDefinition.getLabel().name()), (int[])propertyKeyIds);
                    IndexReference indexReference = schemaRead.index((SchemaDescriptor)schema);
                    this.scanIndex(queue, indexDefinition, key, read, cursors, indexReference);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ignored == null) continue;
                    if (throwable != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ignored.close();
                }
            }
            threadTx.success();
            Iterator iterator = null;
            return iterator;
        }
    }

    private void scanIndex(BlockingQueue<PropertyValueCount> queue, IndexDefinition indexDefinition, String key, Read read, CursorFactory cursors, IndexReference indexReference) {
        try (NodeValueIndexCursor cursor = cursors.allocateNodeValueIndexCursor();){
            read.nodeIndexScan(indexReference, cursor, IndexOrder.NONE, true);
            NoValue previousValue = NoValue.NO_VALUE;
            long count = 0L;
            while (cursor.next()) {
                for (int i = 0; i < cursor.numberOfProperties(); ++i) {
                    int k = cursor.propertyKey(i);
                    Value v = cursor.propertyValue(i);
                    if (v.equals((Value)previousValue)) {
                        ++count;
                        continue;
                    }
                    if (!previousValue.equals((Value)NoValue.NO_VALUE)) {
                        this.putIntoQueue(queue, indexDefinition, key, (Value)previousValue, count);
                    }
                    previousValue = v;
                    count = 1L;
                }
            }
            this.putIntoQueue(queue, indexDefinition, key, (Value)previousValue, count);
        }
        catch (KernelException e) {
            throw new RuntimeException(e);
        }
    }

    private void putIntoQueue(BlockingQueue<PropertyValueCount> queue, IndexDefinition indexDefinition, String key, Value value, long count) {
        try {
            queue.put(new PropertyValueCount(indexDefinition.getLabel().name(), key, value.asObject(), count));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isIndexCoveringProperty(IndexDefinition indexDefinition, String properttyKeyName) {
        try (Transaction threadTx = this.db.beginTx();){
            threadTx.success();
            boolean bl = properttyKeyName.isEmpty() || this.contains(indexDefinition.getPropertyKeys(), properttyKeyName);
            return bl;
        }
    }

    private boolean contains(Iterable<String> list, String search) {
        for (String element : list) {
            if (!element.equals(search)) continue;
            return true;
        }
        return false;
    }

    public static class PropertyValueCount {
        public String label;
        public String key;
        public Object value;
        public long count;

        public PropertyValueCount(String label, String key, Object value, long count) {
            this.label = label;
            this.key = key;
            this.value = value;
            this.count = count;
        }

        public String toString() {
            return "PropertyValueCount{label='" + this.label + '\'' + ", key='" + this.key + '\'' + ", value='" + this.value + '\'' + ", count=" + this.count + '}';
        }
    }
}

