/*
 * Decompiled with CFR 0.152.
 */
package apoc.load;

import apoc.export.util.CountingReader;
import apoc.load.util.LoadCsvConfig;
import apoc.meta.Meta;
import apoc.util.FileUtils;
import apoc.util.Util;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class LoadCsv {
    @Context
    public GraphDatabaseService db;

    @Procedure
    @Description(value="apoc.load.csv('url',{config}) YIELD lineNo, list, map - load CSV fom URL as stream of values,\n config contains any of: {skip:1,limit:5,header:false,sep:'TAB',ignore:['tmp'],nullValues:['na'],arraySep:';',mapping:{years:{type:'int',arraySep:'-',array:false,name:'age',ignore:false}}")
    public Stream<CSVResult> csv(@Name(value="url") String url, @Name(value="config", defaultValue="{}") Map<String, Object> configMap) {
        LoadCsvConfig config = new LoadCsvConfig(configMap);
        CountingReader reader = null;
        try {
            reader = FileUtils.readerFor(url);
            return this.streamCsv(url, config, reader);
        }
        catch (IOException e) {
            FileUtils.closeReaderSafely(reader);
            if (!config.isFailOnError()) {
                return Stream.of(new CSVResult(new String[0], new String[0], 0L, true, Collections.emptyMap(), Collections.emptyList(), EnumSet.noneOf(LoadCsvConfig.Results.class)));
            }
            throw new RuntimeException("Can't read CSV from URL " + Util.cleanUrl(url), e);
        }
    }

    public Stream<CSVResult> streamCsv(@Name(value="url") String url, LoadCsvConfig config, CountingReader reader) throws IOException {
        CSVReader csv = new CSVReaderBuilder((Reader)reader).withCSVParser((ICSVParser)new CSVParserBuilder().withQuoteChar(config.getQuoteChar()).withIgnoreQuotations(config.isIgnoreQuotations()).withSeparator(config.getSeparator()).build()).build();
        String[] header = this.getHeader(csv, config);
        boolean checkIgnore = !config.getIgnore().isEmpty() || config.getMappings().values().stream().anyMatch(m -> m.ignore);
        return (Stream)StreamSupport.stream(new CSVSpliterator(csv, header, url, config.getSkip(), config.getLimit(), checkIgnore, config.getMappings(), config.getNullValues(), config.getResults(), config.getIgnoreErrors()), false).onClose(() -> FileUtils.closeReaderSafely(reader));
    }

    private String[] getHeader(CSVReader csv, LoadCsvConfig config) throws IOException {
        if (!config.isHasHeader()) {
            return null;
        }
        String[] headers = csv.readNext();
        List<String> ignore = config.getIgnore();
        if (ignore.isEmpty()) {
            return headers;
        }
        Map<String, Mapping> mappings = config.getMappings();
        for (int i = 0; i < headers.length; ++i) {
            String header = headers[i];
            if (!ignore.contains(header) && !mappings.getOrDefault((Object)header, (Mapping)Mapping.EMPTY).ignore) continue;
            headers[i] = null;
        }
        return headers;
    }

    private static class CSVSpliterator
    extends Spliterators.AbstractSpliterator<CSVResult> {
        private final CSVReader csv;
        private final String[] header;
        private final String url;
        private final long limit;
        private final boolean ignore;
        private final Map<String, Mapping> mapping;
        private final List<String> nullValues;
        private final EnumSet<LoadCsvConfig.Results> results;
        private final boolean ignoreErrors;
        long lineNo;

        public CSVSpliterator(CSVReader csv, String[] header, String url, long skip, long limit, boolean ignore, Map<String, Mapping> mapping, List<String> nullValues, EnumSet<LoadCsvConfig.Results> results, boolean ignoreErrors) throws IOException {
            super(Long.MAX_VALUE, 16);
            this.csv = csv;
            this.header = header;
            this.url = url;
            this.ignore = ignore;
            this.mapping = mapping;
            this.nullValues = nullValues;
            this.results = results;
            this.ignoreErrors = ignoreErrors;
            this.limit = skip + limit;
            this.lineNo = skip;
            while (skip-- > 0L) {
                csv.readNext();
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super CSVResult> action) {
            try {
                String[] row = this.csv.readNext();
                if (row != null && this.lineNo < this.limit) {
                    action.accept(new CSVResult(this.header, row, this.lineNo, this.ignore, this.mapping, this.nullValues, this.results));
                    ++this.lineNo;
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading CSV from URL " + Util.cleanUrl(this.url) + " at " + this.lineNo, e);
            }
        }
    }

    public static class CSVResult {
        public long lineNo;
        public List<Object> list;
        public List<String> strings;
        public Map<String, Object> map;
        public Map<String, String> stringMap;

        public CSVResult(String[] header, String[] list, long lineNo, boolean ignore, Map<String, Mapping> mapping, List<String> nullValues, EnumSet<LoadCsvConfig.Results> results) {
            this.lineNo = lineNo;
            this.removeNullValues(list, nullValues);
            this.strings = results.contains((Object)LoadCsvConfig.Results.strings) ? this.createList(header, list, ignore, mapping, false) : Collections.emptyList();
            this.stringMap = results.contains((Object)LoadCsvConfig.Results.stringMap) ? this.createMap(header, list, ignore, mapping, false) : Collections.emptyMap();
            this.map = results.contains((Object)LoadCsvConfig.Results.map) ? this.createMap(header, list, ignore, mapping, true) : Collections.emptyMap();
            this.list = results.contains((Object)LoadCsvConfig.Results.list) ? this.createList(header, list, ignore, mapping, true) : Collections.emptyList();
        }

        public void removeNullValues(String[] list, List<String> nullValues) {
            if (nullValues.isEmpty()) {
                return;
            }
            for (int i = 0; i < list.length; ++i) {
                if (!nullValues.contains(list[i])) continue;
                list[i] = null;
            }
        }

        private List<Object> createList(String[] header, String[] list, boolean ignore, Map<String, Mapping> mappings, boolean convert) {
            if (!ignore && mappings.isEmpty()) {
                return Arrays.asList((Object[])list);
            }
            ArrayList<Object> result = new ArrayList<Object>(list.length);
            for (int i = 0; i < header.length; ++i) {
                String name = header[i];
                if (name == null) continue;
                Mapping mapping = mappings.get(name);
                if (mapping != null) {
                    if (mapping.ignore) continue;
                    result.add(convert ? mapping.convert(list[i]) : list[i]);
                    continue;
                }
                result.add(list[i]);
            }
            return result;
        }

        private Map<String, Object> createMap(String[] header, String[] list, boolean ignore, Map<String, Mapping> mappings, boolean convert) {
            if (header == null) {
                return null;
            }
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(header.length, 1.0f);
            for (int i = 0; i < header.length; ++i) {
                String name = header[i];
                if (ignore && name == null) continue;
                Mapping mapping = mappings.get(name);
                if (mapping == null) {
                    map.put(name, list[i]);
                    continue;
                }
                if (mapping.ignore) continue;
                map.put(mapping.name, convert ? mapping.convert(list[i]) : list[i]);
            }
            return map;
        }
    }

    public static class Mapping {
        public static final Mapping EMPTY = new Mapping("", Collections.emptyMap(), ';', false);
        final String name;
        final Collection<String> nullValues;
        final Meta.Types type;
        final boolean array;
        final boolean ignore;
        final char arraySep;
        private final Pattern arrayPattern;

        public Mapping(String name, Map<String, Object> mapping, char arraySep, boolean ignore) {
            this.name = mapping.getOrDefault("name", name).toString();
            this.array = (Boolean)mapping.getOrDefault("array", false);
            this.ignore = (Boolean)mapping.getOrDefault("ignore", ignore);
            this.nullValues = mapping.getOrDefault("nullValues", Collections.emptyList());
            this.arraySep = Util.parseCharFromConfig(mapping, "arraySep", arraySep);
            this.type = Meta.Types.from(mapping.getOrDefault("type", "STRING").toString());
            this.arrayPattern = Pattern.compile(String.valueOf(this.arraySep), 16);
            if (this.type == null) {
                throw new RuntimeException("In specified mapping, there is no type by the name " + mapping.getOrDefault("type", "STRING").toString());
            }
        }

        public Object convert(String value) {
            return this.array ? this.convertArray(value) : this.convertType(value);
        }

        private Object convertArray(String value) {
            String[] values = this.arrayPattern.split(value);
            ArrayList<Object> result = new ArrayList<Object>(values.length);
            for (String v : values) {
                result.add(this.convertType(v));
            }
            return result;
        }

        private Object convertType(String value) {
            if (this.nullValues.contains(value)) {
                return null;
            }
            if (this.type == Meta.Types.STRING) {
                return value;
            }
            switch (this.type) {
                case INTEGER: {
                    return Util.toLong(value);
                }
                case FLOAT: {
                    return Util.toDouble(value);
                }
                case BOOLEAN: {
                    return Util.toBoolean(value);
                }
                case NULL: {
                    return null;
                }
                case LIST: {
                    return Arrays.stream(this.arrayPattern.split(value)).map(this::convertType).collect(Collectors.toList());
                }
            }
            return value;
        }
    }
}

