/*
 * Decompiled with CFR 0.152.
 */
package apoc.lock;

import java.util.List;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class Lock {
    @Context
    public GraphDatabaseService db;

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.lock.all([nodes],[relationships]) acquires a write lock on the given nodes and relationships")
    public void all(@Name(value="nodes") List<Node> nodes, @Name(value="rels") List<Relationship> rels) {
        try (Transaction tx = this.db.beginTx();){
            for (Node node : nodes) {
                tx.acquireWriteLock((PropertyContainer)node);
            }
            for (Relationship rel : rels) {
                tx.acquireWriteLock((PropertyContainer)rel);
            }
            tx.success();
        }
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.lock.nodes([nodes]) acquires a write lock on the given nodes")
    public void nodes(@Name(value="nodes") List<Node> nodes) {
        try (Transaction tx = this.db.beginTx();){
            for (Node node : nodes) {
                tx.acquireWriteLock((PropertyContainer)node);
            }
            tx.success();
        }
    }

    @Procedure(mode=Mode.READ, name="apoc.lock.read.nodes")
    @Description(value="apoc.lock.read.nodes([nodes]) acquires a read lock on the given nodes")
    public void readLockOnNodes(@Name(value="nodes") List<Node> nodes) {
        try (Transaction tx = this.db.beginTx();){
            for (Node node : nodes) {
                tx.acquireReadLock((PropertyContainer)node);
            }
            tx.success();
        }
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.lock.rels([relationships]) acquires a write lock on the given relationship")
    public void rels(@Name(value="rels") List<Relationship> rels) {
        try (Transaction tx = this.db.beginTx();){
            for (Relationship rel : rels) {
                tx.acquireWriteLock((PropertyContainer)rel);
            }
            tx.success();
        }
    }

    @Procedure(mode=Mode.READ, name="apoc.lock.read.rels")
    @Description(value="apoc.lock.read.rels([relationships]) acquires a read lock on the given relationship")
    public void readLocksOnRels(@Name(value="rels") List<Relationship> rels) {
        try (Transaction tx = this.db.beginTx();){
            for (Relationship rel : rels) {
                tx.acquireReadLock((PropertyContainer)rel);
            }
            tx.success();
        }
    }
}

