/*
 * Decompiled with CFR 0.152.
 */
package apoc.log;

import apoc.ApocConfiguration;
import apoc.util.SimpleRateLimiter;
import java.util.List;
import java.util.function.Consumer;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class Logging {
    private static LoggingType LOGGING_TYPE = LoggingType.valueOf(ApocConfiguration.get("user.log.type", "safe").trim());
    private static SimpleRateLimiter RATE_LIMITER = new SimpleRateLimiter(Long.valueOf(ApocConfiguration.get("user.log.window.time", "10000")), Integer.valueOf(ApocConfiguration.get("user.log.window.ops", "10")));
    @Context
    public Log log;

    public Logging() {
    }

    public Logging(LoggingType loggingType, long timeWindow, int maxOpsPerWindow) {
        LOGGING_TYPE = loggingType;
        RATE_LIMITER = new SimpleRateLimiter(timeWindow, maxOpsPerWindow);
    }

    @Procedure
    @Description(value="apoc.log.error(message, params) - logs error message")
    public void error(@Name(value="message") String message, @Name(value="params", defaultValue="[]") List<Object> params) {
        this.log(logMessage -> this.log.error(logMessage), message, params);
    }

    @Procedure
    @Description(value="apoc.log.warn(message, params) - logs warn message")
    public void warn(@Name(value="message") String message, @Name(value="params", defaultValue="[]") List<Object> params) {
        this.log(logMessage -> this.log.warn(logMessage), message, params);
    }

    @Procedure
    @Description(value="apoc.log.info(message, params) - logs info message")
    public void info(@Name(value="message") String message, @Name(value="params", defaultValue="[]") List<Object> params) {
        this.log(logMessage -> this.log.info(logMessage), message, params);
    }

    @Procedure
    @Description(value="apoc.log.debug(message, params) - logs debug message")
    public void debug(@Name(value="message") String message, @Name(value="params", defaultValue="[]") List<Object> params) {
        this.log(logMessage -> this.log.debug(logMessage), message, params);
    }

    public String format(String message, List<Object> params) {
        if (this.canLog()) {
            String formattedMessage = String.format(message, params.isEmpty() ? new Object[]{} : params.toArray(new Object[params.size()]));
            if (LoggingType.safe == LOGGING_TYPE) {
                return formattedMessage.replaceAll("\\.| |\\t", "_").toLowerCase();
            }
            return formattedMessage;
        }
        return null;
    }

    private void log(Consumer<String> consumer, String message, List<Object> params) {
        String format = this.format(message, params);
        if (format != null) {
            consumer.accept(format);
        }
    }

    private boolean canLog() {
        if (LoggingType.none == LOGGING_TYPE) {
            return false;
        }
        return RATE_LIMITER.canExecute();
    }

    static enum LoggingType {
        none,
        safe,
        raw;

    }
}

