/*
 * Decompiled with CFR 0.152.
 */
package apoc.math;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;

public class Maths {
    @UserFunction
    @Description(value="apoc.math.round(value,[prec],mode=[CEILING,FLOOR,UP,DOWN,HALF_EVEN,HALF_DOWN,HALF_UP,DOWN,UNNECESSARY])")
    public Double round(@Name(value="value") Double value, @Name(value="precision", defaultValue="0") long precision, @Name(value="mode", defaultValue="HALF_UP") String mode) {
        if (value == null) {
            return null;
        }
        return BigDecimal.valueOf(value).setScale((int)precision, RoundingMode.valueOf(mode)).doubleValue();
    }

    @UserFunction
    @Description(value="apoc.math.maxLong() | return the maximum value a long can have")
    public Long maxLong() {
        return Long.MAX_VALUE;
    }

    @UserFunction
    @Description(value="apoc.math.minLong() | return the minimum value a long can have")
    public Long minLong() {
        return Long.MIN_VALUE;
    }

    @UserFunction
    @Description(value="apoc.math.maxDouble() | return the largest positive finite value of type double")
    public Double maxDouble() {
        return Double.MAX_VALUE;
    }

    @UserFunction
    @Description(value="apoc.math.minDouble() | return the smallest positive nonzero value of type double")
    public Double minDouble() {
        return Double.MIN_VALUE;
    }

    @UserFunction
    @Description(value="apoc.math.maxInt() | return the maximum value an int can have")
    public Long maxInt() {
        return Integer.MAX_VALUE;
    }

    @UserFunction
    @Description(value="apoc.math.minInt() | return the minimum value an int can have")
    public Long minInt() {
        return Integer.MIN_VALUE;
    }

    @UserFunction
    @Description(value="apoc.math.maxByte() | return the maximum value an byte can have")
    public Long maxByte() {
        return 127L;
    }

    @UserFunction
    @Description(value="apoc.math.minByte() | return the minimum value an byte can have")
    public Long minByte() {
        return -128L;
    }
}

