/*
 * Decompiled with CFR 0.152.
 */
package apoc.meta;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MetaConfig {
    private Set<String> includesLabels;
    private Set<String> includesRels;
    private Set<String> excludes;
    private long maxRels;
    private long sample;

    public MetaConfig(Map<String, Object> config) {
        config = config != null ? config : Collections.emptyMap();
        this.includesLabels = new HashSet<String>((Collection)config.getOrDefault("labels", Collections.EMPTY_SET));
        this.includesRels = new HashSet<String>((Collection)config.getOrDefault("rels", Collections.EMPTY_SET));
        this.excludes = new HashSet<String>((Collection)config.getOrDefault("excludes", Collections.EMPTY_SET));
        this.sample = (Long)config.getOrDefault("sample", 1000L);
        this.maxRels = (Long)config.getOrDefault("maxRels", 100L);
    }

    public Set<String> getIncludesLabels() {
        return this.includesLabels;
    }

    public Set<String> getIncludesRels() {
        return this.includesRels;
    }

    public Set<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(Set<String> excludes) {
        this.excludes = excludes;
    }

    public long getSample() {
        return this.sample;
    }

    public long getMaxRels() {
        return this.maxRels;
    }
}

