/*
 * Decompiled with CFR 0.152.
 */
package apoc.number.exact;

import apoc.Description;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.apache.commons.lang.StringUtils;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;

public class Exact {
    @UserFunction
    @Description(value="apoc.number.exact.add(stringA,stringB) - return the sum's result of two large numbers")
    public String add(@Name(value="stringA") String stringA, @Name(value="stringB") String stringB) {
        if (stringA == null || stringA.isEmpty() || stringB == null || stringB.isEmpty()) {
            return null;
        }
        return new BigDecimal(stringA).add(new BigDecimal(stringB)).toPlainString();
    }

    @UserFunction
    @Description(value="apoc.number.exact.sub(stringA,stringB) - return the substraction's of two large numbers")
    public String sub(@Name(value="stringA") String stringA, @Name(value="stringB") String stringB) {
        if (stringA == null || stringA.isEmpty() || stringB == null || stringB.isEmpty()) {
            return null;
        }
        return new BigDecimal(stringA).subtract(new BigDecimal(stringB)).toPlainString();
    }

    @UserFunction
    @Description(value="apoc.number.exact.mul(stringA,stringB,[prec],[roundingModel]) - return the multiplication's result of two large numbers ")
    public String mul(@Name(value="stringA") String stringA, @Name(value="stringB") String stringB, @Name(value="precision", defaultValue="0") Long precision, @Name(value="roundingMode", defaultValue="HALF_UP") String roundingMode) {
        if (stringA == null || stringA.isEmpty() || stringB == null || stringB.isEmpty()) {
            return null;
        }
        String s = new BigDecimal(stringA).multiply(new BigDecimal(stringB), this.createMathContext(precision, roundingMode)).toPlainString();
        return s;
    }

    @UserFunction
    @Description(value="apoc.number.exact.div(stringA,stringB,[prec],[roundingModel]) - return the division's result of two large numbers")
    public String div(@Name(value="stringA") String stringA, @Name(value="stringB") String stringB, @Name(value="precision", defaultValue="0") Long precision, @Name(value="roundingMode", defaultValue="HALF_UP") String roundingMode) {
        if (stringA == null || stringA.isEmpty() || stringB == null || stringB.isEmpty()) {
            return null;
        }
        return new BigDecimal(stringA).divide(new BigDecimal(stringB), this.createMathContext(precision, roundingMode)).toPlainString();
    }

    @UserFunction
    @Description(value="apoc.number.exact.toInteger(string,[prec],[roundingMode]) - return the Integer value of a large number")
    public Long toInteger(@Name(value="stringA") String string, @Name(value="precision", defaultValue="0") Long precision, @Name(value="roundingMode", defaultValue="HALF_UP") String roundingMode) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        return new BigDecimal(string, this.createMathContextLong(precision, roundingMode)).longValue();
    }

    @UserFunction
    @Description(value="apoc.number.exact.toFloat(string,[prec],[roundingMode]) - return the Float value of a large number")
    public Double toFloat(@Name(value="stringA") String string, @Name(value="precision", defaultValue="0") Long precision, @Name(value="roundingMode", defaultValue="HALF_UP") String roundingMode) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        return new BigDecimal(string, this.createMathContext(precision, roundingMode)).doubleValue();
    }

    @UserFunction
    @Description(value="apoc.number.exact.toExact(number) - return the exact value")
    public Long toExact(@Name(value="number") Long number) {
        if (number == null) {
            return null;
        }
        return new BigDecimal(number).longValueExact();
    }

    private MathContext createMathContext(Long precision, String roundingMode) {
        if (precision == null) {
            precision = 0L;
        }
        RoundingMode rm = RoundingMode.HALF_UP;
        if (!StringUtils.isEmpty((String)roundingMode) || roundingMode != null) {
            rm = RoundingMode.valueOf(roundingMode);
        }
        return new MathContext(precision.intValue(), rm);
    }

    private MathContext createMathContextLong(Long precision, String roundingMode) {
        if (precision == null) {
            precision = 0L;
        } else {
            Double pow = Math.pow(10.0, precision.longValue());
            precision = precision * pow.longValue();
        }
        RoundingMode rm = RoundingMode.HALF_UP;
        if (!StringUtils.isEmpty((String)roundingMode) || roundingMode != null) {
            rm = RoundingMode.valueOf(roundingMode);
        }
        return new MathContext(precision.intValue(), rm);
    }
}

