/*
 * Decompiled with CFR 0.152.
 */
package apoc.refactor.util;

import apoc.util.Util;
import java.util.Collections;
import java.util.Map;

public class RefactorConfig {
    public static final String COMBINE = "combine";
    public static final String DISCARD = "discard";
    public static final String OVERWRITE = "overwrite";
    public static final String OVERRIDE = "override";
    private static String MATCH_ALL = ".*";
    private Map<String, String> propertiesManagement = Collections.singletonMap(MATCH_ALL, "overwrite");
    private boolean mergeRelsAllowed;
    private boolean mergeVirtualRels;
    private boolean selfRel;
    private boolean countMerge;
    private boolean hasProperties;
    private boolean collapsedLabel;

    public RefactorConfig(Map<String, Object> config) {
        Object value = config.get("properties");
        boolean bl = this.hasProperties = value != null;
        if (value instanceof String) {
            this.propertiesManagement = Collections.singletonMap(MATCH_ALL, value.toString());
        } else if (value instanceof Map) {
            this.propertiesManagement = (Map)value;
        }
        this.mergeRelsAllowed = Util.toBoolean(config.get("mergeRels"));
        this.mergeVirtualRels = Util.toBoolean(config.getOrDefault("mergeRelsVirtual", true));
        this.selfRel = Util.toBoolean(config.get("selfRel"));
        this.countMerge = Util.toBoolean(config.getOrDefault("countMerge", true));
        this.collapsedLabel = Util.toBoolean(config.get("collapsedLabel"));
    }

    public String getMergeMode(String name) {
        for (String key : this.propertiesManagement.keySet()) {
            if (key.equals(MATCH_ALL) || !name.matches(key)) continue;
            return this.propertiesManagement.get(key);
        }
        return this.propertiesManagement.getOrDefault(name, this.propertiesManagement.getOrDefault(MATCH_ALL, OVERWRITE));
    }

    public String getMergeModeVirtual(String name) {
        for (String key : this.propertiesManagement.keySet()) {
            if (key.equals(MATCH_ALL) || !name.matches(key)) continue;
            return this.propertiesManagement.get(key);
        }
        return this.propertiesManagement.getOrDefault(name, this.propertiesManagement.getOrDefault(MATCH_ALL, DISCARD));
    }

    public boolean getMergeRelsAllowed() {
        return this.mergeRelsAllowed;
    }

    public boolean isSelfRel() {
        return this.selfRel;
    }

    public boolean hasProperties() {
        return this.hasProperties;
    }

    public boolean isCountMerge() {
        return this.countMerge;
    }

    public boolean isCollapsedLabel() {
        return this.collapsedLabel;
    }

    public boolean isMergeVirtualRels() {
        return this.mergeVirtualRels;
    }
}

