/*
 * Decompiled with CFR 0.152.
 */
package apoc.spatial;

import apoc.result.DistancePathResult;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class Distance {
    private static final String LATITUDE = "latitude";
    private static final String LONGITUDE = "longitude";
    @Context
    public GraphDatabaseService db;

    @Procedure
    @Description(value="apoc.spatial.sortPathsByDistance(List<Path>) sort the given paths based on the geo informations (lat/long) in ascending order")
    public Stream<DistancePathResult> sortByDistance(@Name(value="paths") List<Path> paths) {
        return paths.size() > 0 ? this.sortPaths(paths).stream() : Stream.empty();
    }

    public SortedSet<DistancePathResult> sortPaths(List<Path> paths) {
        TreeSet<DistancePathResult> result = new TreeSet<DistancePathResult>();
        for (int i = 0; i <= paths.size() - 1; ++i) {
            double d = this.getPathDistance(paths.get(i));
            result.add(new DistancePathResult(paths.get(i), d));
        }
        return result;
    }

    public double getPathDistance(Path path) {
        double distance = 0.0;
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Node node : path.nodes()) {
            this.checkNodeHasGeo(node);
            nodes.add(node);
        }
        for (int i = 1; i <= nodes.size() - 1; ++i) {
            Node prev = (Node)nodes.get(i - 1);
            Node curr = (Node)nodes.get(i);
            distance += this.getDistance((Double)prev.getProperty(LATITUDE), (Double)prev.getProperty(LONGITUDE), (Double)curr.getProperty(LATITUDE), (Double)curr.getProperty(LONGITUDE));
        }
        return distance;
    }

    public double getDistance(double lat1, double lon1, double lat2, double lon2) {
        double theta = lon1 - lon2;
        double dist = Math.sin(this.deg2rad(lat1)) * Math.sin(this.deg2rad(lat2)) + Math.cos(this.deg2rad(lat1)) * Math.cos(this.deg2rad(lat2)) * Math.cos(this.deg2rad(theta));
        dist = Math.acos(dist);
        dist = this.rad2deg(dist);
        dist = dist * 60.0 * 1.1515;
        return dist * 1.609344;
    }

    private double deg2rad(double deg) {
        return deg * Math.PI / 180.0;
    }

    private double rad2deg(double rad) {
        return rad * 180.0 / Math.PI;
    }

    private void checkNodeHasGeo(Node node) {
        if (!node.hasProperty(LATITUDE) || !node.hasProperty(LONGITUDE)) {
            throw new IllegalArgumentException(String.format("Node with id %s has invalid geo properties", node.getId()));
        }
    }
}

