/*
 * Decompiled with CFR 0.152.
 */
package apoc.util;

import apoc.util.Util;
import java.util.Spliterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.neo4j.procedure.TerminationGuard;

public class QueueBasedSpliterator<T>
implements Spliterator<T> {
    private final BlockingQueue<T> queue;
    private T tombstone;
    private T entry;
    private TerminationGuard terminationGuard;
    private final long timeout;

    public QueueBasedSpliterator(BlockingQueue<T> queue, T tombstone, TerminationGuard terminationGuard) {
        this(queue, tombstone, terminationGuard, 10L);
    }

    public QueueBasedSpliterator(BlockingQueue<T> queue, T tombstone, TerminationGuard terminationGuard, long timeout) {
        this.queue = queue;
        this.tombstone = tombstone;
        this.terminationGuard = terminationGuard;
        this.timeout = timeout;
        this.entry = this.poll();
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        if (Util.transactionIsTerminated(this.terminationGuard)) {
            return false;
        }
        if (this.isEnd()) {
            return false;
        }
        action.accept(this.entry);
        this.entry = this.poll();
        return !this.isEnd();
    }

    private boolean isEnd() {
        return this.entry == null || this.entry == this.tombstone;
    }

    private T poll() {
        try {
            return this.queue.poll(this.timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    @Override
    public Spliterator<T> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return 256;
    }
}

