/*
 * Decompiled with CFR 0.152.
 */
package apoc;

import apoc.export.util.ExportConfig;
import apoc.load.Jdbc;
import apoc.util.FileUtils;
import apoc.util.SimpleRateLimiter;
import java.lang.reflect.Field;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.combined.CombinedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.ex.ConversionException;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.internal.LogService;
import org.neo4j.procedure.impl.GlobalProceduresRegistry;

public class ApocConfig
extends LifecycleAdapter {
    public static final String SUN_JAVA_COMMAND = "sun.java.command";
    public static final String APOC_IMPORT_FILE_ENABLED = "apoc.import.file.enabled";
    public static final String APOC_EXPORT_FILE_ENABLED = "apoc.export.file.enabled";
    public static final String APOC_IMPORT_FILE_USE_NEO4J_CONFIG = "apoc.import.file.use_neo4j_config";
    public static final String APOC_TTL_SCHEDULE = "apoc.ttl.schedule";
    public static final String APOC_TTL_ENABLED = "apoc.ttl.enabled";
    public static final String APOC_TTL_LIMIT = "apoc.ttl.limit";
    public static final String APOC_TRIGGER_ENABLED = "apoc.trigger.enabled";
    public static final String APOC_UUID_ENABLED = "apoc.uuid.enabled";
    public static final String APOC_JSON_ZIP_URL = "apoc.json.zip.url";
    public static final String APOC_JSON_SIMPLE_JSON_URL = "apoc.json.simpleJson.url";
    public static final String APOC_IMPORT_FILE_ALLOW__READ__FROM__FILESYSTEM = "apoc.import.file.allow_read_from_filesystem";
    public static final String APOC_CONFIG_JOBS_SCHEDULED_NUM_THREADS = "apoc.jobs.scheduled.num_threads";
    public static final String APOC_CONFIG_JOBS_POOL_NUM_THREADS = "apoc.jobs.pool.num_threads";
    public static final String APOC_CONFIG_INITIALIZER_CYPHER = "apoc.initializer.cypher";
    private static final List<Setting> NEO4J_DIRECTORY_CONFIGURATION_SETTING_NAMES = new ArrayList<Setting>(Arrays.asList(GraphDatabaseSettings.data_directory, GraphDatabaseSettings.load_csv_file_url_root, GraphDatabaseSettings.logs_directory, GraphDatabaseSettings.plugin_dir, GraphDatabaseSettings.logical_logs_location, GraphDatabaseSettings.transaction_logs_root_path, GraphDatabaseSettings.neo4j_home));
    private static final String DEFAULT_PATH = ".";
    private static final String CONFIG_DIR = "config-dir=";
    private final Config neo4jConfig;
    private final Log log;
    private final GlobalProceduresRegistry globalProceduresRegistry;
    private final DatabaseManagementService databaseManagementService;
    private Configuration config;
    private static ApocConfig theInstance;
    private LoggingType loggingType;
    private SimpleRateLimiter rateLimiter;
    private GraphDatabaseService systemDb;

    public ApocConfig(Config neo4jConfig, LogService log, GlobalProceduresRegistry globalProceduresRegistry, DatabaseManagementService databaseManagementService) {
        this.neo4jConfig = neo4jConfig;
        this.log = log.getInternalLog(ApocConfig.class);
        this.globalProceduresRegistry = globalProceduresRegistry;
        this.databaseManagementService = databaseManagementService;
        theInstance = this;
        globalProceduresRegistry.registerComponent(((Object)((Object)this)).getClass(), ctx -> this, true);
        this.log.info("successfully registered ApocConfig for @Context");
    }

    public ApocConfig() {
        this.neo4jConfig = null;
        this.log = NullLog.getInstance();
        this.globalProceduresRegistry = null;
        this.databaseManagementService = null;
        theInstance = this;
        this.config = new PropertiesConfiguration();
    }

    public Configuration getConfig() {
        return this.config;
    }

    public void init() throws Exception {
        this.log.debug("called init");
        String neo4jConfFolder = System.getenv().getOrDefault("NEO4J_CONF", this.determineNeo4jConfFolder());
        System.setProperty("NEO4J_CONF", neo4jConfFolder);
        this.log.info("system property NEO4J_CONF set to %s", new Object[]{neo4jConfFolder});
        this.loadConfiguration();
    }

    protected String determineNeo4jConfFolder() {
        String command = System.getProperty(SUN_JAVA_COMMAND);
        if (command == null) {
            this.log.warn("system property %s is not set, assuming '.' as conf dir. This might cause `apoc.conf` not getting loaded.", new Object[]{SUN_JAVA_COMMAND});
            return DEFAULT_PATH;
        }
        String neo4jConfFolder = Stream.of(command.split("--")).map(String::trim).filter(s -> s.startsWith(CONFIG_DIR)).map(s -> s.substring(CONFIG_DIR.length())).findFirst().orElse(DEFAULT_PATH);
        if (DEFAULT_PATH.equals(neo4jConfFolder)) {
            this.log.info("cannot determine conf folder from sys property %s, assuming '.' ", new Object[]{command});
        } else {
            this.log.info("from system properties: NEO4J_CONF=%s", new Object[]{neo4jConfFolder});
        }
        return neo4jConfFolder;
    }

    protected void loadConfiguration() {
        try {
            URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource("apoc-config.xml");
            this.log.info("loading apoc meta config from %s", new Object[]{resource.toString()});
            CombinedConfigurationBuilder builder = new CombinedConfigurationBuilder().configure((BuilderParameters)new Parameters().fileBased().setURL(resource));
            this.config = (Configuration)builder.getConfiguration();
            this.neo4jConfig.getDeclaredSettings().entrySet().stream().filter(e -> !this.config.containsKey((String)e.getKey())).filter(e -> ((String)e.getKey()).startsWith("apoc.")).forEach(e -> {
                this.log.info("setting from neo4j.conf: " + (String)e.getKey() + "=" + this.neo4jConfig.get((Setting)e.getValue()));
                this.config.setProperty((String)e.getKey(), this.neo4jConfig.get((Setting)e.getValue()));
            });
            this.addDbmsDirectoriesMetricsSettings();
            for (Setting s : NEO4J_DIRECTORY_CONFIGURATION_SETTING_NAMES) {
                Object value = this.neo4jConfig.get(s);
                if (value == null) continue;
                this.config.setProperty(s.name(), value.toString());
            }
            boolean allowFileUrls = (Boolean)this.neo4jConfig.get(GraphDatabaseSettings.allow_file_urls);
            this.config.setProperty(APOC_IMPORT_FILE_ALLOW__READ__FROM__FILESYSTEM, allowFileUrls);
            this.loadJdbcDrivers();
            this.initLogging();
        }
        catch (ConfigurationException e2) {
            throw new RuntimeException(e2);
        }
    }

    private void addDbmsDirectoriesMetricsSettings() {
        try {
            Class<?> metricsSettingsClass = Class.forName("com.neo4j.kernel.impl.enterprise.configuration.MetricsSettings");
            Field csvPathField = metricsSettingsClass.getDeclaredField("csvPath");
            Setting dbms_directories_metrics = (Setting)csvPathField.get(null);
            NEO4J_DIRECTORY_CONFIGURATION_SETTING_NAMES.add(dbms_directories_metrics);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
    }

    public LoggingType getLoggingType() {
        return this.loggingType;
    }

    public SimpleRateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    public void setLoggingType(LoggingType loggingType) {
        this.loggingType = loggingType;
    }

    public void setRateLimiter(SimpleRateLimiter rateLimiter) {
        this.rateLimiter = rateLimiter;
    }

    public GraphDatabaseService getSystemDb() {
        if (this.systemDb == null) {
            try {
                this.systemDb = this.databaseManagementService.database("system");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.systemDb;
    }

    private void initLogging() {
        this.loggingType = LoggingType.valueOf(this.getString("apoc.user.log.type", "safe").trim());
        this.rateLimiter = new SimpleRateLimiter(this.getInt("apoc.user.log.window.time", 10000), this.getInt("apoc.user.log.window.ops", 10));
    }

    private void loadJdbcDrivers() {
        Iterators.stream(this.config.getKeys("apoc.jdbc")).filter(k -> k.endsWith("driver")).forEach(k -> Jdbc.loadDriver(k));
    }

    public void checkReadAllowed(String url) {
        if (FileUtils.isFile(url) && !this.config.getBoolean(APOC_IMPORT_FILE_ENABLED)) {
            throw new RuntimeException("Import from files not enabled, please set apoc.import.file.enabled=true in your apoc.conf");
        }
    }

    public void checkWriteAllowed(ExportConfig exportConfig) {
        if (!(this.config.getBoolean(APOC_EXPORT_FILE_ENABLED) || exportConfig != null && exportConfig.streamStatements())) {
            throw new RuntimeException("Export to files not enabled, please set apoc.export.file.enabled=true in your apoc.conf");
        }
    }

    public static ApocConfig apocConfig() {
        return theInstance;
    }

    public Iterator<String> getKeys(String prefix) {
        return this.getConfig().getKeys(prefix);
    }

    public boolean containsKey(String key) {
        return this.getConfig().containsKey(key);
    }

    public String getString(String key) {
        return this.getConfig().getString(key);
    }

    public String getString(String key, String defaultValue) {
        return this.getConfig().getString(key, defaultValue);
    }

    public void setProperty(String key, Object value) {
        this.getConfig().setProperty(key, value);
    }

    public boolean getBoolean(String key) {
        return this.getConfig().getBoolean(key);
    }

    public boolean isImportFolderConfigured() {
        String importFolder = this.config.getString("dbms.directories.import");
        if (importFolder == null) {
            return false;
        }
        return !"/target/test data/neo4j".equals(importFolder);
    }

    public int getInt(String key, int defaultValue) {
        try {
            return this.getConfig().getInt(key, defaultValue);
        }
        catch (ConversionException e) {
            Object o = this.getConfig().getProperty(key);
            if (o instanceof Duration) {
                return (int)((Duration)o).getSeconds();
            }
            throw new IllegalArgumentException("don't know how to convert for config option " + key, e);
        }
    }

    public static enum LoggingType {
        none,
        safe,
        raw;

    }
}

