/*
 * Decompiled with CFR 0.152.
 */
package apoc;

import apoc.ApocConfig;
import apoc.RegisterComponentFactory;
import apoc.custom.CypherProcedures;
import apoc.custom.CypherProceduresHandler;
import apoc.cypher.CypherInitializer;
import apoc.trigger.Trigger;
import apoc.trigger.TriggerHandler;
import apoc.ttl.TTLLifeCycle;
import apoc.util.ApocUrlStreamHandlerFactory;
import apoc.uuid.Uuid;
import apoc.uuid.UuidHandler;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.availability.AvailabilityListener;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.context.ExtensionContext;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;
import org.neo4j.procedure.impl.GlobalProceduresRegistry;
import org.neo4j.scheduler.JobScheduler;

public class ApocExtensionFactory
extends ExtensionFactory<Dependencies> {
    public ApocExtensionFactory() {
        super(ExtensionType.DATABASE, "APOC");
    }

    public Lifecycle newInstance(ExtensionContext context, Dependencies dependencies) {
        GraphDatabaseAPI db = dependencies.graphdatabaseAPI();
        LogService log = dependencies.log();
        return new ApocLifecycle(log, db, dependencies);
    }

    static {
        try {
            URL.setURLStreamHandlerFactory(new ApocUrlStreamHandlerFactory());
        }
        catch (Error e) {
            System.err.println("APOC couln't set a URLStreamHandlerFactory since some other tool already did this (e.g. tomcat). This means you cannot use s3:// or hdfs:// style URLs in APOC. This is caused by a limitation of the JVM which we cannot fix. ");
        }
    }

    public static class ApocLifecycle
    extends LifecycleAdapter {
        private final LogService log;
        private final GraphDatabaseAPI db;
        private final Dependencies dependencies;
        private Log userLog;
        private final Map<String, Lifecycle> services = new HashMap<String, Lifecycle>();
        private CypherProceduresHandler cypherProceduresHandler;

        public ApocLifecycle(LogService log, GraphDatabaseAPI db, Dependencies dependencies) {
            this.log = log;
            this.db = db;
            this.dependencies = dependencies;
            this.userLog = log.getUserLog(ApocExtensionFactory.class);
        }

        public static void withNonSystemDatabase(GraphDatabaseService db, Consumer<Void> consumer) {
            if (!"system".equals(db.databaseName())) {
                consumer.accept(null);
            }
        }

        public void init() throws Exception {
            ApocLifecycle.withNonSystemDatabase((GraphDatabaseService)this.db, aVoid -> {
                this.services.put("ttl", (Lifecycle)new TTLLifeCycle(this.dependencies.scheduler(), this.db, this.dependencies.apocConfig(), this.log.getUserLog(TTLLifeCycle.class)));
                this.services.put("uuid", (Lifecycle)new UuidHandler(this.db, this.dependencies.databaseManagementService(), this.log.getUserLog(Uuid.class), this.dependencies.apocConfig(), this.dependencies.globalProceduresRegistry()));
                this.services.put("trigger", (Lifecycle)new TriggerHandler((GraphDatabaseService)this.db, this.dependencies.databaseManagementService(), this.dependencies.apocConfig(), this.log.getUserLog(Trigger.class), this.dependencies.globalProceduresRegistry()));
                RegisterComponentFactory.RegisterComponentLifecycle registerComponentLifecycle = this.dependencies.registerComponentLifecycle();
                String databaseNamme = this.db.databaseName();
                this.services.values().forEach(lifecycle -> registerComponentLifecycle.addResolver(databaseNamme, lifecycle.getClass(), lifecycle));
                this.cypherProceduresHandler = new CypherProceduresHandler(this.db, this.dependencies.scheduler(), this.dependencies.apocConfig(), this.log.getUserLog(CypherProcedures.class), this.dependencies.globalProceduresRegistry());
                registerComponentLifecycle.addResolver(databaseNamme, CypherProceduresHandler.class, this.cypherProceduresHandler);
            });
        }

        public void start() {
            ApocLifecycle.withNonSystemDatabase((GraphDatabaseService)this.db, aVoid -> {
                this.services.entrySet().stream().forEach(entry -> {
                    try {
                        ((Lifecycle)entry.getValue()).start();
                    }
                    catch (Exception e) {
                        this.userLog.error("failed to start service " + (String)entry.getKey(), (Throwable)e);
                    }
                });
                AvailabilityGuard availabilityGuard = this.dependencies.availabilityGuard();
                availabilityGuard.addListener((AvailabilityListener)this.cypherProceduresHandler);
                availabilityGuard.addListener((AvailabilityListener)new CypherInitializer(this.db, this.log.getUserLog(CypherInitializer.class)));
            });
        }

        public void stop() {
            ApocLifecycle.withNonSystemDatabase((GraphDatabaseService)this.db, aVoid -> this.services.entrySet().stream().forEach(entry -> {
                try {
                    ((Lifecycle)entry.getValue()).stop();
                }
                catch (Exception e) {
                    this.userLog.error("failed to stop service " + (String)entry.getKey(), (Throwable)e);
                }
            }));
        }
    }

    public static interface Dependencies {
        public GraphDatabaseAPI graphdatabaseAPI();

        public JobScheduler scheduler();

        public Procedures procedures();

        public LogService log();

        public AvailabilityGuard availabilityGuard();

        public DatabaseManagementService databaseManagementService();

        public ApocConfig apocConfig();

        public GlobalProceduresRegistry globalProceduresRegistry();

        public RegisterComponentFactory.RegisterComponentLifecycle registerComponentLifecycle();
    }
}

