/*
 * Decompiled with CFR 0.152.
 */
package apoc.convert;

import apoc.convert.ConvertConfig;
import apoc.result.MapResult;
import apoc.util.JsonUtil;
import apoc.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserFunction;

public class Json {
    @Context
    public GraphDatabaseService db;

    @UserFunction(value="apoc.json.path")
    @Description(value="apoc.json.path('{json}','json-path')")
    public Object path(@Name(value="json") String json, @Name(value="path", defaultValue="$") String path) {
        return JsonUtil.parse(json, path, Object.class);
    }

    @UserFunction(value="apoc.convert.toJson")
    @Description(value="apoc.convert.toJson([1,2,3]) or toJson({a:42,b:\"foo\",c:[1,2,3]})")
    public String toJson(@Name(value="value") Object value) {
        try {
            return JsonUtil.OBJECT_MAPPER.writeValueAsString(value);
        }
        catch (IOException e) {
            throw new RuntimeException("Can't convert " + value + " to json", e);
        }
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.convert.setJsonProperty(node,key,complexValue) - sets value serialized to JSON as property with the given name on the node")
    public void setJsonProperty(@Name(value="node") Node node2, @Name(value="key") String key, @Name(value="value") Object value) {
        try {
            node2.setProperty(key, (Object)JsonUtil.OBJECT_MAPPER.writeValueAsString(value));
        }
        catch (IOException e) {
            throw new RuntimeException("Can't convert " + value + " to json", e);
        }
    }

    @UserFunction
    @Description(value="apoc.convert.getJsonProperty(node,key[,'json-path']) - converts serialized JSON in property back to original object")
    public Object getJsonProperty(@Name(value="node") Node node2, @Name(value="key") String key, @Name(value="path", defaultValue="") String path) {
        String value = (String)node2.getProperty(key, null);
        return JsonUtil.parse(value, path, Object.class);
    }

    @UserFunction
    @Description(value="apoc.convert.getJsonPropertyMap(node,key[,'json-path']) - converts serialized JSON in property back to map")
    public Map<String, Object> getJsonPropertyMap(@Name(value="node") Node node2, @Name(value="key") String key, @Name(value="path", defaultValue="") String path) {
        String value = (String)node2.getProperty(key, null);
        return JsonUtil.parse(value, path, Map.class);
    }

    @UserFunction
    @Description(value="apoc.convert.fromJsonMap('{\"a\":42,\"b\":\"foo\",\"c\":[1,2,3]}'[,'json-path'])")
    public Map<String, Object> fromJsonMap(@Name(value="map") String value, @Name(value="path", defaultValue="") String path) {
        return JsonUtil.parse(value, path, Map.class);
    }

    @UserFunction
    @Description(value="apoc.convert.fromJsonList('[1,2,3]'[,'json-path'])")
    public List<Object> fromJsonList(@Name(value="list") String value, @Name(value="path", defaultValue="") String path) {
        return JsonUtil.parse(value, path, List.class);
    }

    @Procedure(value="apoc.convert.toTree")
    @Description(value="apoc.convert.toTree([paths],[lowerCaseRels=true], [config]) creates a stream of nested documents representing the at least one root of these paths")
    public Stream<MapResult> toTree(@Name(value="paths") List<Path> paths, @Name(value="lowerCaseRels", defaultValue="true") boolean lowerCaseRels, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        if (paths.isEmpty()) {
            return Stream.of(new MapResult(Collections.emptyMap()));
        }
        ConvertConfig conf = new ConvertConfig(config);
        Map<String, List<String>> nodes = conf.getNodes();
        Map<String, List<String>> rels = conf.getRels();
        HashMap<Long, Map<String, Object>> maps = new HashMap<Long, Map<String, Object>>(paths.size() * 100);
        for (Path path : paths) {
            Iterator it = path.iterator();
            while (it.hasNext()) {
                List list;
                Optional<Map> optMap;
                String typeName;
                Node n2 = (Node)it.next();
                Map nMap = maps.computeIfAbsent(n2.getId(), id -> this.toMap(n2, nodes));
                if (!it.hasNext()) continue;
                Relationship r = (Relationship)it.next();
                Node m2 = r.getOtherNode(n2);
                String string = typeName = lowerCaseRels ? r.getType().name().toLowerCase() : r.getType().name();
                if (!nMap.containsKey(typeName)) {
                    nMap.put(typeName, new ArrayList(16));
                }
                if ((optMap = (list = (List)nMap.get(typeName)).stream().filter(elem -> elem.get("_id").equals(m2.getId())).findFirst()).isPresent()) continue;
                Map<String, Object> mMap = this.toMap(m2, nodes);
                mMap = this.addRelProperties(mMap, typeName, r, rels);
                maps.put(m2.getId(), mMap);
                list.add((Map)maps.get(m2.getId()));
            }
        }
        return paths.stream().map(Path::startNode).distinct().map(n -> (Map)maps.remove(n.getId())).map(m -> m == null ? Collections.emptyMap() : m).map(MapResult::new);
    }

    @UserFunction(value="apoc.convert.toSortedJsonMap")
    @Description(value="apoc.convert.toSortedJsonMap(node|map, ignoreCase:true) - returns a JSON map with keys sorted alphabetically, with optional case sensitivity")
    public String toSortedJsonMap(@Name(value="value") Object value, @Name(value="ignoreCase", defaultValue="true") boolean ignoreCase) {
        TreeMap sortedMap;
        Map inputMap;
        if (value instanceof Node) {
            inputMap = ((Node)value).getAllProperties();
        } else if (value instanceof Map) {
            inputMap = (Map)value;
        } else {
            throw new IllegalArgumentException("input value must be a Node or a map");
        }
        if (ignoreCase) {
            sortedMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            sortedMap.putAll(inputMap);
        } else {
            sortedMap = new TreeMap(inputMap);
        }
        try {
            return JsonUtil.OBJECT_MAPPER.writeValueAsString(sortedMap);
        }
        catch (IOException e) {
            throw new RuntimeException("Can't convert " + value + " to json", e);
        }
    }

    private Map<String, Object> addRelProperties(Map<String, Object> mMap, String typeName, Relationship r, Map<String, List<String>> relFilters) {
        Map<String, Object> rProps = r.getAllProperties();
        if (rProps.isEmpty()) {
            return mMap;
        }
        String prefix = typeName + ".";
        if (relFilters.containsKey(typeName)) {
            rProps = this.filterProperties(rProps, relFilters.get(typeName));
        }
        rProps.forEach((k, v) -> mMap.put(prefix + k, v));
        return mMap;
    }

    private Map<String, Object> toMap(Node n, Map<String, List<String>> nodeFilters) {
        Map<String, Object> props = n.getAllProperties();
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(props.size() + 2);
        String type = Util.labelString(n);
        result.put("_id", n.getId());
        result.put("_type", type);
        if (nodeFilters.containsKey(type)) {
            props = this.filterProperties(props, nodeFilters.get(type));
        }
        result.putAll(props);
        return result;
    }

    private Map<String, Object> filterProperties(Map<String, Object> props, List<String> filters) {
        boolean isExclude = filters.get(0).startsWith("-");
        return props.entrySet().stream().filter(e -> isExclude ? !filters.contains("-" + (String)e.getKey()) : filters.contains(e.getKey())).collect(Collectors.toMap(k -> (String)k.getKey(), v -> v.getValue()));
    }
}

