/*
 * Decompiled with CFR 0.152.
 */
package apoc.cypher;

import apoc.ApocConfig;
import java.util.ConcurrentModificationException;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.configuration2.Configuration;
import org.neo4j.common.DependencyResolver;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.availability.AvailabilityListener;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;

public class CypherInitializer
implements AvailabilityListener {
    private final GraphDatabaseAPI db;
    private final Log userLog;
    private final GlobalProcedures procs;
    private final DependencyResolver dependencyResolver;
    private boolean finished = false;

    public CypherInitializer(GraphDatabaseAPI db, Log userLog) {
        this.db = db;
        this.userLog = userLog;
        this.dependencyResolver = db.getDependencyResolver();
        this.procs = (GlobalProcedures)this.dependencyResolver.resolveDependency(GlobalProcedures.class);
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void available() {
        new Thread(() -> {
            try {
                this.awaitApocProceduresRegistered();
                Configuration config = ((ApocConfig)((Object)((Object)this.dependencyResolver.resolveDependency(ApocConfig.class)))).getConfig();
                TreeMap initializers = Iterators.stream(config.getKeys("apoc.initializer.cypher")).collect(Collectors.toMap(k -> k, k -> config.getString((String)k), (v1, v2) -> {
                    throw new RuntimeException(String.format("Duplicate key for values %s and %s", v1, v2));
                }, TreeMap::new));
                for (Object initializer : initializers.values()) {
                    String query = initializer.toString();
                    try {
                        this.db.executeTransactionally(query);
                        this.userLog.info("successfully initialized: " + query);
                    }
                    catch (Exception e) {
                        this.userLog.warn("error upon initialization, running: " + query, (Throwable)e);
                    }
                }
            }
            finally {
                this.finished = true;
            }
        }).start();
    }

    private void awaitApocProceduresRegistered() {
        while (!this.areApocProceduresRegistered()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private boolean areApocProceduresRegistered() {
        try {
            return this.procs.getAllProcedures().stream().anyMatch(signature -> signature.name().toString().startsWith("apoc"));
        }
        catch (ConcurrentModificationException e) {
            return false;
        }
    }

    public void unavailable() {
    }
}

