/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.cypher;

import apoc.export.cypher.ExportFileManager;
import apoc.export.cypher.formatter.CypherFormatter;
import apoc.export.cypher.formatter.CypherFormatterUtils;
import apoc.export.util.ExportConfig;
import apoc.export.util.ExportFormat;
import apoc.export.util.Reporter;
import apoc.util.Util;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.helpers.collection.Iterables;

public class MultiStatementCypherSubGraphExporter {
    private final SubGraph graph;
    private final Map<String, Set<String>> uniqueConstraints = new HashMap<String, Set<String>>();
    private Set<String> indexNames = new LinkedHashSet<String>();
    private Set<String> indexedProperties = new LinkedHashSet<String>();
    private Long artificialUniques = 0L;
    private ExportFormat exportFormat;
    private CypherFormatter cypherFormat;
    private ExportConfig exportConfig;
    private GraphDatabaseService db;

    public MultiStatementCypherSubGraphExporter(SubGraph graph, ExportConfig config, GraphDatabaseService db) {
        this.graph = graph;
        this.exportFormat = config.getFormat();
        this.exportConfig = config;
        this.cypherFormat = config.getCypherFormat().getFormatter();
        this.db = db;
        this.gatherUniqueConstraints();
    }

    public void export(ExportConfig config, Reporter reporter, ExportFileManager cypherFileManager) {
        int batchSize = config.getBatchSize();
        ExportConfig.OptimizationType useOptimizations = config.getOptimizationType();
        switch (useOptimizations) {
            case NONE: {
                this.exportNodes(cypherFileManager.getPrintWriter("nodes"), reporter, batchSize);
                this.exportSchema(cypherFileManager.getPrintWriter("schema"));
                this.exportRelationships(cypherFileManager.getPrintWriter("relationships"), reporter, batchSize);
                break;
            }
            default: {
                this.artificialUniques = this.artificialUniques + this.countArtificialUniques(this.graph.getNodes());
                this.exportSchema(cypherFileManager.getPrintWriter("schema"));
                PrintWriter nodeWrite = cypherFileManager.getPrintWriter("nodes");
                this.exportNodesUnwindBatch(nodeWrite, reporter);
                PrintWriter relWrite = cypherFileManager.getPrintWriter("relationships");
                this.exportRelationshipsUnwindBatch(relWrite, reporter);
            }
        }
        this.exportCleanUp(cypherFileManager.getPrintWriter("cleanup"), batchSize);
        reporter.done();
    }

    public void exportOnlySchema(ExportFileManager cypherFileManager) {
        this.exportSchema(cypherFileManager.getPrintWriter("schema"));
    }

    private void exportNodes(PrintWriter out, Reporter reporter, int batchSize) {
        if (this.graph.getNodes().iterator().hasNext()) {
            this.begin(out);
            this.appendNodes(out, batchSize, reporter);
            this.commit(out);
            out.flush();
        }
    }

    private void exportNodesUnwindBatch(PrintWriter out, Reporter reporter) {
        if (this.graph.getNodes().iterator().hasNext()) {
            this.cypherFormat.statementForNodes(this.graph.getNodes(), this.uniqueConstraints, this.exportConfig, out, reporter, this.db);
            out.flush();
        }
    }

    private long appendNodes(PrintWriter out, int batchSize, Reporter reporter) {
        long count = 0L;
        for (Node node2 : this.graph.getNodes()) {
            if (count > 0L && count % (long)batchSize == 0L) {
                this.restart(out);
            }
            ++count;
            this.appendNode(out, node2, reporter);
        }
        return count;
    }

    private void appendNode(PrintWriter out, Node node2, Reporter reporter) {
        this.artificialUniques = this.artificialUniques + this.countArtificialUniques(node2);
        String cypher = this.cypherFormat.statementForNode(node2, this.uniqueConstraints, this.indexedProperties, this.indexNames);
        if (Util.isNotNullOrEmpty(cypher)) {
            out.println(cypher);
            reporter.update(1L, 0L, Iterables.count((Iterable)node2.getPropertyKeys()));
        }
    }

    private void exportRelationships(PrintWriter out, Reporter reporter, int batchSize) {
        if (this.graph.getRelationships().iterator().hasNext()) {
            this.begin(out);
            this.appendRelationships(out, batchSize, reporter);
            this.commit(out);
            out.flush();
        }
    }

    private void exportRelationshipsUnwindBatch(PrintWriter out, Reporter reporter) {
        if (this.graph.getRelationships().iterator().hasNext()) {
            this.cypherFormat.statementForRelationships(this.graph.getRelationships(), this.uniqueConstraints, this.exportConfig, out, reporter, this.db);
            out.flush();
        }
    }

    private long appendRelationships(PrintWriter out, int batchSize, Reporter reporter) {
        long count = 0L;
        for (Relationship rel : this.graph.getRelationships()) {
            if (count > 0L && count % (long)batchSize == 0L) {
                this.restart(out);
            }
            ++count;
            this.appendRelationship(out, rel, reporter);
        }
        return count;
    }

    private void appendRelationship(PrintWriter out, Relationship rel, Reporter reporter) {
        String cypher = this.cypherFormat.statementForRelationship(rel, this.uniqueConstraints, this.indexedProperties);
        if (cypher != null && !"".equals(cypher)) {
            out.println(cypher);
            reporter.update(0L, 1L, Iterables.count((Iterable)rel.getPropertyKeys()));
        }
    }

    private void exportSchema(PrintWriter out) {
        String cypher;
        ArrayList<String> indexesAndConstraints = new ArrayList<String>();
        indexesAndConstraints.addAll(this.exportIndexes());
        indexesAndConstraints.addAll(this.exportConstraints());
        if (indexesAndConstraints.isEmpty() && this.artificialUniques == 0L) {
            return;
        }
        this.begin(out);
        for (String index : indexesAndConstraints) {
            out.println(index);
        }
        if (this.artificialUniques > 0L && (cypher = this.cypherFormat.statementForConstraint("UNIQUE IMPORT LABEL", Collections.singleton("UNIQUE IMPORT ID"))) != null && !"".equals(cypher)) {
            out.println(cypher);
        }
        this.commit(out);
        if (this.graph.getIndexes().iterator().hasNext()) {
            out.print(this.exportFormat.indexAwait(this.exportConfig.getAwaitForIndexes()));
        }
        this.schemaAwait(out);
        out.flush();
    }

    private List<String> exportIndexes() {
        return (List)this.db.executeTransactionally("CALL db.indexes()", Collections.emptyMap(), result -> result.stream().map(map -> {
            List props = (List)map.get("properties");
            List tokenNames = (List)map.get("labelsOrTypes");
            String name = (String)map.get("name");
            boolean inGraph = this.tokensInGraph(tokenNames);
            if (!inGraph) {
                return null;
            }
            if ("UNIQUE".equals(map.get("uniqueness"))) {
                return null;
            }
            if ("FULLTEXT".equals(map.get("type"))) {
                if ("NODE".equals(map.get("entityType"))) {
                    List<Label> labels2 = this.toLabels(tokenNames);
                    return this.cypherFormat.statementForNodeFullTextIndex(name, labels2, props);
                }
                List<RelationshipType> types = this.toRelationshipTypes(tokenNames);
                return this.cypherFormat.statementForRelationshipFullTextIndex(name, types, props);
            }
            String tokenName = (String)tokenNames.get(0);
            return this.cypherFormat.statementForIndex(tokenName, props);
        }).filter(StringUtils::isNotBlank).collect(Collectors.toList()));
    }

    private boolean tokensInGraph(List<String> tokens) {
        return StreamSupport.stream(this.graph.getIndexes().spliterator(), false).anyMatch(indexDefinition -> {
            if (indexDefinition.isRelationshipIndex()) {
                List typeNames = StreamSupport.stream(indexDefinition.getRelationshipTypes().spliterator(), false).map(RelationshipType::name).collect(Collectors.toList());
                return typeNames.containsAll(tokens);
            }
            List labelNames = StreamSupport.stream(indexDefinition.getLabels().spliterator(), false).map(Label::name).collect(Collectors.toList());
            return labelNames.containsAll(tokens);
        });
    }

    private List<Label> toLabels(List<String> tokenNames) {
        return tokenNames.stream().map(Label::label).collect(Collectors.toList());
    }

    private List<RelationshipType> toRelationshipTypes(List<String> tokenNames) {
        return tokenNames.stream().map(RelationshipType::withName).collect(Collectors.toList());
    }

    private List<String> exportConstraints() {
        return StreamSupport.stream(this.graph.getIndexes().spliterator(), false).filter(index -> index.isConstraintIndex()).map(index -> {
            String label = ((Label)Iterables.single((Iterable)index.getLabels())).name();
            Iterable props = index.getPropertyKeys();
            return this.cypherFormat.statementForConstraint(label, props);
        }).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    private void exportCleanUp(PrintWriter out, int batchSize) {
        if (this.artificialUniques > 0L) {
            String cypher;
            while (this.artificialUniques > 0L) {
                cypher = this.cypherFormat.statementForCleanUp(batchSize);
                this.begin(out);
                if (cypher != null && !"".equals(cypher)) {
                    out.println(cypher);
                }
                this.commit(out);
                this.artificialUniques = this.artificialUniques - (long)batchSize;
            }
            this.begin(out);
            cypher = this.cypherFormat.statementForConstraint("UNIQUE IMPORT LABEL", Collections.singleton("UNIQUE IMPORT ID")).replaceAll("^CREATE", "DROP");
            if (cypher != null && !"".equals(cypher)) {
                out.println(cypher);
            }
            this.commit(out);
        }
        out.flush();
    }

    public void begin(PrintWriter out) {
        out.print(this.exportFormat.begin());
    }

    private void schemaAwait(PrintWriter out) {
        out.print(this.exportFormat.schemaAwait());
    }

    private void restart(PrintWriter out) {
        this.commit(out);
        this.begin(out);
    }

    public void commit(PrintWriter out) {
        out.print(this.exportFormat.commit());
    }

    private void gatherUniqueConstraints() {
        for (IndexDefinition indexDefinition : this.graph.getIndexes()) {
            Set label = StreamSupport.stream(indexDefinition.getLabels().spliterator(), false).map(Label::name).collect(Collectors.toSet());
            Set props = StreamSupport.stream(indexDefinition.getPropertyKeys().spliterator(), false).collect(Collectors.toSet());
            this.indexNames.add(indexDefinition.getName());
            this.indexedProperties.addAll(props);
            if (!indexDefinition.isConstraintIndex()) continue;
            this.uniqueConstraints.compute(String.join((CharSequence)":", label), (k, v) -> v == null || v.size() > props.size() ? props : v);
        }
    }

    private long countArtificialUniques(Node node2) {
        long artificialUniques = 0L;
        artificialUniques = this.getArtificialUniques(node2, artificialUniques);
        return artificialUniques;
    }

    private long countArtificialUniques(Iterable<Node> n) {
        long artificialUniques = 0L;
        for (Node node2 : n) {
            artificialUniques = this.getArtificialUniques(node2, artificialUniques);
        }
        return artificialUniques;
    }

    private long getArtificialUniques(Node node2, long artificialUniques) {
        Iterator labels2 = node2.getLabels().iterator();
        boolean uniqueFound = false;
        while (labels2.hasNext()) {
            Label next = (Label)labels2.next();
            String labelName = next.name();
            uniqueFound = CypherFormatterUtils.isUniqueLabelFound(node2, this.uniqueConstraints, labelName);
        }
        if (!uniqueFound) {
            ++artificialUniques;
        }
        return artificialUniques;
    }
}

