/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.cypher.formatter;

import apoc.export.cypher.formatter.CypherFormat;
import apoc.export.cypher.formatter.CypherFormatter;
import apoc.export.cypher.formatter.CypherFormatterUtils;
import apoc.export.util.ExportConfig;
import apoc.export.util.ExportFormat;
import apoc.export.util.Reporter;
import apoc.util.Util;
import java.io.PrintWriter;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;

abstract class AbstractCypherFormatter
implements CypherFormatter {
    private static final String STATEMENT_CONSTRAINTS = "CREATE CONSTRAINT ON (node:%s) ASSERT (%s) %s;";
    private static final String STATEMENT_NODE_FULLTEXT_IDX = "CALL db.index.fulltext.createNodeIndex('%s',[%s],[%s]);";
    private static final String STATEMENT_REL_FULLTEXT_IDX = "CALL db.index.fulltext.createRelationshipIndex('%s',[%s],[%s]);";
    public static final String PROPERTY_QUOTING_FORMAT = "'%s'";

    AbstractCypherFormatter() {
    }

    @Override
    public String statementForCleanUp(int batchSize) {
        return "MATCH (n:" + CypherFormatterUtils.Q_UNIQUE_ID_LABEL + ")  WITH n LIMIT " + batchSize + " REMOVE n:" + CypherFormatterUtils.Q_UNIQUE_ID_LABEL + " REMOVE n." + CypherFormatterUtils.quote("UNIQUE IMPORT ID") + ";";
    }

    @Override
    public String statementForIndex(String label, Iterable<String> keys) {
        return "CREATE INDEX ON :" + Util.quote(label) + "(" + CypherFormatterUtils.quote(keys) + ");";
    }

    @Override
    public String statementForNodeFullTextIndex(String name, Iterable<Label> labels2, Iterable<String> keys) {
        String label = StreamSupport.stream(labels2.spliterator(), false).map(Label::name).map(Util::quote).map(s -> String.format(PROPERTY_QUOTING_FORMAT, s)).collect(Collectors.joining(","));
        String key = StreamSupport.stream(keys.spliterator(), false).map(Util::quote).map(s -> String.format(PROPERTY_QUOTING_FORMAT, s)).collect(Collectors.joining(","));
        return String.format(STATEMENT_NODE_FULLTEXT_IDX, name, label, key);
    }

    @Override
    public String statementForRelationshipFullTextIndex(String name, Iterable<RelationshipType> types, Iterable<String> keys) {
        String type = StreamSupport.stream(types.spliterator(), false).map(RelationshipType::name).map(Util::quote).map(s -> String.format(PROPERTY_QUOTING_FORMAT, s)).collect(Collectors.joining(","));
        String key = StreamSupport.stream(keys.spliterator(), false).map(Util::quote).map(s -> String.format(PROPERTY_QUOTING_FORMAT, s)).collect(Collectors.joining(","));
        return String.format(STATEMENT_REL_FULLTEXT_IDX, name, type, key);
    }

    @Override
    public String statementForConstraint(String label, Iterable<String> keys) {
        String keysString = StreamSupport.stream(keys.spliterator(), false).map(key -> "node." + CypherFormatterUtils.quote(key)).collect(Collectors.joining(", "));
        return String.format(STATEMENT_CONSTRAINTS, Util.quote(label), keysString, Iterables.count(keys) > 1L ? "IS NODE KEY" : "IS UNIQUE");
    }

    protected String mergeStatementForNode(CypherFormat cypherFormat, Node node2, Map<String, Set<String>> uniqueConstraints, Set<String> indexedProperties, Set<String> indexNames) {
        StringBuilder result = new StringBuilder(1000);
        result.append("MERGE ");
        result.append(CypherFormatterUtils.formatNodeLookup("n", node2, uniqueConstraints, indexNames));
        if (node2.getPropertyKeys().iterator().hasNext()) {
            String notUniqueProperties = CypherFormatterUtils.formatNotUniqueProperties("n", node2, uniqueConstraints, indexedProperties, false);
            String notUniqueLabels = CypherFormatterUtils.formatNotUniqueLabels("n", node2, uniqueConstraints);
            if (!"".equals(notUniqueProperties) || !"".equals(notUniqueLabels)) {
                result.append(cypherFormat.equals((Object)CypherFormat.ADD_STRUCTURE) ? " ON CREATE SET " : " SET ");
                result.append(notUniqueProperties);
                result.append(!"".equals(notUniqueProperties) && !"".equals(notUniqueLabels) ? ", " : "");
                result.append(notUniqueLabels);
            }
        }
        result.append(";");
        return result.toString();
    }

    public String mergeStatementForRelationship(CypherFormat cypherFormat, Relationship relationship, Map<String, Set<String>> uniqueConstraints, Set<String> indexedProperties) {
        StringBuilder result = new StringBuilder(1000);
        result.append("MATCH ");
        result.append(CypherFormatterUtils.formatNodeLookup("n1", relationship.getStartNode(), uniqueConstraints, indexedProperties));
        result.append(", ");
        result.append(CypherFormatterUtils.formatNodeLookup("n2", relationship.getEndNode(), uniqueConstraints, indexedProperties));
        result.append(" MERGE (n1)-[r:" + CypherFormatterUtils.quote(relationship.getType().name()) + "]->(n2)");
        if (relationship.getPropertyKeys().iterator().hasNext()) {
            result.append(cypherFormat.equals((Object)CypherFormat.UPDATE_STRUCTURE) ? " ON CREATE SET " : " SET ");
            result.append(CypherFormatterUtils.formatRelationshipProperties("r", relationship, false));
        }
        result.append(";");
        return result.toString();
    }

    public void buildStatementForNodes(String nodeClause, String setClause, Iterable<Node> nodes, Map<String, Set<String>> uniqueConstraints, ExportConfig exportConfig, PrintWriter out, Reporter reporter, GraphDatabaseService db) {
        AtomicInteger nodeCount = new AtomicInteger(0);
        Function<Node, Map.Entry> keyMapper = node2 -> {
            try (Transaction tx = db.beginTx();){
                node2 = tx.getNodeById(node2.getId());
                Set<String> idProperties = CypherFormatterUtils.getNodeIdProperties(node2, uniqueConstraints).keySet();
                Set<String> labels2 = this.getLabels((Node)node2);
                tx.commit();
                AbstractMap.SimpleImmutableEntry<Set<String>, Set<String>> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<Set<String>, Set<String>>(labels2, idProperties);
                return simpleImmutableEntry;
            }
        };
        Map groupedData = StreamSupport.stream(nodes.spliterator(), true).collect(Collectors.groupingByConcurrent(keyMapper));
        AtomicInteger propertiesCount = new AtomicInteger(0);
        AtomicInteger batchCount = new AtomicInteger(0);
        groupedData.forEach((key, nodeList) -> {
            AtomicInteger unwindCount = new AtomicInteger(0);
            int nodeListSize = nodeList.size();
            Node last = (Node)nodeList.get(nodeListSize - 1);
            nodeCount.addAndGet(nodeListSize);
            for (int index = 0; index < nodeList.size(); ++index) {
                Node node2 = (Node)nodeList.get(index);
                this.writeBatchBegin(exportConfig, out, batchCount);
                this.writeUnwindStart(exportConfig, out, unwindCount);
                batchCount.incrementAndGet();
                unwindCount.incrementAndGet();
                Map props = node2.getAllProperties();
                out.append("{");
                Map<String, Object> idMap = CypherFormatterUtils.getNodeIdProperties(node2, uniqueConstraints);
                this.writeNodeIds(out, idMap);
                out.append(", ");
                out.append("properties:");
                propertiesCount.addAndGet(props.size());
                props.keySet().removeAll(idMap.keySet());
                this.writeProperties(out, props);
                out.append("}");
                if (last.equals(node2) || this.isBatchMatch(exportConfig, batchCount) || this.isUnwindBatchMatch(exportConfig, unwindCount)) {
                    this.closeUnwindNodes(nodeClause, setClause, uniqueConstraints, exportConfig, out, (Map.Entry<Set<String>, Set<String>>)key, last);
                    this.writeBatchEnd(exportConfig, out, batchCount);
                    unwindCount.set(0);
                    continue;
                }
                out.append(", ");
            }
        });
        this.addCommitToEnd(exportConfig, out, batchCount);
        reporter.update(nodeCount.get(), 0L, propertiesCount.longValue());
    }

    private void closeUnwindNodes(String nodeClause, String setClause, Map<String, Set<String>> uniqueConstraints, ExportConfig exportConfig, PrintWriter out, Map.Entry<Set<String>, Set<String>> key, Node last) {
        this.writeUnwindEnd(exportConfig, out);
        out.append("\n");
        out.append(nodeClause);
        String label = this.getUniqueConstrainedLabel(last, uniqueConstraints);
        out.append("(n:");
        out.append(Util.quote(label));
        out.append("{");
        this.writeSetProperties(out, key.getValue());
        out.append("}) ");
        out.append(setClause);
        out.append("n += row.properties");
        String addLabels = key.getKey().stream().filter(l -> !l.equals(label)).map(Util::quote).collect(Collectors.joining(":"));
        if (!addLabels.isEmpty()) {
            out.append(" SET n:");
            out.append(addLabels);
        }
        out.append(";");
        out.append("\n");
    }

    private void writeSetProperties(PrintWriter out, Set<String> value) {
        this.writeSetProperties(out, value, null);
    }

    private void writeSetProperties(PrintWriter out, Set<String> value, String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        int size = value.size();
        for (String s : value) {
            out.append(Util.quote(s) + ": row." + prefix + this.formatNodeId(s));
            if (--size <= 0) continue;
            out.append(", ");
        }
    }

    private boolean isBatchMatch(ExportConfig exportConfig, AtomicInteger batchCount) {
        return batchCount.get() % exportConfig.getBatchSize() == 0;
    }

    public void buildStatementForRelationships(String relationshipClause, String setClause, Iterable<Relationship> relationship, Map<String, Set<String>> uniqueConstraints, ExportConfig exportConfig, PrintWriter out, Reporter reporter, GraphDatabaseService db) {
        AtomicInteger relCount = new AtomicInteger(0);
        Function<Relationship, Map> keyMapper = rel -> {
            try (Transaction tx = db.beginTx();){
                rel = tx.getRelationshipById(rel.getId());
                Node start = rel.getStartNode();
                Set<String> startLabels = this.getLabels(start);
                Node end = rel.getEndNode();
                Set<String> endLabels = this.getLabels(end);
                String type = rel.getType().name();
                Map<String, Object> key = Util.map("type", type, "start", new AbstractMap.SimpleImmutableEntry<Set<String>, Set<String>>(startLabels, CypherFormatterUtils.getNodeIdProperties(start, uniqueConstraints).keySet()), "end", new AbstractMap.SimpleImmutableEntry<Set<String>, Set<String>>(endLabels, CypherFormatterUtils.getNodeIdProperties(end, uniqueConstraints).keySet()));
                tx.commit();
                Map<String, Object> map = key;
                return map;
            }
        };
        Map groupedData = StreamSupport.stream(relationship.spliterator(), true).collect(Collectors.groupingByConcurrent(keyMapper));
        AtomicInteger propertiesCount = new AtomicInteger(0);
        AtomicInteger batchCount = new AtomicInteger(0);
        String start = "start";
        String end = "end";
        groupedData.forEach((path, relationshipList) -> {
            AtomicInteger unwindCount = new AtomicInteger(0);
            int relSize = relationshipList.size();
            relCount.addAndGet(relSize);
            Relationship last = (Relationship)relationshipList.get(relSize - 1);
            for (int index = 0; index < relationshipList.size(); ++index) {
                Relationship rel = (Relationship)relationshipList.get(index);
                this.writeBatchBegin(exportConfig, out, batchCount);
                this.writeUnwindStart(exportConfig, out, unwindCount);
                batchCount.incrementAndGet();
                unwindCount.incrementAndGet();
                Map props = rel.getAllProperties();
                out.append("{");
                Node startNode = rel.getStartNode();
                this.writeRelationshipNodeIds(uniqueConstraints, out, start, startNode);
                out.append(", ");
                Node endNode = rel.getEndNode();
                this.writeRelationshipNodeIds(uniqueConstraints, out, end, endNode);
                out.append(", ");
                out.append("properties:");
                this.writeProperties(out, props);
                propertiesCount.addAndGet(props.size());
                out.append("}");
                if (last.equals(rel) || this.isBatchMatch(exportConfig, batchCount) || this.isUnwindBatchMatch(exportConfig, unwindCount)) {
                    this.closeUnwindRelationships(relationshipClause, setClause, uniqueConstraints, exportConfig, out, start, end, (Map<String, Object>)path, last);
                    this.writeBatchEnd(exportConfig, out, batchCount);
                    unwindCount.set(0);
                    continue;
                }
                out.append(", ");
            }
        });
        this.addCommitToEnd(exportConfig, out, batchCount);
        reporter.update(0L, relCount.get(), propertiesCount.longValue());
    }

    private void closeUnwindRelationships(String relationshipClause, String setClause, Map<String, Set<String>> uniqueConstraints, ExportConfig exportConfig, PrintWriter out, String start, String end, Map<String, Object> path, Relationship last) {
        this.writeUnwindEnd(exportConfig, out);
        this.writeRelationshipMatchAsciiNode(last.getStartNode(), out, start, path, uniqueConstraints);
        this.writeRelationshipMatchAsciiNode(last.getEndNode(), out, end, path, uniqueConstraints);
        out.append("\n");
        out.append(relationshipClause);
        out.append("(start)-[r:" + Util.quote(path.get("type").toString()) + "]->(end) ");
        out.append(setClause);
        out.append("r += row.properties;");
        out.append("\n");
    }

    private boolean isUnwindBatchMatch(ExportConfig exportConfig, AtomicInteger batchCount) {
        return batchCount.get() % exportConfig.getUnwindBatchSize() == 0;
    }

    private void writeBatchEnd(ExportConfig exportConfig, PrintWriter out, AtomicInteger batchCount) {
        if (this.isBatchMatch(exportConfig, batchCount)) {
            out.append(exportConfig.getFormat().commit());
        }
    }

    public void writeProperties(PrintWriter out, Map<String, Object> props) {
        out.append("{");
        if (!props.isEmpty()) {
            int size = props.size();
            for (Map.Entry<String, Object> es : props.entrySet()) {
                --size;
                out.append(Util.quote(es.getKey()));
                out.append(":");
                out.append(CypherFormatterUtils.toString(es.getValue()));
                if (size <= 0) continue;
                out.append(", ");
            }
        }
        out.append("}");
    }

    private String formatNodeId(String key) {
        if ("UNIQUE IMPORT ID".equals(key)) {
            key = "_id";
        }
        return Util.quote(key);
    }

    private void addCommitToEnd(ExportConfig exportConfig, PrintWriter out, AtomicInteger batchCount) {
        if (batchCount.get() % exportConfig.getBatchSize() != 0) {
            out.append(exportConfig.getFormat().commit());
        }
    }

    private void writeBatchBegin(ExportConfig exportConfig, PrintWriter out, AtomicInteger batchCount) {
        if (this.isBatchMatch(exportConfig, batchCount)) {
            out.append(exportConfig.getFormat().begin());
        }
    }

    private void writeUnwindStart(ExportConfig exportConfig, PrintWriter out, AtomicInteger batchCount) {
        if (this.isUnwindBatchMatch(exportConfig, batchCount)) {
            String start = exportConfig.getFormat() == ExportFormat.CYPHER_SHELL && exportConfig.getOptimizationType() == ExportConfig.OptimizationType.UNWIND_BATCH_PARAMS ? ":param rows => [" : "UNWIND [";
            out.append(start);
        }
    }

    private void writeUnwindEnd(ExportConfig exportConfig, PrintWriter out) {
        out.append("]");
        if (exportConfig.getFormat() == ExportFormat.CYPHER_SHELL && exportConfig.getOptimizationType() == ExportConfig.OptimizationType.UNWIND_BATCH_PARAMS) {
            out.append("\n");
            out.append("UNWIND $rows");
        }
        out.append(" AS row");
    }

    private String getUniqueConstrainedLabel(Node node2, Map<String, Set<String>> uniqueConstraints) {
        return uniqueConstraints.entrySet().stream().filter(e -> node2.hasLabel(Label.label((String)((String)e.getKey()))) && ((Set)e.getValue()).stream().anyMatch(k -> node2.hasProperty(k))).map(e -> (String)e.getKey()).findFirst().orElse("UNIQUE IMPORT LABEL");
    }

    private Set<String> getLabels(Node node2) {
        Set<String> labels2 = StreamSupport.stream(node2.getLabels().spliterator(), false).map(Label::name).collect(Collectors.toSet());
        if (labels2.isEmpty()) {
            labels2.add("UNIQUE IMPORT LABEL");
        }
        return labels2;
    }

    private void writeRelationshipMatchAsciiNode(Node node2, PrintWriter out, String key, Map<String, Object> path, Map<String, Set<String>> uniqueConstraints) {
        Map.Entry entry = (Map.Entry)path.get(key);
        out.append("\n");
        out.append("MATCH ");
        out.append("(");
        out.append(key);
        out.append(":");
        out.append(Util.quote(this.getUniqueConstrainedLabel(node2, uniqueConstraints)));
        out.append("{");
        this.writeSetProperties(out, (Set)entry.getValue(), key + ".");
        out.append("})");
    }

    private void writeRelationshipNodeIds(Map<String, Set<String>> uniqueConstraints, PrintWriter out, String key, Node node2) {
        Map<String, Object> properties;
        out.append(key + ": ");
        Set<String> props = uniqueConstraints.get(this.getUniqueConstrainedLabel(node2, uniqueConstraints));
        if (props != null && !props.isEmpty()) {
            String[] propsArray = props.toArray(new String[props.size()]);
            properties = node2.getProperties(propsArray);
        } else {
            properties = Util.map("UNIQUE IMPORT ID", node2.getId());
        }
        out.append("{");
        this.writeNodeIds(out, properties);
        out.append("}");
    }

    private void writeNodeIds(PrintWriter out, Map<String, Object> properties) {
        int size = properties.size();
        for (Map.Entry<String, Object> es : properties.entrySet()) {
            --size;
            out.append(this.formatNodeId(es.getKey()));
            out.append(":");
            out.append(CypherFormatterUtils.toString(es.getValue()));
            if (size <= 0) continue;
            out.append(", ");
        }
    }
}

