/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.graphml;

import apoc.export.util.ExportConfig;
import apoc.export.util.ExportFormat;
import apoc.export.util.FormatUtils;
import apoc.export.util.MetaInformation;
import apoc.export.util.Reporter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;

public class XmlGraphMLWriter {
    public void write(SubGraph graph, Writer writer, Reporter reporter, ExportConfig config) throws Exception {
        int props;
        XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
        XMLStreamWriter xmlWriter = xmlOutputFactory.createXMLStreamWriter(writer);
        this.writeHeader(xmlWriter);
        this.writeKey(xmlWriter, graph, config);
        this.writeGraph(xmlWriter);
        for (Node node2 : graph.getNodes()) {
            props = this.writeNode(xmlWriter, node2, config);
            reporter.update(1L, 0L, props);
        }
        for (Relationship rel : graph.getRelationships()) {
            props = this.writeRelationship(xmlWriter, rel, config);
            reporter.update(0L, 1L, props);
        }
        this.writeFooter(xmlWriter);
        reporter.done();
    }

    private void writeKey(XMLStreamWriter writer, SubGraph ops, ExportConfig config) throws Exception {
        HashMap<String, Class> keyTypes = new HashMap<String, Class>();
        for (Node node2 : ops.getNodes()) {
            if (node2.getLabels().iterator().hasNext()) {
                keyTypes.put("label", String.class);
            }
            MetaInformation.updateKeyTypes(keyTypes, (Entity)node2);
        }
        boolean useTypes = config.useTypes();
        ExportFormat format = config.getFormat();
        if (format == ExportFormat.GEPHI) {
            keyTypes.put("TYPE", String.class);
        }
        this.writeKey(writer, keyTypes, "node", useTypes);
        keyTypes.clear();
        for (Relationship rel : ops.getRelationships()) {
            keyTypes.put("label", String.class);
            MetaInformation.updateKeyTypes(keyTypes, (Entity)rel);
        }
        if (format == ExportFormat.GEPHI) {
            keyTypes.put("TYPE", String.class);
        }
        this.writeKey(writer, keyTypes, "edge", useTypes);
    }

    private void writeKey(XMLStreamWriter writer, Map<String, Class> keyTypes, String forType, boolean useTypes) throws XMLStreamException {
        for (Map.Entry<String, Class> entry : keyTypes.entrySet()) {
            Class typeClass = entry.getValue();
            String type = MetaInformation.typeFor(typeClass, MetaInformation.GRAPHML_ALLOWED);
            if (type == null) continue;
            writer.writeEmptyElement("key");
            writer.writeAttribute("id", entry.getKey());
            writer.writeAttribute("for", forType);
            writer.writeAttribute("attr.name", entry.getKey());
            if (useTypes) {
                if (typeClass.isArray()) {
                    writer.writeAttribute("attr.type", "string");
                    writer.writeAttribute("attr.list", type);
                } else {
                    writer.writeAttribute("attr.type", type);
                }
            }
            this.newLine(writer);
        }
    }

    private int writeNode(XMLStreamWriter writer, Node node2, ExportConfig config) throws XMLStreamException {
        writer.writeStartElement("node");
        writer.writeAttribute("id", this.id(node2));
        this.writeLabels(writer, node2);
        this.writeLabelsAsData(writer, node2, config);
        int props = this.writeProps(writer, (Entity)node2);
        this.endElement(writer);
        return props;
    }

    private String id(Node node2) {
        return "n" + node2.getId();
    }

    private void writeLabels(XMLStreamWriter writer, Node node2) throws XMLStreamException {
        String labelsString = MetaInformation.getLabelsString(node2);
        if (!labelsString.isEmpty()) {
            writer.writeAttribute("labels", labelsString);
        }
    }

    private void writeLabelsAsData(XMLStreamWriter writer, Node node2, ExportConfig config) throws XMLStreamException {
        String labelsString = MetaInformation.getLabelsString(node2);
        if (labelsString.isEmpty()) {
            return;
        }
        String delimiter = ":";
        if (config.getFormat() == ExportFormat.GEPHI) {
            this.writeData(writer, "TYPE", delimiter + FormatUtils.joinLabels(node2, delimiter));
            this.writeData(writer, "label", MetaInformation.getLabelsStringGephi(config, node2));
        } else {
            this.writeData(writer, "labels", labelsString);
        }
    }

    private int writeRelationship(XMLStreamWriter writer, Relationship rel, ExportConfig config) throws XMLStreamException {
        writer.writeStartElement("edge");
        writer.writeAttribute("id", this.id(rel));
        writer.writeAttribute("source", this.id(rel.getStartNode()));
        writer.writeAttribute("target", this.id(rel.getEndNode()));
        writer.writeAttribute("label", rel.getType().name());
        this.writeData(writer, "label", rel.getType().name());
        if (config.getFormat() == ExportFormat.GEPHI) {
            this.writeData(writer, "TYPE", rel.getType().name());
        }
        int props = this.writeProps(writer, (Entity)rel);
        this.endElement(writer);
        return props;
    }

    private String id(Relationship rel) {
        return "e" + rel.getId();
    }

    private void endElement(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeEndElement();
        this.newLine(writer);
    }

    private int writeProps(XMLStreamWriter writer, Entity node2) throws XMLStreamException {
        int count = 0;
        for (String prop : node2.getPropertyKeys()) {
            Object value = node2.getProperty(prop);
            this.writeData(writer, prop, value);
            ++count;
        }
        return count;
    }

    private void writeData(XMLStreamWriter writer, String prop, Object value) throws XMLStreamException {
        writer.writeStartElement("data");
        writer.writeAttribute("key", prop);
        if (value != null) {
            writer.writeCharacters(FormatUtils.toString(value));
        }
        writer.writeEndElement();
    }

    private void writeFooter(XMLStreamWriter writer) throws XMLStreamException {
        this.endElement(writer);
        this.endElement(writer);
        writer.writeEndDocument();
    }

    private void writeHeader(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartDocument("UTF-8", "1.0");
        this.newLine(writer);
        writer.writeStartElement("graphml");
        writer.writeNamespace("xmlns", "http://graphml.graphdrawing.org/xmlns");
        writer.writeAttribute("xmlns", "http://graphml.graphdrawing.org/xmlns", "xsi", "http://www.w3.org/2001/XMLSchema-instance");
        writer.writeAttribute("xsi", "", "schemaLocation", "http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd");
        this.newLine(writer);
    }

    private void writeGraph(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("graph");
        writer.writeAttribute("id", "G");
        writer.writeAttribute("edgedefault", "directed");
        this.newLine(writer);
    }

    private void newLine(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeCharacters(System.getProperty("line.separator"));
    }
}

