/*
 * Decompiled with CFR 0.152.
 */
package apoc.index;

import apoc.index.QueuePoisoningCollector;
import apoc.result.ListResult;
import apoc.util.QueueBasedSpliterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.TerminationGuard;
import org.neo4j.values.storable.Value;

public class SchemaIndex {
    private static final PropertyValueCount POISON = new PropertyValueCount("poison", "poison", "poison", -1L);
    @Context
    public GraphDatabaseAPI db;
    @Context
    public Transaction tx;
    @Context
    public TerminationGuard terminationGuard;

    @Procedure(value="apoc.schema.properties.distinct")
    @Description(value="apoc.schema.properties.distinct(label, key) - quickly returns all distinct values for a given key")
    public Stream<ListResult> distinct(@Name(value="label") String label, @Name(value="key") String key) {
        List<Object> values = this.distinctCount(label, key).map(propertyValueCount -> propertyValueCount.value).collect(Collectors.toList());
        return Stream.of(new ListResult(values));
    }

    @Procedure(value="apoc.schema.properties.distinctCount")
    @Description(value="apoc.schema.properties.distinctCount([label], [key]) YIELD label, key, value, count - quickly returns all distinct values and counts for a given key")
    public Stream<PropertyValueCount> distinctCount(@Name(value="label", defaultValue="") String labelName, @Name(value="key", defaultValue="") String keyName) {
        LinkedBlockingDeque queue = new LinkedBlockingDeque(100);
        Iterable indexDefinitions = labelName.isEmpty() ? this.tx.schema().getIndexes() : this.tx.schema().getIndexes(Label.label((String)labelName));
        new Thread(() -> StreamSupport.stream(indexDefinitions.spliterator(), true).filter(indexDefinition -> this.isIndexCoveringProperty((IndexDefinition)indexDefinition, keyName)).map(indexDefinition -> this.scanIndexDefinitionForKeys((IndexDefinition)indexDefinition, keyName, queue)).collect(new QueuePoisoningCollector<PropertyValueCount>(queue, POISON))).start();
        return StreamSupport.stream(new QueueBasedSpliterator<PropertyValueCount>(queue, POISON, this.terminationGuard, Integer.MAX_VALUE), false);
    }

    private Object scanIndexDefinitionForKeys(IndexDefinition indexDefinition, @Name(value="key", defaultValue="") String keyName, BlockingQueue<PropertyValueCount> queue) {
        try (Transaction threadTx = this.db.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)threadTx).kernelTransaction();
            List<String> keys = keyName.isEmpty() ? indexDefinition.getPropertyKeys() : Collections.singletonList(keyName);
            for (String key : keys) {
                KernelStatement ignored = (KernelStatement)ktx.acquireStatement();
                try {
                    SchemaRead schemaRead = ktx.schemaRead();
                    TokenRead tokenRead = ktx.tokenRead();
                    Read read = ktx.dataRead();
                    CursorFactory cursors = ktx.cursors();
                    int[] propertyKeyIds = StreamSupport.stream(indexDefinition.getPropertyKeys().spliterator(), false).mapToInt(name -> tokenRead.propertyKey(name)).toArray();
                    String label = ((Label)Iterables.single((Iterable)indexDefinition.getLabels())).name();
                    LabelSchemaDescriptor schema = SchemaDescriptor.forLabel((int)tokenRead.nodeLabel(label), (int[])propertyKeyIds);
                    IndexDescriptor indexDescriptor = (IndexDescriptor)Iterators.single((Iterator)schemaRead.index((SchemaDescriptor)schema));
                    this.scanIndex(queue, indexDefinition, key, read, cursors, indexDescriptor);
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                }
            }
            threadTx.commit();
            Iterator iterator = null;
            return iterator;
        }
    }

    private void scanIndex(BlockingQueue<PropertyValueCount> queue, IndexDefinition indexDefinition, String key, Read read, CursorFactory cursors, IndexDescriptor indexDescriptor) {
        try (NodeValueIndexCursor cursor = cursors.allocateNodeValueIndexCursor();){
            IndexReadSession indexSession = read.indexReadSession(indexDescriptor);
            read.nodeIndexScan(indexSession, cursor, IndexOrder.NONE, true);
            Value previousValue = null;
            long count = 0L;
            while (cursor.next()) {
                for (int i = 0; i < cursor.numberOfProperties(); ++i) {
                    Value v = cursor.propertyValue(i);
                    if (Objects.equals(v, previousValue)) {
                        ++count;
                        continue;
                    }
                    if (previousValue != null) {
                        this.putIntoQueue(queue, indexDefinition, key, previousValue, count);
                    }
                    previousValue = v;
                    count = 1L;
                }
            }
            this.putIntoQueue(queue, indexDefinition, key, previousValue, count);
        }
        catch (KernelException e) {
            throw new RuntimeException(e);
        }
    }

    private void putIntoQueue(BlockingQueue<PropertyValueCount> queue, IndexDefinition indexDefinition, String key, Value value, long count) {
        try {
            String label = ((Label)Iterables.single((Iterable)indexDefinition.getLabels())).name();
            queue.put(new PropertyValueCount(label, key, value.asObject(), count));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isIndexCoveringProperty(IndexDefinition indexDefinition, String properttyKeyName) {
        try (Transaction threadTx = this.db.beginTx();){
            threadTx.commit();
            boolean bl = properttyKeyName.isEmpty() || this.contains(indexDefinition.getPropertyKeys(), properttyKeyName);
            return bl;
        }
    }

    private boolean contains(Iterable<String> list, String search) {
        for (String element : list) {
            if (!element.equals(search)) continue;
            return true;
        }
        return false;
    }

    public static class PropertyValueCount {
        public String label;
        public String key;
        public Object value;
        public long count;

        public PropertyValueCount(String label, String key, Object value, long count) {
            this.label = label;
            this.key = key;
            this.value = value;
            this.count = count;
        }

        public String toString() {
            return "PropertyValueCount{label='" + this.label + "', key='" + this.key + "', value='" + this.value + "', count=" + this.count + "}";
        }
    }
}

