/*
 * Decompiled with CFR 0.152.
 */
package apoc.load;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.ArrayUtils;

class SkipWhitespaceInputStream
extends FilterInputStream {
    boolean onlyWhitespaceSoFar = true;
    final byte[] blacklist = new byte[]{10, 13, 9, 32};

    public SkipWhitespaceInputStream(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public int read() throws IOException {
        int read;
        while (this.shouldSkipByte((byte)(read = super.read()))) {
        }
        return read;
    }

    private boolean shouldSkipByte(byte b) {
        boolean shouldSkip = false;
        if (ArrayUtils.contains(this.blacklist, b)) {
            if (b == 10) {
                this.onlyWhitespaceSoFar = true;
                shouldSkip = true;
            }
            if (b == 13) {
                shouldSkip = true;
            } else if (this.onlyWhitespaceSoFar) {
                shouldSkip = true;
            }
        } else {
            this.onlyWhitespaceSoFar = false;
        }
        return shouldSkip;
    }

    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        byte[] localBuffer = new byte[len];
        int bytesRead = super.read(localBuffer, 0, len);
        if (bytesRead == -1) {
            return -1;
        }
        int bufferIndex = offset;
        for (int index = 0; index < bytesRead; ++index) {
            byte current = localBuffer[index];
            if (this.shouldSkipByte(current)) continue;
            buffer[bufferIndex++] = current;
        }
        return bufferIndex - offset;
    }
}

