/*
 * Decompiled with CFR 0.152.
 */
package apoc.map;

import apoc.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;

public class Maps {
    @Context
    public Transaction tx;

    @UserFunction
    @Description(value="apoc.map.groupBy([maps/nodes/relationships],'key') yield value - creates a map of the list keyed by the given property, with single values")
    public Map<String, Object> groupBy(@Name(value="values") List<Object> values, @Name(value="key") String key) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(values.size());
        for (Object value : values) {
            Object id = this.getKey(key, value);
            if (id == null) continue;
            result.put(id.toString(), value);
        }
        return result;
    }

    @UserFunction
    @Description(value="apoc.map.groupByMulti([maps/nodes/relationships],'key') yield value - creates a map of the list keyed by the given property, with list values")
    public Map<String, List<Object>> groupByMulti(@Name(value="values") List<Object> values, @Name(value="key") String key) {
        LinkedHashMap<String, List<Object>> result = new LinkedHashMap<String, List<Object>>(values.size());
        for (Object value : values) {
            Object id = this.getKey(key, value);
            if (id == null) continue;
            result.compute(id.toString(), (k, list) -> {
                if (list == null) {
                    list = new ArrayList<Object>();
                }
                list.add(value);
                return list;
            });
        }
        return result;
    }

    public Object getKey(@Name(value="key") String key, Object value) {
        Object id = null;
        if (value instanceof Map) {
            id = ((Map)value).get(key);
        }
        if (value instanceof Entity) {
            id = ((Entity)value).getProperty(key, null);
        }
        return id;
    }

    @UserFunction
    @Description(value="apoc.map.fromNodes(label, property)")
    public Map<String, Node> fromNodes(@Name(value="label") String label, @Name(value="property") String property) {
        LinkedHashMap<String, Node> result = new LinkedHashMap<String, Node>(10000);
        try (ResourceIterator nodes = this.tx.findNodes(Label.label((String)label));){
            while (nodes.hasNext()) {
                Node node2 = (Node)nodes.next();
                Object key = node2.getProperty(property, null);
                if (key == null) continue;
                result.put(key.toString(), node2);
            }
        }
        return result;
    }

    @UserFunction
    @Description(value="apoc.map.fromPairs([[key,value],[key2,value2],...])")
    public Map<String, Object> fromPairs(@Name(value="pairs") List<List<Object>> pairs) {
        return Util.mapFromPairs(pairs);
    }

    @UserFunction
    @Description(value="apoc.map.fromLists([keys],[values])")
    public Map<String, Object> fromLists(@Name(value="keys") List<String> keys, @Name(value="values") List<Object> values) {
        return Util.mapFromLists(keys, values);
    }

    @UserFunction
    @Description(value="apoc.map.values(map, [key1,key2,key3,...],[addNullsForMissing]) returns list of values indicated by the keys")
    public List<Object> values(@Name(value="map") Map<String, Object> map, @Name(value="keys", defaultValue="[]") List<String> keys, @Name(value="addNullsForMissing", defaultValue="false") boolean addNullsForMissing) {
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> values = new ArrayList<Object>(keys.size());
        for (String key : keys) {
            if (!addNullsForMissing && !map.containsKey(key)) continue;
            values.add(map.get(key));
        }
        return values;
    }

    @UserFunction
    @Description(value="apoc.map.fromValues([key1,value1,key2,value2,...])")
    public Map<String, Object> fromValues(@Name(value="values") List<Object> values) {
        return Util.map(values);
    }

    @UserFunction
    @Description(value="apoc.map.merge(first,second) - merges two maps")
    public Map<String, Object> merge(@Name(value="first") Map<String, Object> first, @Name(value="second") Map<String, Object> second) {
        return Util.merge(first, second);
    }

    @UserFunction
    @Description(value="apoc.map.mergeList([{maps}]) yield value - merges all maps in the list into one")
    public Map<String, Object> mergeList(@Name(value="maps") List<Map<String, Object>> maps) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(maps.size());
        for (Map<String, Object> map : maps) {
            result.putAll(map);
        }
        return result;
    }

    @UserFunction
    @Description(value="apoc.map.get(map,key,[default],[fail=true]) - returns value for key or throws exception if key doesn't exist and no default given")
    public Object get(@Name(value="map") Map<String, Object> map, @Name(value="key") String key, @Name(value="value", defaultValue="null") Object value, @Name(value="fail", defaultValue="true") boolean fail) {
        if (fail && value == null && !map.containsKey(key)) {
            throw new IllegalArgumentException("Key " + key + " is not of one of the existing keys " + map.keySet());
        }
        return map.getOrDefault(key, value);
    }

    @UserFunction
    @Description(value="apoc.map.mget(map,key,[defaults],[fail=true])  - returns list of values for keys or throws exception if one of the key doesn't exist and no default value given at that position")
    public List<Object> mget(@Name(value="map") Map<String, Object> map, @Name(value="keys") List<String> keys, @Name(value="values", defaultValue="[]") List<Object> values, @Name(value="fail", defaultValue="true") boolean fail) {
        if (keys == null || map == null) {
            return null;
        }
        int keySize = keys.size();
        ArrayList<Object> result = new ArrayList<Object>(keySize);
        int valuesSize = values == null ? -1 : values.size();
        for (int i = 0; i < keySize; ++i) {
            result.add(this.get(map, keys.get(i), i < valuesSize ? values.get(i) : null, fail));
        }
        return result;
    }

    @UserFunction
    @Description(value="apoc.map.submap(map,keys,[defaults],[fail=true])  - returns submap for keys or throws exception if one of the key doesn't exist and no default value given at that position")
    public Map<String, Object> submap(@Name(value="map") Map<String, Object> map, @Name(value="keys") List<String> keys, @Name(value="values", defaultValue="[]") List<Object> values, @Name(value="fail", defaultValue="true") boolean fail) {
        if (keys == null || map == null) {
            return null;
        }
        int keySize = keys.size();
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(keySize);
        int valuesSize = values == null ? -1 : values.size();
        for (int i = 0; i < keySize; ++i) {
            String key = keys.get(i);
            result.put(key, this.get(map, key, i < valuesSize ? values.get(i) : null, fail));
        }
        return result;
    }

    @UserFunction
    @Description(value="apoc.map.setKey(map,key,value)")
    public Map<String, Object> setKey(@Name(value="map") Map<String, Object> map, @Name(value="key") String key, @Name(value="value") Object value) {
        return Util.merge(map, Util.map(key, value));
    }

    @UserFunction
    @Description(value="apoc.map.setEntry(map,key,value)")
    public Map<String, Object> setEntry(@Name(value="map") Map<String, Object> map, @Name(value="key") String key, @Name(value="value") Object value) {
        return Util.merge(map, Util.map(key, value));
    }

    @UserFunction
    @Description(value="apoc.map.setPairs(map,[[key1,value1],[key2,value2])")
    public Map<String, Object> setPairs(@Name(value="map") Map<String, Object> map, @Name(value="pairs") List<List<Object>> pairs) {
        return Util.merge(map, Util.mapFromPairs(pairs));
    }

    @UserFunction
    @Description(value="apoc.map.setLists(map,[keys],[values])")
    public Map<String, Object> setLists(@Name(value="map") Map<String, Object> map, @Name(value="keys") List<String> keys, @Name(value="values") List<Object> values) {
        return Util.merge(map, Util.mapFromLists(keys, values));
    }

    @UserFunction
    @Description(value="apoc.map.setValues(map,[key1,value1,key2,value2])")
    public Map<String, Object> setValues(@Name(value="map") Map<String, Object> map, @Name(value="pairs") List<Object> pairs) {
        return Util.merge(map, Util.map(pairs));
    }

    @UserFunction
    @Description(value="apoc.map.removeKey(map,key,{recursive:true/false}) - remove the key from the map (recursively if recursive is true)")
    public Map<String, Object> removeKey(@Name(value="map") Map<String, Object> map, @Name(value="key") String key, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        if (!map.containsKey(key)) {
            return map;
        }
        return this.removeKeys(map, Collections.singletonList(key), config);
    }

    @UserFunction
    @Description(value="apoc.map.removeKeys(map,[keys],{recursive:true/false}) - remove the keys from the map (recursively if recursive is true)")
    public Map<String, Object> removeKeys(@Name(value="map") Map<String, Object> map, @Name(value="keys") List<String> keys, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>(map);
        res.keySet().removeAll(keys);
        Map<Object, Object> checkedConfig = config == null ? Collections.emptyMap() : config;
        boolean removeRecursively = Util.toBoolean(checkedConfig.getOrDefault("recursive", false));
        if (removeRecursively) {
            Iterator iterator = res.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (entry.getValue() instanceof Map) {
                    Map<String, Object> updatedMap = this.removeKeys((Map)entry.getValue(), keys, checkedConfig);
                    if (updatedMap.isEmpty()) {
                        iterator.remove();
                        continue;
                    }
                    if (updatedMap.equals(entry.getValue())) continue;
                    entry.setValue(updatedMap);
                    continue;
                }
                if (!(entry.getValue() instanceof Collection)) continue;
                Collection values = (Collection)entry.getValue();
                List updatedValues = values.stream().map(value -> value instanceof Map ? this.removeKeys((Map<String, Object>)value, keys, (Map<String, Object>)checkedConfig) : value).filter(value -> value instanceof Map ? !((Map)value).isEmpty() : true).collect(Collectors.toList());
                if (updatedValues.isEmpty()) {
                    iterator.remove();
                    continue;
                }
                entry.setValue(updatedValues);
            }
        }
        return res;
    }

    @UserFunction
    @Description(value="apoc.map.clean(map,[skip,keys],[skip,values]) yield map filters the keys and values contained in those lists, good for data cleaning from CSV/JSON")
    public Map<String, Object> clean(@Name(value="map") Map<String, Object> map, @Name(value="keys") List<String> keys, @Name(value="values") List<Object> values) {
        HashSet<String> keySet = new HashSet<String>(keys);
        HashSet<Object> valueSet = new HashSet<Object>(values);
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (keySet.contains(entry.getKey()) || value == null || valueSet.contains(value) || valueSet.contains(value.toString())) continue;
            res.put(entry.getKey(), value);
        }
        return res;
    }

    @UserFunction
    @Description(value="apoc.map.updateTree(tree,key,[[value,{data}]]) returns map - adds the {data} map on each level of the nested tree, where the key-value pairs match")
    public Map<String, Object> updateTree(@Name(value="tree") Map<String, Object> tree, @Name(value="key") String key, @Name(value="data") List<List<Object>> data) {
        HashMap<Object, Map> map = new HashMap<Object, Map>(data.size());
        for (List<Object> datum : data) {
            if (datum.size() < 2 || !(datum.get(1) instanceof Map)) {
                throw new IllegalArgumentException("Wrong data list entry: " + datum);
            }
            map.put(datum.get(0), (Map)datum.get(1));
        }
        return this.visit(tree, m -> {
            Map entry = (Map)map.get(m.get(key));
            if (entry != null) {
                m.putAll(entry);
            }
            return m;
        });
    }

    Map<String, Object> visit(Map<String, Object> tree, Function<Map<String, Object>, Map<String, Object>> mapper) {
        Map<String, Object> result = mapper.apply(new LinkedHashMap<String, Object>(tree));
        result.entrySet().forEach(e -> {
            if (e.getValue() instanceof List) {
                List list = (List)e.getValue();
                List newList = list.stream().map(v -> {
                    if (v instanceof Map) {
                        Map map = (Map)v;
                        return this.visit(map, mapper);
                    }
                    return v;
                }).collect(Collectors.toList());
                e.setValue(newList);
            } else if (e.getValue() instanceof Map) {
                Map map = (Map)e.getValue();
                e.setValue(this.visit(map, mapper));
            }
        });
        return result;
    }

    @UserFunction
    @Description(value="apoc.map.flatten(map, delimiter:'.') yield map - flattens nested items in map using dot notation")
    public Map<String, Object> flatten(@Name(value="map") Map<String, Object> map, @Name(value="delimiter", defaultValue=".") String delimiter) {
        HashMap<String, Object> flattenedMap = new HashMap<String, Object>();
        this.flattenMapRecursively(flattenedMap, map, "", delimiter == null ? "." : delimiter);
        return flattenedMap;
    }

    private void flattenMapRecursively(Map<String, Object> flattenedMap, Map<String, Object> map, String prefix, String delimiter) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                this.flattenMapRecursively(flattenedMap, (Map)entry.getValue(), prefix + entry.getKey() + delimiter, delimiter);
                continue;
            }
            flattenedMap.put(prefix + entry.getKey(), entry.getValue());
        }
    }

    @UserFunction
    @Description(value="apoc.map.sortedProperties(map, ignoreCase:true) - returns a list of key/value list pairs, with pairs sorted by keys alphabetically, with optional case sensitivity")
    public List<List<Object>> sortedProperties(@Name(value="map") Map<String, Object> map, @Name(value="ignoreCase", defaultValue="true") boolean ignoreCase) {
        ArrayList<List<Object>> sortedProperties = new ArrayList<List<Object>>();
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        if (ignoreCase) {
            Collections.sort(keys, String.CASE_INSENSITIVE_ORDER);
        } else {
            Collections.sort(keys);
        }
        for (String key : keys) {
            sortedProperties.add(Arrays.asList(key, map.get(key)));
        }
        return sortedProperties;
    }
}

