/*
 * Decompiled with CFR 0.152.
 */
package apoc.monitor;

import apoc.result.StoreInfoResult;
import java.io.File;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Procedure;

public class Store {
    @Context
    public GraphDatabaseService db;

    @Procedure
    @Description(value="apoc.monitor.store() returns informations about the sizes of the different parts of the neo4j graph store")
    public Stream<StoreInfoResult> store() {
        Database database = (Database)((GraphDatabaseAPI)this.db).getDependencyResolver().resolveDependency(Database.class);
        DatabaseLayout databaseLayout = database.getDatabaseLayout();
        return Stream.of(new StoreInfoResult(this.getDirectorySize(databaseLayout.getTransactionLogsDirectory()), databaseLayout.propertyStringStore().length(), databaseLayout.propertyArrayStore().length(), databaseLayout.relationshipStore().length(), databaseLayout.propertyStore().length(), this.getDirectorySize(databaseLayout.databaseDirectory()), databaseLayout.nodeStore().length()));
    }

    private long getDirectorySize(File folder) {
        return folder.exists() ? FileUtils.sizeOfDirectory((File)folder) : 0L;
    }
}

