/*
 * Decompiled with CFR 0.152.
 */
package apoc.nlp;

import apoc.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lapoc/nlp/NLPHelperFunctions;", "", "()V", "Companion", "apoc"})
public final class NLPHelperFunctions {
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0001J\u001a\u0010\f\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006J\u001a\u0010\r\u001a\u00020\u00072\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006J2\u0010\u000e\u001a\u00020\u00012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u001a\u0010\u0011\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006J2\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0007J@\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\n2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0007J(\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\t2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010!\u001a\u00020\"J\"\u0010#\u001a\u00020$2\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00062\u0006\u0010%\u001a\u00020\u0007J\u0016\u0010&\u001a\u00020$2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010'\u001a\u00020\u0007J\u0018\u0010&\u001a\u00020$2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010'\u001a\u00020\u0007H\u0002J\u000e\u0010(\u001a\u00020$2\u0006\u0010\u000b\u001a\u00020\u0001\u00a8\u0006)"}, d2={"Lapoc/nlp/NLPHelperFunctions$Companion;", "", "()V", "categoryRelationshipType", "Lorg/neo4j/graphdb/RelationshipType;", "config", "", "", "convert", "", "Lorg/neo4j/graphdb/Node;", "source", "entityRelationshipType", "getNodeProperty", "getSelectedType", "keys", "default", "keyPhraseRelationshipType", "mergeRelationship", "Lorg/neo4j/graphdb/Relationship;", "node", "nodesAndScore", "Lkotlin/Pair;", "", "relationshipType", "relProperty", "Ljava/util/stream/Stream;", "transaction", "Lorg/neo4j/graphdb/Transaction;", "nodeAndScores", "relType", "partition", "nodes", "size", "", "verifyKey", "", "property", "verifyNodeProperty", "nodeProperty", "verifySource", "apoc"})
    public static final class Companion {
        @NotNull
        public final Relationship mergeRelationship(@NotNull Node node2, @NotNull Pair<? extends Node, ? extends Number> nodesAndScore, @NotNull RelationshipType relationshipType, @NotNull String relProperty) {
            Relationship relationship;
            Optional potentialRelationship2;
            Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
            Intrinsics.checkParameterIsNotNull(nodesAndScore, (String)"nodesAndScore");
            Intrinsics.checkParameterIsNotNull((Object)relationshipType, (String)"relationshipType");
            Intrinsics.checkParameterIsNotNull((Object)relProperty, (String)"relProperty");
            Iterable iterable = node2.getRelationships(Direction.OUTGOING, new RelationshipType[]{relationshipType});
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"node.getRelationships(Di\u2026TGOING, relationshipType)");
            Stream existingRelationships = StreamsKt.asStream((Sequence)CollectionsKt.asSequence((Iterable)iterable));
            Optional optional = potentialRelationship2 = existingRelationships.filter((Predicate)new Predicate<Relationship>(nodesAndScore){
                final /* synthetic */ Pair $nodesAndScore;

                public final boolean test(Relationship r) {
                    Relationship relationship = r;
                    Intrinsics.checkExpressionValueIsNotNull((Object)relationship, (String)"r");
                    return Intrinsics.areEqual((Object)relationship.getEndNode(), (Object)((Node)this.$nodesAndScore.getFirst()));
                }
                {
                    this.$nodesAndScore = pair;
                }
            }).findFirst();
            Intrinsics.checkExpressionValueIsNotNull(optional, (String)"potentialRelationship");
            if (optional.isPresent()) {
                Object t = potentialRelationship2.get();
                Intrinsics.checkExpressionValueIsNotNull(t, (String)"potentialRelationship.get()");
                Relationship relationship2 = (Relationship)t;
                Object object = relationship2.getProperty(relProperty);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Number");
                }
                if (((Number)nodesAndScore.getSecond()).doubleValue() > ((Number)object).doubleValue()) {
                    relationship2.setProperty(relProperty, nodesAndScore.getSecond());
                }
                relationship = relationship2;
            } else {
                Relationship relationship3 = node2.createRelationshipTo((Node)nodesAndScore.getFirst(), relationshipType);
                relationship3.setProperty(relProperty, nodesAndScore.getSecond());
                Relationship relationship4 = relationship3;
                relationship = relationship4;
                Intrinsics.checkExpressionValueIsNotNull((Object)relationship4, (String)"relationship");
            }
            return relationship;
        }

        @NotNull
        public final Stream<Relationship> mergeRelationship(@NotNull Transaction transaction, @NotNull Node node2, @NotNull Pair<? extends Node, ? extends Number> nodeAndScores, @NotNull RelationshipType relType, @NotNull String relProperty) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
            Intrinsics.checkParameterIsNotNull(nodeAndScores, (String)"nodeAndScores");
            Intrinsics.checkParameterIsNotNull((Object)relType, (String)"relType");
            Intrinsics.checkParameterIsNotNull((Object)relProperty, (String)"relProperty");
            String cypher = "WITH $startNode as startNode, $endNode as endNode, $score as score\n            MERGE (startNode)-[r:" + Util.quote(relType.name()) + "]->(endNode)\n            \n            FOREACH(ignoreMe In CASE WHEN score > coalesce(r." + relProperty + ", 0.0) THEN [1] ELSE [] END | \n                SET r." + relProperty + " = score\n            )\n   \n            RETURN r";
            Map params = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"startNode", (Object)node2), TuplesKt.to((Object)"endNode", (Object)nodeAndScores.getFirst()), TuplesKt.to((Object)"score", (Object)nodeAndScores.getSecond())});
            Stream stream = transaction.execute(cypher, params).columnAs("r").stream();
            Intrinsics.checkExpressionValueIsNotNull((Object)stream, (String)"transaction.execute(cyph\u2026lationship>(\"r\").stream()");
            return stream;
        }

        @NotNull
        public final RelationshipType entityRelationshipType(@NotNull Map<String, ? extends Object> config) {
            Intrinsics.checkParameterIsNotNull(config, (String)"config");
            Object selectedType = this.getSelectedType(config, CollectionsKt.listOf((Object[])new String[]{"writeRelationshipType", "relationshipType"}), "ENTITY");
            RelationshipType relationshipType = RelationshipType.withName((String)selectedType.toString());
            Intrinsics.checkExpressionValueIsNotNull((Object)relationshipType, (String)"RelationshipType.withName(selectedType.toString())");
            return relationshipType;
        }

        @NotNull
        public final RelationshipType categoryRelationshipType(@NotNull Map<String, ? extends Object> config) {
            Intrinsics.checkParameterIsNotNull(config, (String)"config");
            Object selectedType = this.getSelectedType(config, CollectionsKt.listOf((Object[])new String[]{"writeRelationshipType", "relationshipType"}), "CATEGORY");
            RelationshipType relationshipType = RelationshipType.withName((String)selectedType.toString());
            Intrinsics.checkExpressionValueIsNotNull((Object)relationshipType, (String)"RelationshipType.withName(selectedType.toString())");
            return relationshipType;
        }

        @NotNull
        public final RelationshipType keyPhraseRelationshipType(@NotNull Map<String, ? extends Object> config) {
            Intrinsics.checkParameterIsNotNull(config, (String)"config");
            Object selectedType = this.getSelectedType(config, CollectionsKt.listOf((Object[])new String[]{"writeRelationshipType", "relationshipType"}), "KEY_PHRASE");
            RelationshipType relationshipType = RelationshipType.withName((String)selectedType.toString());
            Intrinsics.checkExpressionValueIsNotNull((Object)relationshipType, (String)"RelationshipType.withName(selectedType.toString())");
            return relationshipType;
        }

        @NotNull
        public final String getNodeProperty(@NotNull Map<String, ? extends Object> config) {
            Intrinsics.checkParameterIsNotNull(config, (String)"config");
            return config.getOrDefault("nodeProperty", "text").toString();
        }

        /*
         * WARNING - void declaration
         */
        private final Object getSelectedType(Map<String, ? extends Object> config, List<String> keys, String string) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = keys;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void key;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object object = config.get(key);
                collection.add(object);
            }
            return CollectionsKt.first((List)CollectionsKt.filterNotNull((Iterable)CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)string)));
        }

        public final void verifySource(@NotNull Object source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Object object = source;
            if (object instanceof Node) {
                return;
            }
            if (object instanceof List) {
                Iterable $this$forEach$iv = (Iterable)source;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv;
                    Object item = element$iv = iterator.next();
                    boolean bl = false;
                    if (item instanceof Node) continue;
                    throw (Throwable)new IllegalArgumentException("`source` must be a node or list of nodes, but was: `" + source + '`');
                }
            } else {
                throw (Throwable)new IllegalArgumentException("`source` must be a node or list of nodes, but was: `" + source + '`');
            }
        }

        public final void verifyNodeProperty(@NotNull Object source, @NotNull String nodeProperty) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Intrinsics.checkParameterIsNotNull((Object)nodeProperty, (String)"nodeProperty");
            Object object = source;
            if (object instanceof Node) {
                this.verifyNodeProperty((Node)source, nodeProperty);
            } else if (object instanceof List) {
                Iterable $this$forEach$iv = (Iterable)source;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv;
                    Object node2 = element$iv = iterator.next();
                    boolean bl = false;
                    Object t = node2;
                    if (t == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.neo4j.graphdb.Node");
                    }
                    Companion.verifyNodeProperty((Node)t, nodeProperty);
                }
            } else {
                throw (Throwable)new IllegalArgumentException("`source` must be a node or list of nodes, but was: `" + source + '`');
            }
        }

        public final void verifyKey(@NotNull Map<String, ? extends Object> config, @NotNull String property) {
            Intrinsics.checkParameterIsNotNull(config, (String)"config");
            Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
            if (!config.containsKey(property)) {
                throw (Throwable)new IllegalArgumentException("Missing parameter `" + property + "`. An API key for the Amazon Comprehend API can be generated from https://docs.aws.amazon.com/sdk-for-java/v1/developer-guide/setup-credentials.html");
            }
        }

        private final void verifyNodeProperty(Node node2, String nodeProperty) {
            if (!node2.hasProperty(nodeProperty)) {
                throw (Throwable)new IllegalArgumentException(node2 + " does not have property `" + nodeProperty + "`. Property can be configured using parameter `nodeProperty`.");
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Node> convert(@NotNull Object source) {
            List list;
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Object object = source;
            if (object instanceof Node) {
                list = CollectionsKt.listOf((Object)source);
            } else if (object instanceof List) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)source;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void item;
                    Object item$iv$iv;
                    Object t = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    void v1 = item;
                    if (v1 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.neo4j.graphdb.Node");
                    }
                    Node node2 = (Node)v1;
                    collection.add(node2);
                }
                list = (List)destination$iv$iv;
            } else {
                throw (Throwable)new IllegalArgumentException("`source` must be a node or list of nodes, but was: `" + source + '`');
            }
            return list;
        }

        @NotNull
        public final List<List<Node>> partition(@NotNull List<? extends Node> nodes, int size) {
            Intrinsics.checkParameterIsNotNull(nodes, (String)"nodes");
            if (size < 1) {
                throw (Throwable)new IllegalArgumentException("size must be >= 1, but was:" + size);
            }
            boolean bl = false;
            List result = new ArrayList();
            for (int count = 0; count < nodes.size(); count += size) {
                result.add(nodes.subList(count, RangesKt.coerceAtMost((int)nodes.size(), (int)(count + size))));
            }
            return result;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

