/*
 * Decompiled with CFR 0.152.
 */
package apoc.nlp.aws;

import apoc.ai.service.AWSClient;
import apoc.nlp.NLPHelperFunctions;
import apoc.nlp.aws.AWSProcedures;
import apoc.nlp.aws.AWSVirtualEntitiesGraph;
import apoc.nlp.aws.AWSVirtualKeyPhrasesGraph;
import apoc.nlp.aws.AWSVirtualSentimentVirtualGraph;
import apoc.nlp.aws.DummyAWSClient;
import apoc.nlp.aws.RealAWSClient;
import apoc.result.NodeWithMapResult;
import apoc.result.VirtualGraph;
import apoc.util.JsonUtil;
import com.amazonaws.services.comprehend.model.BatchDetectEntitiesItemResult;
import com.amazonaws.services.comprehend.model.BatchDetectEntitiesResult;
import com.amazonaws.services.comprehend.model.BatchDetectKeyPhrasesItemResult;
import com.amazonaws.services.comprehend.model.BatchDetectKeyPhrasesResult;
import com.amazonaws.services.comprehend.model.BatchDetectSentimentItemResult;
import com.amazonaws.services.comprehend.model.BatchDetectSentimentResult;
import com.amazonaws.services.comprehend.model.BatchItemError;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nH\u0002J.\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0001\u0010\u000f\u001a\u00020\u00012\u0014\b\u0001\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nH\u0007J.\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\r2\b\b\u0001\u0010\u000f\u001a\u00020\u00012\u0014\b\u0001\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nH\u0007J.\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0001\u0010\u000f\u001a\u00020\u00012\u0014\b\u0001\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nH\u0007J.\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\r2\b\b\u0001\u0010\u000f\u001a\u00020\u00012\u0014\b\u0001\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nH\u0007J.\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0001\u0010\u000f\u001a\u00020\u00012\u0014\b\u0001\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nH\u0007J.\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\r2\b\b\u0001\u0010\u000f\u001a\u00020\u00012\u0014\b\u0001\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nH\u0007R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lapoc/nlp/aws/AWSProcedures;", "", "()V", "log", "Lorg/neo4j/logging/Log;", "tx", "Lorg/neo4j/graphdb/Transaction;", "awsClient", "Lapoc/ai/service/AWSClient;", "config", "", "", "entitiesGraph", "Ljava/util/stream/Stream;", "Lapoc/result/VirtualGraph;", "source", "entitiesStream", "Lapoc/result/NodeWithMapResult;", "keyPhrasesGraph", "keyPhrasesStream", "sentimentGraph", "sentimentStream", "Companion", "apoc"})
public final class AWSProcedures {
    @Context
    @JvmField
    @Nullable
    public Log log;
    @Context
    @JvmField
    @Nullable
    public Transaction tx;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Procedure(value="apoc.nlp.aws.entities.stream", mode=Mode.READ)
    @Description(value="Returns a stream of entities for provided text")
    @NotNull
    public final Stream<NodeWithMapResult> entitiesStream(@Name(value="source") @NotNull Object source, @Name(value="config", defaultValue="{}") @NotNull Map<String, ? extends Object> config) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull(config, (String)"config");
        NLPHelperFunctions.Companion.verifySource(source);
        String nodeProperty = NLPHelperFunctions.Companion.getNodeProperty(config);
        NLPHelperFunctions.Companion.verifyNodeProperty(source, nodeProperty);
        NLPHelperFunctions.Companion.verifyKey(config, "key");
        NLPHelperFunctions.Companion.verifyKey(config, "secret");
        AWSClient client = this.awsClient(config);
        List<Node> convertedSource = NLPHelperFunctions.Companion.convert(source);
        List<List<Node>> batches = NLPHelperFunctions.Companion.partition(convertedSource, 25);
        Iterable $this$mapIndexed$iv = batches;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void batch;
            int n = index$iv$iv++;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            List list = (List)item$iv$iv;
            int n3 = n2;
            Collection collection2 = collection;
            boolean bl2 = false;
            Pair pair = new Pair((Object)batch, (Object)client.entities((List<? extends Node>)batch, (int)index));
            collection2.add(pair);
        }
        Stream<NodeWithMapResult> stream = ((List)destination$iv$iv).stream().flatMap(entitiesStream.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(stream, (String)"batches.mapIndexed { ind\u2026e, result!!) }.stream() }");
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    @Procedure(value="apoc.nlp.aws.entities.graph", mode=Mode.WRITE)
    @Description(value="Creates a (virtual) entity graph for provided text")
    @NotNull
    public final Stream<VirtualGraph> entitiesGraph(@Name(value="source") @NotNull Object source, @Name(value="config", defaultValue="{}") @NotNull Map<String, ? extends Object> config) {
        AWSVirtualEntitiesGraph $dstr$batch$result;
        Iterable $this$mapTo$iv$iv;
        Object object;
        Collection collection;
        Collection collection2;
        Iterable $this$mapIndexedTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull(config, (String)"config");
        NLPHelperFunctions.Companion.verifySource(source);
        String nodeProperty = NLPHelperFunctions.Companion.getNodeProperty(config);
        NLPHelperFunctions.Companion.verifyNodeProperty(source, nodeProperty);
        NLPHelperFunctions.Companion.verifyKey(config, "key");
        NLPHelperFunctions.Companion.verifyKey(config, "secret");
        AWSClient client = this.awsClient(config);
        RelationshipType relationshipType = NLPHelperFunctions.Companion.entityRelationshipType(config);
        Object object2 = config.getOrDefault("writeRelationshipProperty", "score");
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        String relationshipProperty = (String)object2;
        Object object3 = config.getOrDefault("write", (Object)false);
        if (object3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
        }
        boolean storeGraph = (Boolean)object3;
        Object object4 = config.getOrDefault("scoreCutoff", (Object)0.0);
        if (object4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Number");
        }
        Number scoreCutoff = (Number)object4;
        List<Node> convertedSource = NLPHelperFunctions.Companion.convert(source);
        Iterable $this$mapIndexed$iv = NLPHelperFunctions.Companion.partition(convertedSource, 25);
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
            void index;
            void batch;
            int n = index$iv$iv++;
            collection2 = destination$iv$iv;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            List list = (List)item$iv$iv2;
            int n3 = n2;
            collection = collection2;
            boolean bl2 = false;
            object = new Pair((Object)batch, (Object)client.entities((List<? extends Node>)batch, (int)index));
            collection.add(object);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapIndexedTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void batch;
            BatchDetectEntitiesResult result;
            Object item$iv$iv2;
            item$iv$iv2 = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection2 = (List)$dstr$batch$result.component1();
            BatchDetectEntitiesResult batchDetectEntitiesResult = result = (BatchDetectEntitiesResult)$dstr$batch$result.component2();
            if (batchDetectEntitiesResult == null) {
                Intrinsics.throwNpe();
            }
            object = new AWSVirtualEntitiesGraph(batchDetectEntitiesResult, (List<? extends Node>)batch, relationshipType, relationshipProperty, scoreCutoff);
            collection.add(object);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void graph;
            $dstr$batch$result = (AWSVirtualEntitiesGraph)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = storeGraph ? graph.createAndStore(this.tx) : graph.create();
            collection.add(object);
        }
        Stream<VirtualGraph> stream = ((List)destination$iv$iv).stream();
        Intrinsics.checkExpressionValueIsNotNull(stream, (String)"partition(convertedSourc\u2026                .stream()");
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    @Procedure(value="apoc.nlp.aws.keyPhrases.stream", mode=Mode.READ)
    @Description(value="Returns a stream of key phrases for provided text")
    @NotNull
    public final Stream<NodeWithMapResult> keyPhrasesStream(@Name(value="source") @NotNull Object source, @Name(value="config", defaultValue="{}") @NotNull Map<String, ? extends Object> config) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull(config, (String)"config");
        NLPHelperFunctions.Companion.verifySource(source);
        String nodeProperty = NLPHelperFunctions.Companion.getNodeProperty(config);
        NLPHelperFunctions.Companion.verifyNodeProperty(source, nodeProperty);
        NLPHelperFunctions.Companion.verifyKey(config, "key");
        NLPHelperFunctions.Companion.verifyKey(config, "secret");
        AWSClient client = this.awsClient(config);
        List<Node> convertedSource = NLPHelperFunctions.Companion.convert(source);
        List<List<Node>> batches = NLPHelperFunctions.Companion.partition(convertedSource, 25);
        Iterable $this$mapIndexed$iv = batches;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void batch;
            int n = index$iv$iv++;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            List list = (List)item$iv$iv;
            int n3 = n2;
            Collection collection2 = collection;
            boolean bl2 = false;
            Pair pair = new Pair((Object)batch, (Object)client.keyPhrases((List<? extends Node>)batch, (int)index));
            collection2.add(pair);
        }
        Stream<NodeWithMapResult> stream = ((List)destination$iv$iv).stream().flatMap(keyPhrasesStream.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(stream, (String)"batches.mapIndexed { ind\u2026e, result!!) }.stream() }");
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    @Procedure(value="apoc.nlp.aws.keyPhrases.graph", mode=Mode.WRITE)
    @Description(value="Creates a (virtual) key phrases graph for provided text")
    @NotNull
    public final Stream<VirtualGraph> keyPhrasesGraph(@Name(value="source") @NotNull Object source, @Name(value="config", defaultValue="{}") @NotNull Map<String, ? extends Object> config) {
        AWSVirtualKeyPhrasesGraph $dstr$batch$result;
        Iterable $this$mapTo$iv$iv;
        Object object;
        Collection collection;
        Collection collection2;
        Iterable $this$mapIndexedTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull(config, (String)"config");
        NLPHelperFunctions.Companion.verifySource(source);
        String nodeProperty = NLPHelperFunctions.Companion.getNodeProperty(config);
        NLPHelperFunctions.Companion.verifyNodeProperty(source, nodeProperty);
        NLPHelperFunctions.Companion.verifyKey(config, "key");
        NLPHelperFunctions.Companion.verifyKey(config, "secret");
        AWSClient client = this.awsClient(config);
        RelationshipType relationshipType = NLPHelperFunctions.Companion.keyPhraseRelationshipType(config);
        Object object2 = config.getOrDefault("writeRelationshipProperty", "score");
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        String relationshipProperty = (String)object2;
        Object object3 = config.getOrDefault("write", (Object)false);
        if (object3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
        }
        boolean storeGraph = (Boolean)object3;
        Object object4 = config.getOrDefault("scoreCutoff", (Object)0.0);
        if (object4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Number");
        }
        Number scoreCutoff = (Number)object4;
        List<Node> convertedSource = NLPHelperFunctions.Companion.convert(source);
        Iterable $this$mapIndexed$iv = NLPHelperFunctions.Companion.partition(convertedSource, 25);
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
            void index;
            void batch;
            int n = index$iv$iv++;
            collection2 = destination$iv$iv;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            List list = (List)item$iv$iv2;
            int n3 = n2;
            collection = collection2;
            boolean bl2 = false;
            object = new Pair((Object)batch, (Object)client.keyPhrases((List<? extends Node>)batch, (int)index));
            collection.add(object);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapIndexedTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void batch;
            BatchDetectKeyPhrasesResult result;
            Object item$iv$iv2;
            item$iv$iv2 = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection2 = (List)$dstr$batch$result.component1();
            BatchDetectKeyPhrasesResult batchDetectKeyPhrasesResult = result = (BatchDetectKeyPhrasesResult)$dstr$batch$result.component2();
            if (batchDetectKeyPhrasesResult == null) {
                Intrinsics.throwNpe();
            }
            object = new AWSVirtualKeyPhrasesGraph(batchDetectKeyPhrasesResult, (List<? extends Node>)batch, relationshipType, relationshipProperty, scoreCutoff);
            collection.add(object);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void graph;
            $dstr$batch$result = (AWSVirtualKeyPhrasesGraph)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = storeGraph ? graph.createAndStore(this.tx) : graph.create();
            collection.add(object);
        }
        Stream<VirtualGraph> stream = ((List)destination$iv$iv).stream();
        Intrinsics.checkExpressionValueIsNotNull(stream, (String)"partition(convertedSourc\u2026                .stream()");
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    @Procedure(value="apoc.nlp.aws.sentiment.stream", mode=Mode.READ)
    @Description(value="Returns stream of sentiment for items in provided text")
    @NotNull
    public final Stream<NodeWithMapResult> sentimentStream(@Name(value="source") @NotNull Object source, @Name(value="config", defaultValue="{}") @NotNull Map<String, ? extends Object> config) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull(config, (String)"config");
        NLPHelperFunctions.Companion.verifySource(source);
        String nodeProperty = NLPHelperFunctions.Companion.getNodeProperty(config);
        NLPHelperFunctions.Companion.verifyNodeProperty(source, nodeProperty);
        NLPHelperFunctions.Companion.verifyKey(config, "key");
        NLPHelperFunctions.Companion.verifyKey(config, "secret");
        AWSClient client = this.awsClient(config);
        List<Node> convertedSource = NLPHelperFunctions.Companion.convert(source);
        List<List<Node>> batches = NLPHelperFunctions.Companion.partition(convertedSource, 25);
        Iterable $this$mapIndexed$iv = batches;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void batch;
            int n = index$iv$iv++;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            List list = (List)item$iv$iv;
            int n3 = n2;
            Collection collection2 = collection;
            boolean bl2 = false;
            Pair pair = new Pair((Object)batch, (Object)client.sentiment((List<? extends Node>)batch, (int)index));
            collection2.add(pair);
        }
        Stream<NodeWithMapResult> stream = ((List)destination$iv$iv).stream().flatMap(sentimentStream.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(stream, (String)"batches.mapIndexed { ind\u2026e, result!!) }.stream() }");
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    @Procedure(value="apoc.nlp.aws.sentiment.graph", mode=Mode.WRITE)
    @Description(value="Creates a (virtual) sentiment graph for provided text")
    @NotNull
    public final Stream<VirtualGraph> sentimentGraph(@Name(value="source") @NotNull Object source, @Name(value="config", defaultValue="{}") @NotNull Map<String, ? extends Object> config) {
        AWSVirtualSentimentVirtualGraph $dstr$batch$result;
        Iterable $this$mapTo$iv$iv;
        Object object;
        Collection collection;
        Collection collection2;
        Iterable $this$mapIndexedTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull(config, (String)"config");
        NLPHelperFunctions.Companion.verifySource(source);
        String nodeProperty = NLPHelperFunctions.Companion.getNodeProperty(config);
        NLPHelperFunctions.Companion.verifyNodeProperty(source, nodeProperty);
        NLPHelperFunctions.Companion.verifyKey(config, "key");
        NLPHelperFunctions.Companion.verifyKey(config, "secret");
        AWSClient client = this.awsClient(config);
        Object object2 = config.getOrDefault("write", (Object)false);
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
        }
        boolean storeGraph = (Boolean)object2;
        List<Node> convertedSource = NLPHelperFunctions.Companion.convert(source);
        Iterable $this$mapIndexed$iv = NLPHelperFunctions.Companion.partition(convertedSource, 25);
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
            void index;
            void batch;
            int n = index$iv$iv++;
            collection2 = destination$iv$iv;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            List list = (List)item$iv$iv2;
            int n3 = n2;
            collection = collection2;
            boolean bl2 = false;
            object = new Pair((Object)batch, (Object)client.sentiment((List<? extends Node>)batch, (int)index));
            collection.add(object);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapIndexedTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void batch;
            BatchDetectSentimentResult result;
            Object item$iv$iv2;
            item$iv$iv2 = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection2 = (List)$dstr$batch$result.component1();
            BatchDetectSentimentResult batchDetectSentimentResult = result = (BatchDetectSentimentResult)$dstr$batch$result.component2();
            if (batchDetectSentimentResult == null) {
                Intrinsics.throwNpe();
            }
            object = new AWSVirtualSentimentVirtualGraph(batchDetectSentimentResult, (List<? extends Node>)batch);
            collection.add(object);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void graph;
            $dstr$batch$result = (AWSVirtualSentimentVirtualGraph)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = storeGraph ? graph.createAndStore(this.tx) : graph.create();
            collection.add(object);
        }
        Stream<VirtualGraph> stream = ((List)destination$iv$iv).stream();
        Intrinsics.checkExpressionValueIsNotNull(stream, (String)"partition(convertedSourc\u2026                .stream()");
        return stream;
    }

    private final AWSClient awsClient(Map<String, ? extends Object> config) {
        AWSClient aWSClient;
        Object object = config.getOrDefault("unsupportedDummyClient", (Object)false);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
        }
        boolean useDummyClient = (Boolean)object;
        if (useDummyClient) {
            Log log = this.log;
            if (log == null) {
                Intrinsics.throwNpe();
            }
            aWSClient = new DummyAWSClient(config, log);
        } else {
            Log log = this.log;
            if (log == null) {
                Intrinsics.throwNpe();
            }
            aWSClient = new RealAWSClient(config, log);
        }
        return aWSClient;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000bJ\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lapoc/nlp/aws/AWSProcedures$Companion;", "", "()V", "transformResults", "Lapoc/result/NodeWithMapResult;", "index", "", "node", "Lorg/neo4j/graphdb/Node;", "res", "Lcom/amazonaws/services/comprehend/model/BatchDetectEntitiesResult;", "Lcom/amazonaws/services/comprehend/model/BatchDetectKeyPhrasesResult;", "Lcom/amazonaws/services/comprehend/model/BatchDetectSentimentResult;", "apoc"})
    public static final class Companion {
        @NotNull
        public final NodeWithMapResult transformResults(int index, @NotNull Node node2, @NotNull BatchDetectEntitiesResult res) {
            NodeWithMapResult nodeWithMapResult;
            Object v3;
            block6: {
                Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
                Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
                List list = res.getResultList();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"res.resultList");
                Iterable iterable = list;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object object : iterable2) {
                    BatchDetectEntitiesItemResult result = (BatchDetectEntitiesItemResult)object;
                    boolean bl3 = false;
                    BatchDetectEntitiesItemResult batchDetectEntitiesItemResult = result;
                    Intrinsics.checkExpressionValueIsNotNull((Object)batchDetectEntitiesItemResult, (String)"result");
                    Integer n = batchDetectEntitiesItemResult.getIndex();
                    if (!(n != null && n == index)) continue;
                    v3 = object;
                    break block6;
                }
                v3 = null;
            }
            BatchDetectEntitiesItemResult result = v3;
            if (result != null) {
                ObjectMapper objectMapper = JsonUtil.OBJECT_MAPPER;
                if (objectMapper == null) {
                    Intrinsics.throwNpe();
                }
                Map map = objectMapper.convertValue((Object)result, Map.class);
                if (map == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                }
                NodeWithMapResult nodeWithMapResult2 = NodeWithMapResult.withResult(node2, map);
                nodeWithMapResult = nodeWithMapResult2;
                Intrinsics.checkExpressionValueIsNotNull((Object)nodeWithMapResult2, (String)"NodeWithMapResult.withRe\u2026va) as Map<String, Any?>)");
            } else {
                Object v11;
                block7: {
                    List list = res.getErrorList();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"res.errorList");
                    Iterable iterable = list;
                    boolean bl = false;
                    Iterable iterable3 = iterable;
                    boolean bl4 = false;
                    for (Object e : iterable3) {
                        BatchItemError error = (BatchItemError)e;
                        boolean bl5 = false;
                        BatchItemError batchItemError = error;
                        Intrinsics.checkExpressionValueIsNotNull((Object)batchItemError, (String)"error");
                        Integer n = batchItemError.getIndex();
                        if (!(n != null && n == index)) continue;
                        v11 = e;
                        break block7;
                    }
                    v11 = null;
                }
                BatchItemError err = v11;
                Pair[] pairArray = new Pair[2];
                BatchItemError batchItemError = err;
                pairArray[0] = TuplesKt.to((Object)"code", (Object)(batchItemError != null ? batchItemError.getErrorCode() : null));
                BatchItemError batchItemError2 = err;
                pairArray[1] = TuplesKt.to((Object)"message", (Object)(batchItemError2 != null ? batchItemError2.getErrorMessage() : null));
                NodeWithMapResult nodeWithMapResult3 = NodeWithMapResult.withError(node2, MapsKt.mapOf((Pair[])pairArray));
                nodeWithMapResult = nodeWithMapResult3;
                Intrinsics.checkExpressionValueIsNotNull((Object)nodeWithMapResult3, (String)"NodeWithMapResult.withEr\u2026e\" to err?.errorMessage))");
            }
            return nodeWithMapResult;
        }

        @NotNull
        public final NodeWithMapResult transformResults(int index, @NotNull Node node2, @NotNull BatchDetectKeyPhrasesResult res) {
            NodeWithMapResult nodeWithMapResult;
            Object v3;
            block6: {
                Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
                Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
                List list = res.getResultList();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"res.resultList");
                Iterable iterable = list;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object object : iterable2) {
                    BatchDetectKeyPhrasesItemResult result = (BatchDetectKeyPhrasesItemResult)object;
                    boolean bl3 = false;
                    BatchDetectKeyPhrasesItemResult batchDetectKeyPhrasesItemResult = result;
                    Intrinsics.checkExpressionValueIsNotNull((Object)batchDetectKeyPhrasesItemResult, (String)"result");
                    Integer n = batchDetectKeyPhrasesItemResult.getIndex();
                    if (!(n != null && n == index)) continue;
                    v3 = object;
                    break block6;
                }
                v3 = null;
            }
            BatchDetectKeyPhrasesItemResult result = v3;
            if (result != null) {
                ObjectMapper objectMapper = JsonUtil.OBJECT_MAPPER;
                if (objectMapper == null) {
                    Intrinsics.throwNpe();
                }
                Map map = objectMapper.convertValue((Object)result, Map.class);
                if (map == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                }
                NodeWithMapResult nodeWithMapResult2 = NodeWithMapResult.withResult(node2, map);
                nodeWithMapResult = nodeWithMapResult2;
                Intrinsics.checkExpressionValueIsNotNull((Object)nodeWithMapResult2, (String)"NodeWithMapResult.withRe\u2026va) as Map<String, Any?>)");
            } else {
                Object v11;
                block7: {
                    List list = res.getErrorList();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"res.errorList");
                    Iterable iterable = list;
                    boolean bl = false;
                    Iterable iterable3 = iterable;
                    boolean bl4 = false;
                    for (Object e : iterable3) {
                        BatchItemError error = (BatchItemError)e;
                        boolean bl5 = false;
                        BatchItemError batchItemError = error;
                        Intrinsics.checkExpressionValueIsNotNull((Object)batchItemError, (String)"error");
                        Integer n = batchItemError.getIndex();
                        if (!(n != null && n == index)) continue;
                        v11 = e;
                        break block7;
                    }
                    v11 = null;
                }
                BatchItemError err = v11;
                Pair[] pairArray = new Pair[2];
                BatchItemError batchItemError = err;
                pairArray[0] = TuplesKt.to((Object)"code", (Object)(batchItemError != null ? batchItemError.getErrorCode() : null));
                BatchItemError batchItemError2 = err;
                pairArray[1] = TuplesKt.to((Object)"message", (Object)(batchItemError2 != null ? batchItemError2.getErrorMessage() : null));
                NodeWithMapResult nodeWithMapResult3 = NodeWithMapResult.withError(node2, MapsKt.mapOf((Pair[])pairArray));
                nodeWithMapResult = nodeWithMapResult3;
                Intrinsics.checkExpressionValueIsNotNull((Object)nodeWithMapResult3, (String)"NodeWithMapResult.withEr\u2026e\" to err?.errorMessage))");
            }
            return nodeWithMapResult;
        }

        @NotNull
        public final NodeWithMapResult transformResults(int index, @NotNull Node node2, @NotNull BatchDetectSentimentResult res) {
            NodeWithMapResult nodeWithMapResult;
            Object v3;
            block6: {
                Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
                Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
                List list = res.getResultList();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"res.resultList");
                Iterable iterable = list;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object object : iterable2) {
                    BatchDetectSentimentItemResult result = (BatchDetectSentimentItemResult)object;
                    boolean bl3 = false;
                    BatchDetectSentimentItemResult batchDetectSentimentItemResult = result;
                    Intrinsics.checkExpressionValueIsNotNull((Object)batchDetectSentimentItemResult, (String)"result");
                    Integer n = batchDetectSentimentItemResult.getIndex();
                    if (!(n != null && n == index)) continue;
                    v3 = object;
                    break block6;
                }
                v3 = null;
            }
            BatchDetectSentimentItemResult result = v3;
            if (result != null) {
                ObjectMapper objectMapper = JsonUtil.OBJECT_MAPPER;
                if (objectMapper == null) {
                    Intrinsics.throwNpe();
                }
                Map map = objectMapper.convertValue((Object)result, Map.class);
                if (map == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                }
                NodeWithMapResult nodeWithMapResult2 = NodeWithMapResult.withResult(node2, map);
                nodeWithMapResult = nodeWithMapResult2;
                Intrinsics.checkExpressionValueIsNotNull((Object)nodeWithMapResult2, (String)"NodeWithMapResult.withRe\u2026va) as Map<String, Any?>)");
            } else {
                Object v11;
                block7: {
                    List list = res.getErrorList();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"res.errorList");
                    Iterable iterable = list;
                    boolean bl = false;
                    Iterable iterable3 = iterable;
                    boolean bl4 = false;
                    for (Object e : iterable3) {
                        BatchItemError error = (BatchItemError)e;
                        boolean bl5 = false;
                        BatchItemError batchItemError = error;
                        Intrinsics.checkExpressionValueIsNotNull((Object)batchItemError, (String)"error");
                        Integer n = batchItemError.getIndex();
                        if (!(n != null && n == index)) continue;
                        v11 = e;
                        break block7;
                    }
                    v11 = null;
                }
                BatchItemError err = v11;
                Pair[] pairArray = new Pair[2];
                BatchItemError batchItemError = err;
                pairArray[0] = TuplesKt.to((Object)"code", (Object)(batchItemError != null ? batchItemError.getErrorCode() : null));
                BatchItemError batchItemError2 = err;
                pairArray[1] = TuplesKt.to((Object)"message", (Object)(batchItemError2 != null ? batchItemError2.getErrorMessage() : null));
                NodeWithMapResult nodeWithMapResult3 = NodeWithMapResult.withError(node2, MapsKt.mapOf((Pair[])pairArray));
                nodeWithMapResult = nodeWithMapResult3;
                Intrinsics.checkExpressionValueIsNotNull((Object)nodeWithMapResult3, (String)"NodeWithMapResult.withEr\u2026e\" to err?.errorMessage))");
            }
            return nodeWithMapResult;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

