/*
 * Decompiled with CFR 0.152.
 */
package apoc.number;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Locale;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;

public class Numbers {
    @UserFunction
    @Description(value="apoc.number.format(number)  | format a long or double using the default system pattern and language to produce a string")
    public String format(@Name(value="number") Object value, @Name(value="pattern", defaultValue="") String pattern, @Name(value="lang", defaultValue="") String lang) {
        Number number = this.validateNumberParam(value);
        if (number == null) {
            return null;
        }
        DecimalFormat format = this.buildFormatter(pattern, lang);
        if (format == null) {
            return null;
        }
        return format.format(number);
    }

    @UserFunction(value="apoc.number.parseInt")
    @Description(value="apoc.number.parseInt(text)  | parse a text using the default system pattern and language to produce a long")
    public Long parseInt(@Name(value="text") String text, @Name(value="pattern", defaultValue="") String pattern, @Name(value="lang", defaultValue="") String lang) {
        Number res = this.parseNumber(text, pattern, lang);
        return res == null ? null : Long.valueOf(res.longValue());
    }

    private Number parseNumber(@Name(value="text") String text, @Name(value="pattern", defaultValue="") String pattern, @Name(value="lang", defaultValue="") String lang) {
        try {
            return this.buildFormatter(pattern, lang).parse(text);
        }
        catch (ParseException e) {
            return null;
        }
    }

    @UserFunction(value="apoc.number.parseFloat")
    @Description(value="apoc.number.parseFloat(text)  | parse a text using the default system pattern and language to produce a double")
    public Double parseFloat(@Name(value="text") String text, @Name(value="pattern", defaultValue="") String pattern, @Name(value="lang", defaultValue="") String lang) {
        Number res = this.parseNumber(text, pattern, lang);
        return res == null ? null : Double.valueOf(res.doubleValue());
    }

    private Number validateNumberParam(Object number) {
        return number instanceof Number ? (Number)((Number)number) : (Number)null;
    }

    private DecimalFormat buildFormatter(String pattern, String language) {
        if ("".equals(pattern)) {
            pattern = null;
        }
        if ("".equals(language)) {
            language = "en";
        }
        Locale locale = null;
        if (language != null) {
            if (!Arrays.asList(Locale.getISOLanguages()).contains(language)) {
                return null;
            }
            locale = new Locale(language);
        }
        DecimalFormatSymbols symbols = null;
        if (locale != null) {
            symbols = new DecimalFormatSymbols(locale);
        }
        DecimalFormat format = null;
        if (pattern == null && symbols == null) {
            format = new DecimalFormat();
        } else if (pattern == null) {
            format = new DecimalFormat();
            format.setDecimalFormatSymbols(symbols);
        } else {
            format = symbols == null ? new DecimalFormat(pattern) : new DecimalFormat(pattern, symbols);
        }
        return format;
    }
}

