/*
 * Decompiled with CFR 0.152.
 */
package apoc.path;

import apoc.path.LabelMatcherGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluator;

public class LabelSequenceEvaluator
implements Evaluator {
    private List<LabelMatcherGroup> sequenceMatchers;
    private Evaluation whitelistAllowedEvaluation;
    private boolean endNodesOnly;
    private boolean filterStartNode;
    private boolean beginSequenceAtStart;
    private long minLevel = -1L;

    public LabelSequenceEvaluator(String labelSequence, boolean filterStartNode, boolean beginSequenceAtStart, int minLevel) {
        List<String> labelSequenceList = labelSequence != null && !labelSequence.isEmpty() ? Arrays.asList(labelSequence.split(",")) : Collections.emptyList();
        this.initialize(labelSequenceList, filterStartNode, beginSequenceAtStart, minLevel);
    }

    public LabelSequenceEvaluator(List<String> labelSequenceList, boolean filterStartNode, boolean beginSequenceAtStart, int minLevel) {
        this.initialize(labelSequenceList, filterStartNode, beginSequenceAtStart, minLevel);
    }

    private void initialize(List<String> labelSequenceList, boolean filterStartNode, boolean beginSequenceAtStart, int minLevel) {
        this.filterStartNode = filterStartNode;
        this.beginSequenceAtStart = beginSequenceAtStart;
        this.minLevel = minLevel;
        this.sequenceMatchers = new ArrayList<LabelMatcherGroup>(labelSequenceList.size());
        for (String labelFilterString : labelSequenceList) {
            LabelMatcherGroup matcherGroup = new LabelMatcherGroup().addLabels(labelFilterString.trim());
            this.sequenceMatchers.add(matcherGroup);
            this.endNodesOnly = this.endNodesOnly || matcherGroup.isEndNodesOnly();
        }
        if (this.endNodesOnly) {
            for (LabelMatcherGroup group : this.sequenceMatchers) {
                group.setEndNodesOnly(this.endNodesOnly);
            }
        }
        this.whitelistAllowedEvaluation = this.endNodesOnly ? Evaluation.EXCLUDE_AND_CONTINUE : Evaluation.INCLUDE_AND_CONTINUE;
    }

    public Evaluation evaluate(Path path) {
        boolean belowMinLevel;
        int depth = path.length();
        Node node2 = path.endNode();
        boolean bl = belowMinLevel = (long)depth < this.minLevel;
        if (!(depth != 0 || this.filterStartNode && this.beginSequenceAtStart)) {
            return this.whitelistAllowedEvaluation;
        }
        LabelMatcherGroup matcherGroup = this.sequenceMatchers.get((this.beginSequenceAtStart ? depth : depth - 1) % this.sequenceMatchers.size());
        return matcherGroup.evaluate(node2, belowMinLevel);
    }
}

