/*
 * Decompiled with CFR 0.152.
 */
package apoc.path;

import apoc.path.RelationshipTypeAndDirections;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.NestingIterator;
import org.neo4j.internal.helpers.collection.Pair;

public class RelationshipSequenceExpander
implements PathExpander {
    private final List<List<Pair<RelationshipType, Direction>>> relSequences = new ArrayList<List<Pair<RelationshipType, Direction>>>();
    private List<Pair<RelationshipType, Direction>> initialRels = null;

    public RelationshipSequenceExpander(String relSequenceString, boolean beginSequenceAtStart) {
        int index = 0;
        for (String sequenceStep : relSequenceString.split(",")) {
            sequenceStep = sequenceStep.trim();
            List<Pair<RelationshipType, Direction>> relDirIterable = RelationshipTypeAndDirections.parse(sequenceStep);
            ArrayList<Pair<RelationshipType, Direction>> stepRels = new ArrayList<Pair<RelationshipType, Direction>>();
            for (Pair pair : relDirIterable) {
                stepRels.add(pair);
            }
            if (!beginSequenceAtStart && index == 0) {
                this.initialRels = stepRels;
            } else {
                this.relSequences.add(stepRels);
            }
            ++index;
        }
    }

    public RelationshipSequenceExpander(List<String> relSequenceList, boolean beginSequenceAtStart) {
        int index = 0;
        for (String sequenceStep : relSequenceList) {
            sequenceStep = sequenceStep.trim();
            List<Pair<RelationshipType, Direction>> relDirIterable = RelationshipTypeAndDirections.parse(sequenceStep);
            ArrayList<Pair<RelationshipType, Direction>> stepRels = new ArrayList<Pair<RelationshipType, Direction>>();
            for (Pair pair : relDirIterable) {
                stepRels.add(pair);
            }
            if (!beginSequenceAtStart && index == 0) {
                this.initialRels = stepRels;
            } else {
                this.relSequences.add(stepRels);
            }
            ++index;
        }
    }

    public Iterable<Relationship> expand(Path path, BranchState state) {
        final Node node2 = path.endNode();
        int depth = path.length();
        List<Pair<RelationshipType, Direction>> stepRels = depth == 0 && this.initialRels != null ? this.initialRels : this.relSequences.get((this.initialRels == null ? depth : depth - 1) % this.relSequences.size());
        return Iterators.asList((Iterator)new NestingIterator<Relationship, Pair<RelationshipType, Direction>>(stepRels.iterator()){

            protected Iterator<Relationship> createNestedIterator(Pair<RelationshipType, Direction> entry) {
                RelationshipType type = (RelationshipType)entry.first();
                Direction dir = (Direction)entry.other();
                if (type != null) {
                    return (dir == Direction.BOTH ? node2.getRelationships(new RelationshipType[]{type}) : node2.getRelationships(dir, new RelationshipType[]{type})).iterator();
                }
                return (dir == Direction.BOTH ? node2.getRelationships() : node2.getRelationships(dir)).iterator();
            }
        });
    }

    public PathExpander reverse() {
        throw new RuntimeException("Not implemented");
    }
}

