/*
 * Decompiled with CFR 0.152.
 */
package apoc.systemdb;

import apoc.ApocConfig;
import apoc.result.RowResult;
import apoc.result.VirtualNode;
import apoc.result.VirtualRelationship;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class SystemDb {
    @Context
    public ApocConfig apocConfig;

    @Procedure
    public Stream<NodesAndRelationshipsResult> graph() {
        return this.withSystemDbTransaction(tx -> {
            HashMap<Long, VirtualNode> virtualNodes = new HashMap<Long, VirtualNode>();
            for (Node node2 : tx.getAllNodes()) {
                virtualNodes.put(-node2.getId(), new VirtualNode(-node2.getId(), (Label[])Iterables.asArray(Label.class, (Iterable)node2.getLabels()), node2.getAllProperties()));
            }
            List<Relationship> relationships = tx.getAllRelationships().stream().map(rel -> new VirtualRelationship(-rel.getId(), (Node)virtualNodes.get(-rel.getStartNodeId()), (Node)virtualNodes.get(-rel.getEndNodeId()), rel.getType(), rel.getAllProperties())).collect(Collectors.toList());
            return Stream.of(new NodesAndRelationshipsResult(Iterables.asList(virtualNodes.values()), relationships));
        });
    }

    @Procedure
    public Stream<RowResult> execute(@Name(value="DDL command") String command, @Name(value="params", defaultValue="{}") Map<String, Object> params) {
        return this.withSystemDbTransaction(tx -> tx.execute(command, params).stream().map(map -> new RowResult((Map<String, Object>)map)));
    }

    private <T> T withSystemDbTransaction(Function<Transaction, T> function) {
        try (Transaction tx = this.apocConfig.getSystemDb().beginTx();){
            T result = function.apply(tx);
            tx.commit();
            T t = result;
            return t;
        }
    }

    public static class NodesAndRelationshipsResult {
        public List<Node> nodes;
        public List<Relationship> relationships;

        public NodesAndRelationshipsResult(List<Node> nodes, List<Relationship> relationships) {
            this.nodes = nodes;
            this.relationships = relationships;
        }
    }
}

