/*
 * Decompiled with CFR 0.152.
 */
package apoc.util;

import java.lang.reflect.Array;
import java.util.Arrays;

public class SortedArraySet<T extends Comparable<T>> {
    private static final int GROWTH = 10;
    T[] data;
    private int capacity;
    private int size;

    public SortedArraySet(Class<T> type, int capacity) {
        this.capacity = capacity;
        this.size = 0;
        this.data = (Comparable[])Array.newInstance(type, capacity);
    }

    public T get(int idx) {
        return this.data[idx];
    }

    public T find(T key) {
        if (key == null) {
            throw new IllegalArgumentException("lookup key must not be null");
        }
        if (this.size == 0) {
            return null;
        }
        int offset = Arrays.binarySearch(this.data, 0, this.size, key);
        return offset < 0 ? null : (T)this.data[offset];
    }

    public T add(T value) {
        int offset = Arrays.binarySearch(this.data, 0, this.size, value);
        if (offset < 0) {
            int idx = -(offset + 1);
            if (this.size == this.capacity) {
                this.capacity += 10;
                this.data = (Comparable[])Arrays.copyOf(this.data, this.capacity);
            }
            if (idx != this.size) {
                System.arraycopy(this.data, idx, this.data, idx + 1, this.size - idx);
            }
            ++this.size;
            this.data[idx] = value;
            return value;
        }
        return this.data[offset];
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getSize() {
        return this.size;
    }

    public T[] items() {
        return (Comparable[])Arrays.copyOf(this.data, this.size);
    }
}

