/*
 * Decompiled with CFR 0.152.
 */
package apoc.util.s3;

import apoc.util.Util;
import apoc.util.s3.S3Params;
import com.amazonaws.regions.Regions;
import java.net.URL;
import java.util.Map;
import java.util.Objects;

public class S3ParamsExtractor {
    private static final String PROTOCOL = "s3";
    private static final String ACCESS_KEY = "accessKey";
    private static final String SECRET_KEY = "secretKey";

    public static S3Params extract(URL url) throws IllegalArgumentException {
        if (!PROTOCOL.equals(url.getProtocol())) {
            throw new IllegalArgumentException("Unsupported protocol '" + url.getProtocol() + "'");
        }
        String accessKey = null;
        String secretKey = null;
        if (url.getUserInfo() != null) {
            String[] credentials = url.getUserInfo().split(":");
            accessKey = credentials[0];
            secretKey = credentials[1];
        } else {
            Map<String, String> params = Util.getRequestParameter(url.getQuery());
            if (params.containsKey(ACCESS_KEY)) {
                accessKey = params.get(ACCESS_KEY);
            }
            if (params.containsKey(SECRET_KEY)) {
                secretKey = params.get(SECRET_KEY);
            }
        }
        Object endpoint = url.getHost();
        Integer slashIndex = url.getPath().lastIndexOf("/");
        if (slashIndex <= 0) {
            throw new IllegalArgumentException("Invalid url. Must be:\n's3://accessKey:secretKey@endpoint:port/bucket/key' or\n's3://endpoint:port/bucket/key?accessKey=accessKey&secretKey=secretKey'");
        }
        String key = url.getPath().substring(slashIndex + 1);
        String bucket = url.getPath().substring(1, slashIndex);
        String region = null;
        for (Regions r : Regions.values()) {
            if (!((String)endpoint).toLowerCase().contains(r.getName().toLowerCase())) continue;
            region = r.getName().toLowerCase();
        }
        if (Objects.nonNull(region) && !((String)endpoint).contains("amazonaws.com")) {
            endpoint = ((String)endpoint).substring(((String)endpoint).indexOf(".") + 1);
        }
        if (url.getPort() != 80 && url.getPort() != 443 && url.getPort() > 0) {
            endpoint = (String)endpoint + ":" + url.getPort();
        }
        return new S3Params(accessKey, secretKey, (String)endpoint, bucket, key, region);
    }
}

