/*
 * Decompiled with CFR 0.152.
 */
package com.github.javafaker;

import com.github.javafaker.Name;
import com.github.javafaker.Resolver;
import com.github.javafaker.service.FakeValuesServiceInterface;
import com.github.javafaker.service.RandomService;

public class Address {
    private final Resolver resolver;
    private final Name name;
    private final FakeValuesServiceInterface fakeValuesService;
    private final RandomService randomService;

    public Address(Resolver resolver, Name name, FakeValuesServiceInterface fakeValuesService, RandomService randomService) {
        this.resolver = resolver;
        this.name = name;
        this.fakeValuesService = fakeValuesService;
        this.randomService = randomService;
    }

    public String streetName() {
        return this.resolve("address.street_name");
    }

    public String streetAddressNumber() {
        return String.valueOf(this.randomService.nextInt(1000));
    }

    public String streetAddress() {
        return this.resolve("address.street_address");
    }

    public String streetAddress(boolean includeSecondary) {
        String streetAddress = this.resolve("address.street_address");
        if (includeSecondary) {
            streetAddress = streetAddress + " " + this.secondaryAddress();
        }
        return streetAddress;
    }

    public String secondaryAddress() {
        return this.fakeValuesService.numerify(this.fakeValuesService.fetchString("address.secondary_address"));
    }

    public String zipCode() {
        return this.fakeValuesService.bothify(this.fakeValuesService.fetchString("address.postcode"));
    }

    public String streetSuffix() {
        return this.fakeValuesService.fetchString("address.street_suffix");
    }

    public String citySuffix() {
        return this.fakeValuesService.safeFetch("address.city_suffix");
    }

    public String cityPrefix() {
        return this.fakeValuesService.safeFetch("address.city_prefix");
    }

    public String city() {
        return this.resolve("address.city");
    }

    public String cityName() {
        return this.resolve("address.city_name");
    }

    public String state() {
        return this.fakeValuesService.fetchString("address.state");
    }

    public String stateAbbr() {
        return this.fakeValuesService.fetchString("address.state_abbr");
    }

    public String firstName() {
        return this.name.firstName();
    }

    public String lastName() {
        return this.name.lastName();
    }

    public String latitude() {
        return String.format("%.8g", this.randomService.nextDouble() * 180.0 - 90.0);
    }

    public String longitude() {
        return String.format("%.8g", this.randomService.nextDouble() * 360.0 - 180.0);
    }

    public String timeZone() {
        return this.fakeValuesService.fetchString("address.time_zone");
    }

    public String country() {
        return this.fakeValuesService.fetchString("address.country");
    }

    public String countryCode() {
        return this.fakeValuesService.fetchString("address.country_code");
    }

    public String buildingNumber() {
        return this.fakeValuesService.numerify(this.fakeValuesService.fetchString("address.building_number"));
    }

    private String resolve(String key) {
        return this.fakeValuesService.resolve(key, this, this.resolver);
    }
}

