/*
 * Decompiled with CFR 0.152.
 */
package com.github.javafaker;

import com.github.javafaker.Lorem;
import com.github.javafaker.Name;
import com.github.javafaker.service.FakeValuesServiceInterface;
import com.github.javafaker.service.RandomService;
import java.net.IDN;
import org.apache.commons.lang.StringUtils;

public class Internet {
    private final Name name;
    private final Lorem lorem;
    private final FakeValuesServiceInterface fakeValuesService;
    private final RandomService randomService;

    public Internet(Name name, Lorem lorem, FakeValuesServiceInterface fakeValuesService, RandomService randomService) {
        this.name = name;
        this.lorem = lorem;
        this.fakeValuesService = fakeValuesService;
        this.randomService = randomService;
    }

    public String emailAddress() {
        return this.emailAddress(StringUtils.join(new Object[]{this.name.firstName().toLowerCase(), ".", this.name.lastName().toLowerCase()}));
    }

    public String emailAddress(String localPart) {
        return StringUtils.join(new Object[]{localPart, "@", IDN.toASCII(this.fakeValuesService.fetchString("internet.free_email"))});
    }

    public String domainName() {
        return this.domainWord() + "." + this.domainSuffix();
    }

    public String domainWord() {
        return IDN.toASCII(this.name.lastName().toLowerCase().replaceAll("'", ""));
    }

    public String domainSuffix() {
        return this.fakeValuesService.fetchString("internet.domain_suffix");
    }

    public String url() {
        return StringUtils.join(new Object[]{"www", ".", IDN.toASCII(this.name.firstName().toLowerCase().replaceAll("'", "") + "-" + this.domainWord()), ".", this.domainSuffix()});
    }

    public String avatar() {
        return "https://s3.amazonaws.com/uifaces/faces/twitter/" + this.fakeValuesService.fetchString("internet.avatar");
    }

    public String image() {
        String[] dimension = StringUtils.split(this.fakeValuesService.fetchString("internet.image_dimension"), 'x');
        if (dimension.length == 0) {
            return "";
        }
        return this.image(Integer.valueOf(StringUtils.trim(dimension[0])), Integer.valueOf(StringUtils.trim(dimension[1])), this.randomService.nextBoolean(), null);
    }

    public String image(Integer width, Integer height, Boolean gray, String text) {
        return String.format("https://ssl.webpack.de/lorempixel.com/%s%s/%s/%s/%s", gray != false ? "g/" : "", width, height, this.fakeValuesService.fetchString("internet.image_category"), StringUtils.isEmpty(text) ? "" : text);
    }

    public String password() {
        return this.password(8, 16);
    }

    public String password(int minimumLength, int maximumLength) {
        return this.password(minimumLength, maximumLength, false);
    }

    public String password(int minimumLength, int maximumLength, boolean includeUppercase) {
        return this.password(minimumLength, maximumLength, includeUppercase, false);
    }

    public String password(int minimumLength, int maximumLength, boolean includeUppercase, boolean includeSpecial) {
        if (includeSpecial) {
            char[] password = this.lorem.characters(minimumLength, maximumLength, includeUppercase).toCharArray();
            char[] special = new char[]{'!', '@', '#', '$', '%', '^', '&', '*'};
            for (int i = 0; i < this.randomService.nextInt(minimumLength); ++i) {
                password[this.randomService.nextInt((int)password.length)] = special[this.randomService.nextInt(special.length)];
            }
            return new String(password);
        }
        return this.lorem.characters(minimumLength, maximumLength, includeUppercase);
    }
}

