/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPAttributeSchema;
import com.novell.ldap.LDAPAttributeSet;
import com.novell.ldap.LDAPDITContentRuleSchema;
import com.novell.ldap.LDAPDITStructureRuleSchema;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPMatchingRuleSchema;
import com.novell.ldap.LDAPMatchingRuleUseSchema;
import com.novell.ldap.LDAPNameFormSchema;
import com.novell.ldap.LDAPObjectClassSchema;
import com.novell.ldap.LDAPSchemaElement;
import com.novell.ldap.LDAPSyntaxSchema;
import com.novell.ldap.client.Debug;
import com.novell.ldap.client.EnumeratedIterator;
import com.novell.ldap.util.LDAPXMLHandler;
import com.novell.ldap.util.SAXEventMultiplexer;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LDAPSchema
extends LDAPEntry {
    private HashMap[] idTable = new HashMap[8];
    private HashMap[] nameTable = new HashMap[8];
    static final String[] schemaTypeNames = new String[]{"attributeTypes", "objectClasses", "ldapSyntaxes", "nameForms", "dITContentRules", "dITStructureRules", "matchingRules", "matchingRuleUse"};
    static final int ATTRIBUTE = 0;
    static final int OBJECT_CLASS = 1;
    static final int SYNTAX = 2;
    static final int NAME_FORM = 3;
    static final int DITCONTENT = 4;
    static final int DITSTRUCTURE = 5;
    static final int MATCHING = 6;
    static final int MATCHING_USE = 7;

    public LDAPSchema() {
    }

    public LDAPSchema(LDAPEntry ent) {
        super(ent.getDN(), ent.getAttributeSet());
        for (int i = 0; i < schemaTypeNames.length; ++i) {
            this.idTable[i] = new HashMap();
            this.nameTable[i] = new HashMap();
        }
        Iterator itr = super.getAttributeSet().iterator();
        while (itr.hasNext()) {
            String value;
            LDAPAttribute attr = (LDAPAttribute)itr.next();
            String attrName = attr.getName();
            Enumeration enumString = attr.getStringValues();
            if (attrName.equalsIgnoreCase(schemaTypeNames[1])) {
                while (enumString.hasMoreElements()) {
                    LDAPObjectClassSchema classSchema;
                    value = (String)enumString.nextElement();
                    try {
                        classSchema = new LDAPObjectClassSchema(value);
                    }
                    catch (Exception e) {
                        Debug.trace("TraceAll", "fetchSchema could not parse the schema definition:" + value);
                        continue;
                    }
                    this.addElement(1, classSchema);
                }
                continue;
            }
            if (attrName.equalsIgnoreCase(schemaTypeNames[0])) {
                while (enumString.hasMoreElements()) {
                    LDAPAttributeSchema attrSchema;
                    value = (String)enumString.nextElement();
                    try {
                        attrSchema = new LDAPAttributeSchema(value);
                    }
                    catch (Exception e) {
                        Debug.trace("TraceAll", "fetchSchema could not parse the schema definition:" + value);
                        continue;
                    }
                    this.addElement(0, attrSchema);
                }
                continue;
            }
            if (attrName.equalsIgnoreCase(schemaTypeNames[2])) {
                while (enumString.hasMoreElements()) {
                    value = (String)enumString.nextElement();
                    LDAPSyntaxSchema syntaxSchema = new LDAPSyntaxSchema(value);
                    this.addElement(2, syntaxSchema);
                }
                continue;
            }
            if (attrName.equalsIgnoreCase(schemaTypeNames[6])) {
                while (enumString.hasMoreElements()) {
                    value = (String)enumString.nextElement();
                    LDAPMatchingRuleSchema matchingRuleSchema = new LDAPMatchingRuleSchema(value, null);
                    this.addElement(6, matchingRuleSchema);
                }
                continue;
            }
            if (attrName.equalsIgnoreCase(schemaTypeNames[7])) {
                while (enumString.hasMoreElements()) {
                    value = (String)enumString.nextElement();
                    LDAPMatchingRuleUseSchema matchingRuleUseSchema = new LDAPMatchingRuleUseSchema(value);
                    this.addElement(7, matchingRuleUseSchema);
                }
                continue;
            }
            if (attrName.equalsIgnoreCase(schemaTypeNames[4])) {
                while (enumString.hasMoreElements()) {
                    value = (String)enumString.nextElement();
                    LDAPDITContentRuleSchema dITContentRuleSchema = new LDAPDITContentRuleSchema(value);
                    this.addElement(4, dITContentRuleSchema);
                }
                continue;
            }
            if (attrName.equalsIgnoreCase(schemaTypeNames[5])) {
                while (enumString.hasMoreElements()) {
                    value = (String)enumString.nextElement();
                    LDAPDITStructureRuleSchema dITStructureRuleSchema = new LDAPDITStructureRuleSchema(value);
                    this.addElement(5, dITStructureRuleSchema);
                }
                continue;
            }
            if (!attrName.equalsIgnoreCase(schemaTypeNames[3])) continue;
            while (enumString.hasMoreElements()) {
                value = (String)enumString.nextElement();
                LDAPNameFormSchema nameFormSchema = new LDAPNameFormSchema(value);
                this.addElement(3, nameFormSchema);
            }
        }
    }

    private void addElement(int schemaType, LDAPSchemaElement element) {
        this.idTable[schemaType].put(element.getID(), element);
        String[] names = element.getNames();
        for (int i = 0; i < names.length; ++i) {
            this.nameTable[schemaType].put(names[i].toUpperCase(), element);
        }
    }

    private LDAPSchemaElement getSchemaElement(int schemaType, String key) {
        if (key == null || key.equalsIgnoreCase("")) {
            return null;
        }
        char c = key.charAt(0);
        if (c >= '0' && c <= '9') {
            return (LDAPSchemaElement)this.idTable[schemaType].get(key);
        }
        return (LDAPSchemaElement)this.nameTable[schemaType].get(key.toUpperCase());
    }

    public LDAPAttributeSchema getAttributeSchema(String name) {
        return (LDAPAttributeSchema)this.getSchemaElement(0, name);
    }

    public LDAPDITContentRuleSchema getDITContentRuleSchema(String name) {
        return (LDAPDITContentRuleSchema)this.getSchemaElement(4, name);
    }

    public LDAPDITStructureRuleSchema getDITStructureRuleSchema(String name) {
        return (LDAPDITStructureRuleSchema)this.getSchemaElement(5, name);
    }

    public LDAPDITStructureRuleSchema getDITStructureRuleSchema(int ID2) {
        Integer IDKey2 = new Integer(ID2);
        return (LDAPDITStructureRuleSchema)this.idTable[5].get(IDKey2);
    }

    public LDAPMatchingRuleSchema getMatchingRuleSchema(String name) {
        return (LDAPMatchingRuleSchema)this.getSchemaElement(6, name);
    }

    public LDAPMatchingRuleUseSchema getMatchingRuleUseSchema(String name) {
        return (LDAPMatchingRuleUseSchema)this.getSchemaElement(7, name);
    }

    public LDAPNameFormSchema getNameFormSchema(String name) {
        return (LDAPNameFormSchema)this.getSchemaElement(3, name);
    }

    public LDAPObjectClassSchema getObjectClassSchema(String name) {
        return (LDAPObjectClassSchema)this.getSchemaElement(1, name);
    }

    public LDAPSyntaxSchema getSyntaxSchema(String oid) {
        return (LDAPSyntaxSchema)this.getSchemaElement(2, oid);
    }

    public Enumeration getAttributeSchemas() {
        return new EnumeratedIterator(this.idTable[0].values().iterator());
    }

    public Enumeration getDITContentRuleSchemas() {
        return new EnumeratedIterator(this.idTable[4].values().iterator());
    }

    public Enumeration getDITStructureRuleSchemas() {
        return new EnumeratedIterator(this.idTable[5].values().iterator());
    }

    public Enumeration getMatchingRuleSchemas() {
        return new EnumeratedIterator(this.idTable[6].values().iterator());
    }

    public Enumeration getMatchingRuleUseSchemas() {
        return new EnumeratedIterator(this.idTable[7].values().iterator());
    }

    public Enumeration getNameFormSchemas() {
        return new EnumeratedIterator(this.idTable[3].values().iterator());
    }

    public Enumeration getObjectClassSchemas() {
        return new EnumeratedIterator(this.idTable[1].values().iterator());
    }

    public Enumeration getSyntaxSchemas() {
        return new EnumeratedIterator(this.idTable[2].values().iterator());
    }

    public Enumeration getAttributeNames() {
        return new EnumeratedIterator(this.nameTable[0].keySet().iterator());
    }

    public Enumeration getDITContentRuleNames() {
        return new EnumeratedIterator(this.nameTable[4].keySet().iterator());
    }

    public Enumeration getDITStructureRuleNames() {
        return new EnumeratedIterator(this.nameTable[5].keySet().iterator());
    }

    public Enumeration getMatchingRuleNames() {
        return new EnumeratedIterator(this.nameTable[6].keySet().iterator());
    }

    public Enumeration getMatchingRuleUseNames() {
        return new EnumeratedIterator(this.nameTable[7].keySet().iterator());
    }

    public Enumeration getNameFormNames() {
        return new EnumeratedIterator(this.nameTable[3].keySet().iterator());
    }

    public Enumeration getObjectClassNames() {
        return new EnumeratedIterator(this.nameTable[1].keySet().iterator());
    }

    private int getType(LDAPSchemaElement element) {
        if (element instanceof LDAPAttributeSchema) {
            return 0;
        }
        if (element instanceof LDAPObjectClassSchema) {
            return 1;
        }
        if (element instanceof LDAPSyntaxSchema) {
            return 2;
        }
        if (element instanceof LDAPNameFormSchema) {
            return 3;
        }
        if (element instanceof LDAPMatchingRuleSchema) {
            return 6;
        }
        if (element instanceof LDAPMatchingRuleUseSchema) {
            return 7;
        }
        if (element instanceof LDAPDITContentRuleSchema) {
            return 4;
        }
        if (element instanceof LDAPDITStructureRuleSchema) {
            return 5;
        }
        throw new IllegalArgumentException("The specified schema element type is not recognized");
    }

    public static Object readDSML(InputStream input) throws IOException {
        SAXEventMultiplexer xmlreader = new SAXEventMultiplexer();
        xmlreader.setLDAPXMLHandler(LDAPSchema.getXMLHandler("LDAPEntry", null));
        return (LDAPSchema)xmlreader.parseXML(input);
    }

    static LDAPXMLHandler getXMLHandler(String tagname, LDAPXMLHandler parenthandler) {
        return new LDAPXMLHandler(tagname, parenthandler){
            String dn;
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(LDAPAttribute.getXMLHandler("attr", this));
            }

            protected void endElement() {
                LDAPAttributeSet attrset = new LDAPAttributeSet();
                attrset.addAll((Collection)this.valuelist);
                LDAPEntry entry = new LDAPEntry(this.dn, attrset);
                LDAPSchema sch = new LDAPSchema(entry);
                this.setObject(sch);
            }

            protected void addValue(String tag, Object value) {
                if (tag.equals("attr")) {
                    this.valuelist.add(value);
                }
            }

            protected void handleAttributes(Attributes attributes) throws SAXException {
                this.dn = attributes.getValue("dn");
                if (this.dn == null) {
                    throw new SAXException("invalid entry Tag, dn is mandatory element: ");
                }
            }
        };
    }
}

