/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.util;

import com.novell.ldap.LDAPLocalException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.util.DSMLHandler;
import com.novell.ldap.util.LDAPReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DOMReader
implements LDAPReader {
    DSMLHandler handler;
    Element root;
    private int messageIndex = 0;

    public DOMReader(Document dsmlDoc) throws LDAPLocalException {
        this.root = (Element)dsmlDoc.getElementsByTagName("batchRequest").item(0);
        if (this.root == null) {
            this.root = (Element)dsmlDoc.getElementsByTagNameNS("*", "batchResponse").item(0);
        }
        if (this.root == null) {
            throw new IllegalArgumentException("DOMReader: could not locate a batchRequest or batchResponse");
        }
        this.handler = new DSMLHandler();
        this.processNodes(this.root.getParentNode());
    }

    public DOMReader(Element root) throws LDAPLocalException {
        this.root = root;
        String name = root.getLocalName();
        if (name == null) {
            name = root.getNodeName();
        }
        if (!name.equals("batchRequest") && !name.equals("batchResponse")) {
            throw new IllegalArgumentException("DOMReader: specified root element must be a batchRequest or a batchResponse");
        }
        this.handler = new DSMLHandler();
        this.processNodes(root.getParentNode());
    }

    private void processNodes(Node node2) throws LDAPLocalException {
        DomAttributesWrapper wrapper = new DomAttributesWrapper();
        try {
            for (Node curChild = node2.getFirstChild(); curChild != null; curChild = curChild.getNextSibling()) {
                String simpleName = curChild.getLocalName();
                if (simpleName == null) {
                    simpleName = curChild.getNodeName();
                }
                if (curChild instanceof Element) {
                    wrapper.setAttrs(curChild.getAttributes());
                    this.handler.startElement("", simpleName, simpleName, wrapper);
                } else if (curChild instanceof Text) {
                    String value = curChild.getNodeValue();
                    this.handler.characters(value.toCharArray(), 0, value.length());
                }
                this.processNodes(curChild);
                if (!(curChild instanceof Element)) continue;
                this.handler.endElement("", simpleName, simpleName);
            }
        }
        catch (SAXException e) {
            throw new LDAPLocalException("DOMReader error while traversing DOM:", 82, e);
        }
    }

    public String getVersion() {
        return "2.0";
    }

    public boolean isRequest() {
        return this.root.getNodeName().equals("batchRequest");
    }

    public LDAPMessage readMessage() {
        if (this.messageIndex >= this.handler.getQueue().size()) {
            return null;
        }
        return (LDAPMessage)this.handler.getQueue().get(this.messageIndex++);
    }

    public String getBatchRequestID() {
        return this.handler.getBatchRequestID();
    }

    public boolean isParallelProcessing() {
        return this.handler.isParallelProcessing();
    }

    public boolean isResponseUnordered() {
        return this.handler.isResponseUnordered();
    }

    public boolean isResumeOnError() {
        return this.handler.isResumeOnError();
    }

    private static class DomAttributesWrapper
    implements Attributes {
        NamedNodeMap nnm;

        private DomAttributesWrapper() {
        }

        public void setAttrs(NamedNodeMap domAttributes) {
            this.nnm = domAttributes;
        }

        public int getLength() {
            return this.nnm.getLength();
        }

        public String getURI(int index) {
            return this.nnm.item(index).getNamespaceURI();
        }

        public String getLocalName(int index) {
            return this.nnm.item(index).getLocalName();
        }

        public String getQName(int index) {
            Node node2 = this.nnm.item(index);
            return node2.getNamespaceURI() + "." + node2.getLocalName();
        }

        public String getType(int index) {
            return "CDATA";
        }

        public String getValue(int index) {
            return this.nnm.item(index).getNodeValue();
        }

        public int getIndex(String uri, String localPart) {
            return -1;
        }

        public int getIndex(String qName) {
            return -1;
        }

        public String getType(String uri, String localName) {
            return "CDATA";
        }

        public String getType(String qName) {
            return "CDATA";
        }

        public String getValue(String uri, String localName) {
            return this.nnm.getNamedItemNS(uri, localName).getNodeValue();
        }

        public String getValue(String qName) {
            Node node2 = this.nnm.getNamedItem(qName);
            if (node2 == null) {
                return null;
            }
            String value = node2.getNodeValue();
            return value;
        }
    }
}

