/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.bean.BeanField;
import com.opencsv.bean.ComplexFieldMapEntry;
import com.opencsv.bean.FieldMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.ObjectUtils;

public abstract class AbstractFieldMap<I, K, C extends ComplexFieldMapEntry<I, K, T>, T>
implements FieldMap<I, K, C, T> {
    protected Locale errorLocale;
    protected final SortedMap<K, BeanField<T>> simpleMap = new TreeMap<K, BeanField<T>>();
    protected final List<C> complexMapList = new ArrayList<C>();

    public AbstractFieldMap(Locale errorLocale) {
        this.errorLocale = ObjectUtils.defaultIfNull(errorLocale, Locale.getDefault());
    }

    @Override
    public BeanField<T> get(K key) {
        BeanField f = (BeanField)this.simpleMap.get(key);
        ListIterator<C> iterator = this.complexMapList.listIterator();
        while (f == null && iterator.hasNext()) {
            ComplexFieldMapEntry r = (ComplexFieldMapEntry)iterator.next();
            if (!r.contains(key)) continue;
            f = r.getBeanField();
        }
        return f;
    }

    @Override
    public BeanField<T> put(K key, BeanField<T> value) {
        return this.simpleMap.put(key, value);
    }

    @Override
    public Collection<BeanField<T>> values() {
        ArrayList<BeanField<T>> l = new ArrayList<BeanField<T>>(this.simpleMap.size() + this.complexMapList.size());
        l.addAll(this.simpleMap.values());
        for (ComplexFieldMapEntry r : this.complexMapList) {
            l.add(r.getBeanField());
        }
        return l;
    }

    @Override
    public void setErrorLocale(Locale errorLocale) {
        this.errorLocale = ObjectUtils.defaultIfNull(errorLocale, Locale.getDefault());
        for (ComplexFieldMapEntry e : this.complexMapList) {
            e.setErrorLocale(this.errorLocale);
        }
    }
}

