/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationRuntimeException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.ReferenceNodeHandler;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;

final class XMLListReference {
    private final Element element;

    private XMLListReference(Element e) {
        this.element = e;
    }

    public Element getElement() {
        return this.element;
    }

    public static void assignListReference(Map<ImmutableNode, Object> refs, ImmutableNode node2, Element elem) {
        if (refs != null) {
            refs.put(node2, new XMLListReference(elem));
        }
    }

    public static boolean isListNode(ImmutableNode node2, ReferenceNodeHandler handler) {
        if (XMLListReference.hasListReference(node2, handler)) {
            return true;
        }
        ImmutableNode parent = handler.getParent(node2);
        if (parent != null) {
            for (int i = 0; i < handler.getChildrenCount(parent, null); ++i) {
                ImmutableNode child = handler.getChild(parent, i);
                if (!XMLListReference.hasListReference(child, handler) || !XMLListReference.nameEquals(node2, child)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isFirstListItem(ImmutableNode node2, ReferenceNodeHandler handler) {
        ImmutableNode parent = handler.getParent(node2);
        ImmutableNode firstItem = null;
        int idx = 0;
        while (firstItem == null) {
            ImmutableNode child = handler.getChild(parent, idx);
            if (XMLListReference.nameEquals(node2, child)) {
                firstItem = child;
            }
            ++idx;
        }
        return firstItem == node2;
    }

    public static String listValue(ImmutableNode node2, ReferenceNodeHandler nodeHandler, ListDelimiterHandler delimiterHandler) {
        ImmutableNode parent = nodeHandler.getParent(node2);
        List<ImmutableNode> items = nodeHandler.getChildren(parent, node2.getNodeName());
        ArrayList<Object> values = new ArrayList<Object>(items.size());
        for (ImmutableNode n : items) {
            values.add(n.getValue());
        }
        try {
            return String.valueOf(delimiterHandler.escapeList(values, ListDelimiterHandler.NOOP_TRANSFORMER));
        }
        catch (UnsupportedOperationException e) {
            throw new ConfigurationRuntimeException("List handling not supported by the current ListDelimiterHandler! Make sure that the same delimiter handler is used for loading and saving the configuration.", e);
        }
    }

    private static boolean hasListReference(ImmutableNode node2, ReferenceNodeHandler handler) {
        return handler.getReference(node2) instanceof XMLListReference;
    }

    private static boolean nameEquals(ImmutableNode n1, ImmutableNode n2) {
        return StringUtils.equals(n2.getNodeName(), n1.getNodeName());
    }
}

