/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.configuration2.tree.NodeMatcher;
import org.apache.commons.configuration2.tree.NodeNameMatchers;

abstract class AbstractImmutableNodeHandler
implements NodeHandler<ImmutableNode> {
    AbstractImmutableNodeHandler() {
    }

    @Override
    public String nodeName(ImmutableNode node2) {
        return node2.getNodeName();
    }

    @Override
    public Object getValue(ImmutableNode node2) {
        return node2.getValue();
    }

    @Override
    public List<ImmutableNode> getChildren(ImmutableNode node2) {
        return node2.getChildren();
    }

    @Override
    public <C> int getMatchingChildrenCount(ImmutableNode node2, NodeMatcher<C> matcher, C criterion) {
        return this.getMatchingChildren(node2, matcher, criterion).size();
    }

    @Override
    public <C> List<ImmutableNode> getMatchingChildren(ImmutableNode node2, NodeMatcher<C> matcher, C criterion) {
        ArrayList<ImmutableNode> result = new ArrayList<ImmutableNode>(node2.getChildren().size());
        for (ImmutableNode c : node2.getChildren()) {
            if (!matcher.matches(c, this, criterion)) continue;
            result.add(c);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<ImmutableNode> getChildren(ImmutableNode node2, String name) {
        return this.getMatchingChildren(node2, (NodeMatcher)NodeNameMatchers.EQUALS, (Object)name);
    }

    @Override
    public ImmutableNode getChild(ImmutableNode node2, int index) {
        return node2.getChildren().get(index);
    }

    @Override
    public int indexOfChild(ImmutableNode parent, ImmutableNode child) {
        return parent.getChildren().indexOf(child);
    }

    @Override
    public int getChildrenCount(ImmutableNode node2, String name) {
        if (name == null) {
            return node2.getChildren().size();
        }
        return this.getMatchingChildrenCount(node2, (NodeMatcher)NodeNameMatchers.EQUALS, (Object)name);
    }

    @Override
    public Set<String> getAttributes(ImmutableNode node2) {
        return node2.getAttributes().keySet();
    }

    @Override
    public boolean hasAttributes(ImmutableNode node2) {
        return !node2.getAttributes().isEmpty();
    }

    @Override
    public Object getAttributeValue(ImmutableNode node2, String name) {
        return node2.getAttributes().get(name);
    }

    @Override
    public boolean isDefined(ImmutableNode node2) {
        return AbstractImmutableNodeHandler.checkIfNodeDefined(node2);
    }

    static boolean checkIfNodeDefined(ImmutableNode node2) {
        return node2.getValue() != null || !node2.getChildren().isEmpty() || !node2.getAttributes().isEmpty();
    }
}

