/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.partitioning;

import org.apache.commons.math3.geometry.Space;
import org.apache.commons.math3.geometry.partitioning.BSPTree;
import org.apache.commons.math3.geometry.partitioning.Hyperplane;
import org.apache.commons.math3.geometry.partitioning.Region;
import org.apache.commons.math3.geometry.partitioning.Side;
import org.apache.commons.math3.geometry.partitioning.SubHyperplane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InsideFinder<S extends Space> {
    private final Region<S> region;
    private boolean plusFound;
    private boolean minusFound;

    InsideFinder(Region<S> region) {
        this.region = region;
        this.plusFound = false;
        this.minusFound = false;
    }

    public void recurseSides(BSPTree<S> node2, SubHyperplane<S> sub) {
        if (node2.getCut() == null) {
            if (((Boolean)node2.getAttribute()).booleanValue()) {
                this.plusFound = true;
                this.minusFound = true;
            }
            return;
        }
        Hyperplane<S> hyperplane = node2.getCut().getHyperplane();
        SubHyperplane.SplitSubHyperplane<S> split2 = sub.split(hyperplane);
        switch (split2.getSide()) {
            case PLUS: {
                if (node2.getCut().split(sub.getHyperplane()).getSide() == Side.PLUS) {
                    if (!this.region.isEmpty(node2.getMinus())) {
                        this.plusFound = true;
                    }
                } else if (!this.region.isEmpty(node2.getMinus())) {
                    this.minusFound = true;
                }
                if (this.plusFound && this.minusFound) break;
                this.recurseSides(node2.getPlus(), sub);
                break;
            }
            case MINUS: {
                if (node2.getCut().split(sub.getHyperplane()).getSide() == Side.PLUS) {
                    if (!this.region.isEmpty(node2.getPlus())) {
                        this.plusFound = true;
                    }
                } else if (!this.region.isEmpty(node2.getPlus())) {
                    this.minusFound = true;
                }
                if (this.plusFound && this.minusFound) break;
                this.recurseSides(node2.getMinus(), sub);
                break;
            }
            case BOTH: {
                this.recurseSides(node2.getPlus(), split2.getPlus());
                if (this.plusFound && this.minusFound) break;
                this.recurseSides(node2.getMinus(), split2.getMinus());
                break;
            }
            default: {
                if (node2.getCut().getHyperplane().sameOrientationAs(sub.getHyperplane())) {
                    if (node2.getPlus().getCut() != null || ((Boolean)node2.getPlus().getAttribute()).booleanValue()) {
                        this.plusFound = true;
                    }
                    if (node2.getMinus().getCut() == null && !((Boolean)node2.getMinus().getAttribute()).booleanValue()) break;
                    this.minusFound = true;
                    break;
                }
                if (node2.getPlus().getCut() != null || ((Boolean)node2.getPlus().getAttribute()).booleanValue()) {
                    this.minusFound = true;
                }
                if (node2.getMinus().getCut() == null && !((Boolean)node2.getMinus().getAttribute()).booleanValue()) break;
                this.plusFound = true;
            }
        }
    }

    public boolean plusFound() {
        return this.plusFound;
    }

    public boolean minusFound() {
        return this.minusFound;
    }
}

