/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.select;

import java.util.Iterator;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.jsoup.select.NodeFilter;
import org.jsoup.select.NodeVisitor;

public class NodeTraversor {
    private NodeVisitor visitor;

    public NodeTraversor(NodeVisitor visitor) {
        this.visitor = visitor;
    }

    public void traverse(Node root) {
        NodeTraversor.traverse(this.visitor, root);
    }

    public static void traverse(NodeVisitor visitor, Node root) {
        Node node2 = root;
        int depth = 0;
        while (node2 != null) {
            visitor.head(node2, depth);
            if (node2.childNodeSize() > 0) {
                node2 = node2.childNode(0);
                ++depth;
                continue;
            }
            while (node2.nextSibling() == null && depth > 0) {
                visitor.tail(node2, depth);
                node2 = node2.parentNode();
                --depth;
            }
            visitor.tail(node2, depth);
            if (node2 == root) break;
            node2 = node2.nextSibling();
        }
    }

    public static void traverse(NodeVisitor visitor, Elements elements) {
        Validate.notNull(visitor);
        Validate.notNull(elements);
        for (Element el : elements) {
            NodeTraversor.traverse(visitor, el);
        }
    }

    public static NodeFilter.FilterResult filter(NodeFilter filter, Node root) {
        Node node2 = root;
        int depth = 0;
        while (node2 != null) {
            Node prev;
            NodeFilter.FilterResult result = filter.head(node2, depth);
            if (result == NodeFilter.FilterResult.STOP) {
                return result;
            }
            if (result == NodeFilter.FilterResult.CONTINUE && node2.childNodeSize() > 0) {
                node2 = node2.childNode(0);
                ++depth;
                continue;
            }
            while (node2.nextSibling() == null && depth > 0) {
                if ((result == NodeFilter.FilterResult.CONTINUE || result == NodeFilter.FilterResult.SKIP_CHILDREN) && (result = filter.tail(node2, depth)) == NodeFilter.FilterResult.STOP) {
                    return result;
                }
                prev = node2;
                node2 = node2.parentNode();
                --depth;
                if (result == NodeFilter.FilterResult.REMOVE) {
                    prev.remove();
                }
                result = NodeFilter.FilterResult.CONTINUE;
            }
            if ((result == NodeFilter.FilterResult.CONTINUE || result == NodeFilter.FilterResult.SKIP_CHILDREN) && (result = filter.tail(node2, depth)) == NodeFilter.FilterResult.STOP) {
                return result;
            }
            if (node2 == root) {
                return result;
            }
            prev = node2;
            node2 = node2.nextSibling();
            if (result != NodeFilter.FilterResult.REMOVE) continue;
            prev.remove();
        }
        return NodeFilter.FilterResult.CONTINUE;
    }

    public static void filter(NodeFilter filter, Elements elements) {
        Element el;
        Validate.notNull(filter);
        Validate.notNull(elements);
        Iterator iterator = elements.iterator();
        while (iterator.hasNext() && NodeTraversor.filter(filter, el = (Element)iterator.next()) != NodeFilter.FilterResult.STOP) {
        }
    }
}

