/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.export;

import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;

public class DatabaseSubGraph
implements SubGraph {
    private final Transaction transaction;

    public DatabaseSubGraph(Transaction transaction) {
        this.transaction = transaction;
    }

    public static SubGraph from(Transaction transaction) {
        return new DatabaseSubGraph(transaction);
    }

    @Override
    public Iterable<Node> getNodes() {
        return this.transaction.getAllNodes();
    }

    @Override
    public Iterable<Relationship> getRelationships() {
        return this.transaction.getAllRelationships();
    }

    @Override
    public boolean contains(Relationship relationship) {
        return this.transaction.getRelationshipById(relationship.getId()) != null;
    }

    @Override
    public Iterable<IndexDefinition> getIndexes() {
        return this.transaction.schema().getIndexes();
    }

    @Override
    public Iterable<ConstraintDefinition> getConstraints() {
        return this.transaction.schema().getConstraints();
    }
}

